/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.smith.rule;

import java.io.IOException;
import java.util.Map;
import org.pageseeder.smith.PasswordRule;
import org.pageseeder.smith.ScoreFunction;
import org.pageseeder.smith.Scriptable;
import org.pageseeder.smith.function.LinearScore;
import org.pageseeder.smith.function.ScoreArray;

public class QwertyConsecutiveCharRule
implements PasswordRule,
Scriptable {
    private static String[] QUERTY_SEQUENCES = new String[]{"qwertyuiop", "asdfghjkl", "zxcvbnm"};
    private ScoreFunction _function = LinearScore.IDENTITY;

    @Override
    public int score(String password) {
        if (password == null) {
            return 0;
        }
        int count = 0;
        for (String sequence : QUERTY_SEQUENCES) {
            if (sequence.indexOf(password) < 0) continue;
            count = password.length();
        }
        return this._function.get(count);
    }

    @Override
    public void configure(Map<String, String> config) {
        this._function = ScoreArray.parse(config);
    }

    @Override
    public Appendable toScript(Appendable script) throws IOException {
        script.append("function (p) {");
        script.append(" var f = ");
        this._function.toScript(script).append(";");
        script.append(" var q = [");
        for (int i = 0; i < QUERTY_SEQUENCES.length; ++i) {
            if (i > 0) {
                script.append(',');
            }
            script.append('\'').append(QUERTY_SEQUENCES[i]).append('\'');
        }
        script.append("];");
        script.append(" var n = 0;");
        script.append(" for (var i = 0; i < q.length; i++) {");
        script.append(" if (q[i].indexOf(p) >= 0) { n = p.length; }");
        script.append(" }");
        script.append(" return f(n);");
        script.append("}");
        return script;
    }
}

