/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.pdf.ant;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sourceforge.jeuclid.fop.plugin.JEuclidFopFactoryConfigurator;
import org.apache.commons.io.IOUtils;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.configuration.ConfigurationException;
import org.apache.fop.configuration.DefaultConfiguration;
import org.apache.fop.configuration.DefaultConfigurationBuilder;
import org.apache.fop.events.Event;
import org.apache.fop.events.EventFormatter;
import org.apache.fop.events.EventListener;
import org.apache.fop.events.model.EventSeverity;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.pageseeder.pdf.util.XML;
import org.pageseeder.pdf.util.XSLT;

public final class ExportTask
extends Task {
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private boolean debug = false;
    private File _source;
    private File _destination;
    private File _working;
    private File _fontFolder;
    private File _fontConfig;
    private int _resolution = 200;
    private List<FOConfig> _FOConfigs = new ArrayList<FOConfig>();
    private List<FOConfigs> _FOConfigFolders = new ArrayList<FOConfigs>();

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setSrc(File source) {
        if (!source.exists()) {
            throw new BuildException("the document " + source.getName() + " doesn't exist");
        }
        if (source.isDirectory()) {
            throw new BuildException("the document " + source.getName() + " can't be a directory");
        }
        this._source = source;
    }

    public void setDest(File destination) {
        if (destination.exists() && destination.isDirectory()) {
            throw new BuildException("if destination PDF exists, it must be a file");
        }
        this._destination = destination;
    }

    public void setWorking(File working) {
        if (working.exists() && !working.isDirectory()) {
            throw new BuildException("if working folder exists, it must be a directory");
        }
        this._working = working;
    }

    public void setFontFolder(File folder) {
        if (!folder.exists() || !folder.isDirectory()) {
            throw new BuildException("the font folder must exists and must be a directory");
        }
        this._fontFolder = folder;
    }

    public void setFontConfig(File config) {
        if (!config.exists() || config.isDirectory()) {
            throw new BuildException("the font config must exists and must be a file");
        }
        this._fontConfig = config;
    }

    public FOConfigs createConfigs() {
        FOConfigs cfg = new FOConfigs();
        this._FOConfigFolders.add(cfg);
        return cfg;
    }

    public FOConfig createConfig() {
        FOConfig cfg = new FOConfig();
        this._FOConfigs.add(cfg);
        return cfg;
    }

    public void setResolution(int resolution) {
        this._resolution = resolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (!this._FOConfigFolders.isEmpty()) {
            this.log("The 'configs' element under 'export-pdf' is deprecated, please remove it", 1);
        }
        if (this._source == null) {
            throw new BuildException("Source PSML document must be specified using 'src' attribute");
        }
        if (this._working == null) {
            String tmp = "antpdf-" + System.currentTimeMillis();
            this._working = new File(System.getProperty("java.io.tmpdir"), tmp);
        }
        if (!this._working.exists()) {
            this._working.mkdirs();
        }
        if (this._destination == null) {
            this._destination = new File(this._source.getParentFile(), ".pdf");
            this.log("Destination set to " + this._destination.getName());
        }
        this._destination.getParentFile().mkdirs();
        File foConfig = new File(this._working, this._source.getName() + "-FOConfig.xml");
        try {
            this.buildFOConfig(foConfig);
        }
        catch (IOException ex) {
            this.log("Config file generation failed:", 0);
            this.log(ex, 0);
            throw new BuildException("Failed to build FO Config file: " + ex.getMessage());
        }
        Templates templates = XSLT.getTemplatesFromResource((String)"org/pageseeder/pdf/xslt/export.xsl");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("foconfigfileurl", foConfig.toURI().toString());
        parameters.put("base", this._source.getParentFile().toURI().toString());
        parameters.put("source-filename", this._source.getName());
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            StringBuilder config = new StringBuilder();
            config.append("<fop version=\"1.0\">");
            if (this._fontFolder != null) {
                config.append("<font-base>file:///");
                XML.makeXMLSafe((String)this._fontFolder.getAbsolutePath(), (StringBuilder)config);
                config.append("</font-base>");
            }
            if (this._fontConfig != null) {
                config.append("<renderers>");
                config.append("<renderer mime=\"application/pdf\">");
                config.append(new String(Files.readAllBytes(this._fontConfig.toPath()), StandardCharsets.UTF_8));
                config.append("</renderer>");
                config.append("</renderers>");
            }
            config.append("</fop>");
            DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
            DefaultConfiguration cfg = cfgBuilder.build((InputStream)new ByteArrayInputStream(config.toString().getBytes(StandardCharsets.UTF_8)));
            FopFactoryBuilder builder = new FopFactoryBuilder(this._source.getParentFile().toURI()).setConfiguration((Configuration)cfg);
            builder.setSourceResolution((float)this._resolution);
            FopFactory factory = builder.build();
            JEuclidFopFactoryConfigurator.configure((FopFactory)factory);
            FOUserAgent userAgent = factory.newFOUserAgent();
            userAgent.setCreationDate(new Date());
            userAgent.setProducer("PageSeeder ANT PDF Library");
            userAgent.getEventBroadcaster().addEventListener((EventListener)new AntEventListener(this));
            in = new FileInputStream(this._source);
            out = new FileOutputStream(this._destination);
            Fop fop = factory.newFop("application/pdf", userAgent, (OutputStream)out);
            StreamSource source = new StreamSource(new BufferedInputStream(in), this._source.toURI().toString());
            SAXResult result = new SAXResult(fop.getDefaultHandler());
            if (this.debug) {
                ByteArrayOutputStream fo_out = new ByteArrayOutputStream();
                XSLT.transform((Source)source, (Result)new StreamResult(fo_out), (Templates)templates, parameters);
                String fo = new String(fo_out.toByteArray(), UTF8);
                try (FileOutputStream fout = new FileOutputStream(new File(this._working, "fo.xml"));){
                    IOUtils.write((String)fo, (OutputStream)fout, (String)"utf-8");
                }
                catch (Exception ex) {
                    this.log("Unable to save FO document: " + ex.getMessage());
                }
                TransformerFactory tfactory = TransformerFactory.newInstance();
                Transformer transformer = tfactory.newTransformer();
                StreamSource src = new StreamSource(new ByteArrayInputStream(fo.getBytes(UTF8)));
                transformer.transform(src, result);
            } else {
                XSLT.transform((Source)source, (Result)result, (Templates)templates, parameters);
            }
            this.log("PDF successfully generated (" + fop.getResults().getPageCount() + " pages)");
        }
        catch (FOPException ex) {
            this.log("PDF generation failed:", 0);
            this.log(ex, 0);
            throw new BuildException("Failed to build PDF file: " + ex.getMessage());
        }
        catch (IOException | TransformerException | ConfigurationException ex) {
            this.log("PDF generation failed:", 0);
            this.log(ex, 0);
            throw new BuildException("Failed to build PDF file: " + ex.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                this.log("Failed to close stream: {}", ex, 0);
            }
        }
    }

    private void buildFOConfig(File config) throws IOException {
        FileWriter writer = new FileWriter(config);
        writer.write("<foconfigs>\n");
        int highestPriority = this._FOConfigs.stream().filter(c -> ((FOConfig)c)._config != null && ((FOConfig)c)._config.exists()).mapToInt(FOConfig::getPriority).max().orElseGet(() -> 0);
        FOConfig conf = this._FOConfigs.stream().filter(c -> ((FOConfig)c)._config != null && ((FOConfig)c)._config.exists() && c.getPriority() == highestPriority).findFirst().orElse(null);
        if (conf != null && conf._config != null && conf._config.exists()) {
            writer.write("<foconfig config=\"custom\">");
            ExportTask.writeStream(writer, new FileInputStream(conf._config));
            writer.write("</foconfig>\n");
        }
        writer.write("<foconfig config=\"default\">");
        ClassLoader loader = ExportTask.class.getClassLoader();
        InputStream defaultFO = loader.getResourceAsStream("org/pageseeder/pdf/resource/defaultFOConfig.xml");
        if (defaultFO != null) {
            ExportTask.writeStream(writer, defaultFO);
        }
        writer.write("</foconfig>\n");
        writer.write("</foconfigs>");
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeStream(Writer out, InputStream in) throws IOException {
        try {
            int n;
            byte[] buffer = new byte[4096];
            boolean start = true;
            while ((n = in.read(buffer)) != -1) {
                String s = new String(buffer, 0, n, UTF8);
                if (s.startsWith("<?xml") && start) {
                    s = s.substring(s.indexOf(62) + 1);
                }
                out.write(s);
                start = false;
            }
        }
        finally {
            in.close();
        }
    }

    private class AntEventListener
    implements EventListener {
        private Task _task;

        public AntEventListener(Task task) {
            this._task = task;
        }

        public void processEvent(Event event) {
            String msg = EventFormatter.format((Event)event);
            EventSeverity severity = event.getSeverity();
            if (severity == EventSeverity.INFO) {
                this._task.log("[INFO] " + msg, 3);
            } else if (severity == EventSeverity.WARN) {
                if (msg.indexOf("Font \"ZapfDingbats") != -1 && msg.indexOf("Substituting with \"ZapfDingbats") != -1) {
                    return;
                }
                this._task.log("[WARN] " + msg, 3);
            } else if (severity == EventSeverity.ERROR) {
                this._task.log("[ERROR] " + msg, 0);
            } else if (severity == EventSeverity.FATAL) {
                this._task.log("[FATAL] " + msg, 0);
            }
        }
    }

    public static final class FOConfigs {
        private int _priority = 1;
        private File _folder;

        public void setFolder(File folder) {
            if (folder.exists() && folder.isDirectory()) {
                this._folder = folder;
            }
        }

        public void setPriority(int priority) {
            this._priority = priority;
        }
    }

    public static final class FOConfig {
        private File _config;
        private int _priority = 1;

        public void setName(String name) {
        }

        public void setFile(File file) {
            if (file.exists() && !file.isDirectory()) {
                this._config = file;
            }
        }

        public void setPriority(int priority) {
            this._priority = priority;
        }

        public int getPriority() {
            return this._priority;
        }
    }
}

