/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.query;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.pageseeder.flint.lucene.query.SearchParameter;
import org.pageseeder.xmlwriter.XMLWriter;

public final class TermParameter
implements SearchParameter {
    private final Term _term;

    public TermParameter(String field, String text) throws NullPointerException {
        if (field == null) {
            throw new NullPointerException("field");
        }
        if (text == null) {
            throw new NullPointerException("text");
        }
        this._term = new Term(field, text);
    }

    public TermParameter(Term term) throws NullPointerException {
        if (term == null) {
            throw new NullPointerException("term");
        }
        this._term = term;
    }

    @Override
    public boolean isEmpty() {
        return this._term.field().isEmpty();
    }

    public Term term() {
        return this._term;
    }

    @Override
    public Query toQuery() {
        if (this.isEmpty()) {
            return null;
        }
        return new TermQuery(this._term);
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("term-parameter");
        xml.attribute("is-empty", Boolean.toString(this.isEmpty()));
        if (!this.isEmpty()) {
            xml.element("field", this._term.field());
            xml.element("text", this._term.text());
        }
        xml.closeElement();
    }

    public String toString() {
        return this._term.toString();
    }
}

