/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.query;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopFieldDocs;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.indexing.FlintDocument;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.lucene.LuceneIndexIO;
import org.pageseeder.flint.lucene.query.SearchPaging;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.flint.lucene.search.Fields;
import org.pageseeder.flint.lucene.util.Dates;
import org.pageseeder.flint.lucene.util.Highlighter;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SearchResults
implements XMLWritable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchResults.class);
    private static final int MAX_FIELD_VALUE_LENGTH = 1000;
    private static final int ONE_MINUTE_IN_MS = 60000;
    private static final int ONE_HOUR_IN_MS = 3600000;
    private final ScoreDoc[] _scoredocs;
    private final SortField[] _sortfields;
    private final SearchPaging _paging;
    private final SearchQuery _query;
    private final Analyzer _analyzer;
    private final IndexSearcher _searcher;
    private final SearchReaders readers;
    private final List<String> extractFields = new ArrayList<String>();
    private final int totalNbOfResults;
    private boolean _terminated = false;
    private int timezoneOffset;

    public SearchResults(SearchQuery query, TopFieldDocs docs, SearchPaging paging, Map<LuceneIndexIO, IndexReader> readers, IndexSearcher searcher) {
        this(query, null, docs.scoreDocs, docs.fields, (int)docs.totalHits.value, paging, new SearchReaders(readers), searcher);
    }

    public SearchResults(SearchQuery query, TopFieldDocs docs, SearchPaging paging, LuceneIndexIO io, IndexSearcher searcher) {
        this(query, null, docs.scoreDocs, docs.fields, (int)docs.totalHits.value, paging, new SearchReaders(io), searcher);
    }

    public SearchResults(SearchQuery query, ScoreDoc[] docs, int totalHits, SearchPaging paging, LuceneIndexIO io, IndexSearcher searcher) {
        this(query, null, docs, null, totalHits, paging, new SearchReaders(io), searcher);
    }

    public SearchResults(SearchQuery query, ScoreDoc[] docs, int totalHits, SearchPaging paging, Map<LuceneIndexIO, IndexReader> readers, IndexSearcher searcher) {
        this(query, null, docs, null, totalHits, paging, new SearchReaders(readers), searcher);
    }

    public SearchResults(SearchQuery query, Analyzer analyzer, ScoreDoc[] hits, SortField[] sortf, int totalResults, SearchPaging paging, SearchReaders readers, IndexSearcher searcher) {
        this._query = query;
        this._analyzer = analyzer;
        this._scoredocs = hits;
        this._sortfields = sortf;
        this._paging = paging != null ? paging : new SearchPaging();
        this._searcher = searcher;
        this.readers = readers;
        this.totalNbOfResults = totalResults;
        TimeZone tz = TimeZone.getDefault();
        this.timezoneOffset = tz.getRawOffset();
        if (tz.inDaylightTime(new Date())) {
            this.timezoneOffset += 3600000;
        }
    }

    public void addExtractFields(List<String> fields) {
        this.extractFields.addAll(fields);
    }

    public void addExtractField(String field) {
        this.extractFields.add(field);
    }

    public int getTotalNbOfResults() {
        return this.totalNbOfResults;
    }

    public boolean isEmpty() {
        return this.totalNbOfResults == 0;
    }

    public void setTimeZone(int timezoneInMinutes) {
        this.timezoneOffset = timezoneInMinutes * 60000;
    }

    public IndexSearcher searcher() throws IndexException {
        if (this._terminated) {
            throw new IndexException("Cannot retrieve searcher after termination", (Exception)new IllegalStateException());
        }
        return this._searcher;
    }

    public SearchQuery query() {
        return this._query;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("search-results", true);
        int firsthit = this._paging.getFirstHit();
        int lasthit = this._paging.getLastHit(this.totalNbOfResults);
        if (this._query != null) {
            xml.openElement("query", true);
            xml.attribute("lucene", this._query.toQuery().toString());
            this._query.toXML(xml);
            xml.closeElement();
        }
        this.toMetadataXML(xml);
        xml.openElement("documents", true);
        for (int i = firsthit - 1; i < lasthit; ++i) {
            String score = Float.toString(this._scoredocs[i].score);
            Document doc = this._searcher.storedFields().document(this._scoredocs[i].doc);
            String extractXML = null;
            if (this._query != null && this._analyzer != null) {
                Highlighter highlighter = new Highlighter(this._query.toQuery(), this._searcher.getIndexReader(), this._analyzer);
                for (IndexableField f : doc.getFields()) {
                    String extract;
                    if (!this.extractFields.isEmpty() && !this.extractFields.contains(f.name()) || (extract = highlighter.highlight(f.name(), f.stringValue(), 200)) == null) continue;
                    XMLStringWriter xsw = new XMLStringWriter(XML.NamespaceAware.No);
                    xsw.openElement("extract");
                    xsw.attribute("from", f.name());
                    xsw.writeXML(extract);
                    xsw.closeElement();
                    extractXML = xsw.toString();
                    break;
                }
            }
            SearchResults.documentToXML(doc, extractXML, score, this.timezoneOffset, xml);
        }
        xml.closeElement();
        xml.closeElement();
        this.terminate();
    }

    public static void documentToXML(Document doc, int timezoneOffset, XMLWriter xml) throws IOException {
        SearchResults.documentToXML(doc, null, null, timezoneOffset, xml);
    }

    private static void documentToXML(Document doc, String extract, String score, int timezoneOffset, XMLWriter xml) throws IOException {
        xml.openElement("document", true);
        if (score != null) {
            xml.element("score", score);
        }
        if (extract != null) {
            xml.writeXML(extract);
        }
        for (IndexableField f : doc.getFields()) {
            String value = Fields.toString(f);
            ValueType type = ValueType.STRING;
            Number number = f.numericValue();
            if (number != null) {
                if (number instanceof Long) {
                    type = ValueType.LONG;
                } else if (number instanceof Double) {
                    type = ValueType.DOUBLE;
                } else if (number instanceof Integer) {
                    type = ValueType.INT;
                } else if (number instanceof Float) {
                    type = ValueType.FLOAT;
                }
            } else if (value != null && value.length() > 0 && f.name().contains("date") && Dates.isLuceneDate(value)) {
                try {
                    if (value.length() > 8) {
                        value = Dates.toISODateTime(value, timezoneOffset);
                        type = ValueType.DATETIME;
                    } else if ((value = Dates.toISODate(value)).length() == 10) {
                        type = ValueType.DATE;
                    }
                }
                catch (ParseException ex) {
                    LOGGER.warn("Unparseable date found {}", (Object)value);
                }
            }
            if (value == null || value.length() >= 1000) continue;
            xml.openElement("field");
            xml.attribute("name", f.name());
            if (type == ValueType.DATE) {
                xml.attribute("date", value);
            } else if (type == ValueType.DATETIME) {
                xml.attribute("datetime", value);
            } else if (type == ValueType.LONG) {
                xml.attribute("numeric-type", "long");
            } else if (type == ValueType.DOUBLE) {
                xml.attribute("numeric-type", "double");
            } else if (type == ValueType.FLOAT) {
                xml.attribute("numeric-type", "float");
            } else if (type == ValueType.INT) {
                xml.attribute("numeric-type", "int");
            }
            if (f.binaryValue() != null) {
                xml.attribute("compressed", "true");
            }
            xml.writeText(value);
            xml.closeElement();
        }
        xml.closeElement();
    }

    public static void flintDocumentToXML(FlintDocument doc, int timezoneOffset, XMLWriter xml) throws IOException {
        SearchResults.flintDocumentToXML(doc, null, null, timezoneOffset, xml);
    }

    public static void flintDocumentToXML(FlintDocument doc, String extract, String score, int timezoneOffset, XMLWriter xml) throws IOException {
        xml.openElement("result", true);
        if (score != null) {
            xml.attribute("score", score);
        }
        if (extract != null) {
            xml.writeXML(extract);
        }
        for (FlintField f : doc.fields()) {
            String value = f.value() == null ? null : f.value().toString();
            ValueType type = ValueType.STRING;
            FlintField.NumericType nt = f.numeric();
            if (nt != null) {
                if (nt == FlintField.NumericType.LONG) {
                    type = ValueType.LONG;
                } else if (nt == FlintField.NumericType.DOUBLE) {
                    type = ValueType.DOUBLE;
                } else if (nt == FlintField.NumericType.INT) {
                    type = ValueType.INT;
                } else if (nt == FlintField.NumericType.FLOAT) {
                    type = ValueType.FLOAT;
                }
            } else if (value != null && value.length() > 0 && f.name().contains("date") && Dates.isLuceneDate(value)) {
                try {
                    if (value.length() > 8) {
                        value = Dates.toISODateTime(value, timezoneOffset);
                        type = ValueType.DATETIME;
                    } else if ((value = Dates.toISODate(value)).length() == 10) {
                        type = ValueType.DATE;
                    }
                }
                catch (ParseException ex) {
                    LOGGER.warn("Unparseable date found {}", (Object)value);
                }
            }
            if (value == null || value.length() >= 1000) continue;
            xml.openElement("field");
            xml.attribute("name", f.name());
            if (type == ValueType.DATE) {
                xml.attribute("date", value);
            } else if (type == ValueType.DATETIME) {
                xml.attribute("datetime", value);
            } else if (type == ValueType.LONG) {
                xml.attribute("numeric-type", "long");
            } else if (type == ValueType.DOUBLE) {
                xml.attribute("numeric-type", "double");
            } else if (type == ValueType.FLOAT) {
                xml.attribute("numeric-type", "float");
            } else if (type == ValueType.INT) {
                xml.attribute("numeric-type", "int");
            }
            xml.writeText(value);
            xml.closeElement();
        }
        xml.closeElement();
    }

    public int getFirstHit() {
        return this._paging.getFirstHit();
    }

    public int getLastHit() {
        return this._paging.getLastHit(this.totalNbOfResults);
    }

    public ScoreDoc[] getScoreDoc() throws IndexException {
        if (this._terminated) {
            throw new IndexException("Cannot retrieve documents after termination", (Exception)new IllegalStateException());
        }
        return this._scoredocs;
    }

    public Document getDocument(int id) throws IndexException {
        if (this._terminated) {
            throw new IndexException("Cannot retrieve documents after termination", (Exception)new IllegalStateException());
        }
        try {
            return this._searcher.storedFields().document(id);
        }
        catch (CorruptIndexException e) {
            LOGGER.error("Failed to retrieve a document because of a corrupted Index", (Throwable)e);
            throw new IndexException("Failed to retrieve a document because of a corrupted Index", (Exception)((Object)e));
        }
        catch (IOException ioe) {
            LOGGER.error("Failed to retrieve a document because of an I/O problem", (Throwable)ioe);
            throw new IndexException("Failed to retrieve a document because of an I/O problem", (Exception)ioe);
        }
    }

    public void terminate() {
        if (this._terminated) {
            return;
        }
        this.readers.release(this._searcher);
        this._terminated = true;
    }

    public Iterable<Document> documents() {
        if (this._terminated) {
            throw new IllegalStateException();
        }
        return new DocIterable(this._paging.getFirstHit() - 1, this.getLastHit());
    }

    private void toMetadataXML(XMLWriter xml) throws IOException {
        SearchPaging page = this._paging;
        int total = this.totalNbOfResults;
        xml.openElement("metadata", true);
        xml.openElement("hits", true);
        xml.element("per-page", Integer.toString(page.getHitsPerPage()));
        xml.element("total", Integer.toString(total));
        xml.closeElement();
        xml.openElement("page", true);
        xml.element("first-hit", Integer.toString(page.getFirstHit()));
        xml.element("last-hit", Integer.toString(page.getLastHit(total)));
        xml.element("current", Integer.toString(page.getPage()));
        xml.element("last", Integer.toString(page.getPageCount(total)));
        xml.closeElement();
        if (this._sortfields != null) {
            xml.openElement("sort-fields", true);
            for (SortField field : this._sortfields) {
                xml.element("field", field.getField());
            }
            xml.closeElement();
        }
        xml.closeElement();
    }

    private static class SearchReaders {
        private final LuceneIndexIO _single;
        private final Map<LuceneIndexIO, IndexReader> _readers = new HashMap<LuceneIndexIO, IndexReader>();

        public SearchReaders(Map<LuceneIndexIO, IndexReader> readers) {
            this._readers.putAll(readers);
            this._single = null;
        }

        public SearchReaders(LuceneIndexIO io) {
            this._single = io;
        }

        public void release(IndexSearcher searcher) {
            if (this._single != null) {
                this._single.releaseSearcher(searcher);
            }
            for (Map.Entry<LuceneIndexIO, IndexReader> io : this._readers.entrySet()) {
                io.getKey().releaseReader(io.getValue());
            }
        }
    }

    private final class DocIterator
    implements Iterator<Document> {
        private final IndexSearcher searcher;
        private final ScoreDoc[] scoredocs;
        private int index;
        private final int endIndex;

        public DocIterator(int start, int end) {
            this.searcher = SearchResults.this._searcher;
            this.scoredocs = SearchResults.this._scoredocs;
            this.index = start;
            this.endIndex = end;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.scoredocs.length && this.index < this.endIndex;
        }

        @Override
        public Document next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                return this.searcher.storedFields().document(this.scoredocs[this.index++].doc);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Error retrieving document", ex);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove documents from search results");
        }
    }

    private final class DocIterable
    implements Iterable<Document> {
        private final int _start;
        private final int _end;

        public DocIterable(int start, int end) {
            this._start = start;
            this._end = end;
        }

        @Override
        public Iterator<Document> iterator() {
            return new DocIterator(this._start, this._end);
        }
    }

    private static enum ValueType {
        STRING,
        DATE,
        DATETIME,
        LONG,
        DOUBLE,
        INT,
        FLOAT;

    }
}

