/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.query;

import java.io.IOException;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.search.Query;
import org.pageseeder.flint.catalog.Catalog;
import org.pageseeder.flint.catalog.Catalogs;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.lucene.query.SearchParameter;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public final class NumericRange<T extends Number>
implements SearchParameter {
    private final String _field;
    private final T _min;
    private final T _max;
    private final boolean _minInclusive;
    private final boolean _maxInclusive;
    private volatile Query _query;

    private NumericRange(String field, T min, T max, boolean minInclusive, boolean maxInclusive) {
        if (field == null) {
            throw new NullPointerException("field");
        }
        this._field = field;
        this._min = min;
        this._max = max;
        this._maxInclusive = maxInclusive;
        this._minInclusive = minInclusive;
    }

    public T min() {
        return this._min;
    }

    public T max() {
        return this._max;
    }

    public String field() {
        return this._field;
    }

    public boolean includesMin() {
        return this._minInclusive;
    }

    public boolean includesMax() {
        return this._maxInclusive;
    }

    @Override
    public boolean isEmpty() {
        return this._min == null && this._max == null;
    }

    @Override
    public Query toQuery() {
        if (this._min == null && this._max == null) {
            return null;
        }
        if (this._query == null) {
            this._query = NumericRange.toNumericRangeQuery(this._field, this._min, this._max, this._minInclusive, this._maxInclusive);
        }
        return this._query;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("numeric-range", false);
        xml.attribute("type", (this._min != null ? this._min.getClass().getName() : this._max.getClass().getName()).replaceFirst("^(.+\\.)", "").toLowerCase());
        xml.attribute("field", this._field);
        if (this._min != null) {
            xml.attribute("min", this._min.toString());
            xml.attribute("min-included", Boolean.toString(this._minInclusive));
        }
        if (this._max != null) {
            xml.attribute("max", this._max.toString());
            xml.attribute("max-included", Boolean.toString(this._maxInclusive));
        }
        xml.closeElement();
    }

    private static Query toNumericRangeQuery(String field, Number min, Number max, boolean minInclusive, boolean maxInclusive) {
        if (min instanceof Long || min == null && max instanceof Long) {
            long minLong;
            long l = min == null ? Long.MIN_VALUE : (minLong = minInclusive ? (Long)min : Math.addExact((Long)min, 1L));
            long maxLong = max == null ? Long.MAX_VALUE : (maxInclusive ? (Long)max : Math.addExact((Long)max, -1L));
            return LongPoint.newRangeQuery((String)field, (long)minLong, (long)maxLong);
        }
        if (min instanceof Integer || min == null && max instanceof Integer) {
            int minLong;
            int n = min == null ? Integer.MIN_VALUE : (minLong = minInclusive ? (Integer)min : Math.addExact((Integer)min, 1));
            int maxLong = max == null ? Integer.MAX_VALUE : (maxInclusive ? (Integer)max : Math.addExact((Integer)max, -1));
            return IntPoint.newRangeQuery((String)field, (int)minLong, (int)maxLong);
        }
        if (min instanceof Double || min == null && max instanceof Double) {
            double minLong;
            double d = min == null ? Double.MIN_VALUE : (minLong = minInclusive ? (Double)min : DoublePoint.nextUp((double)((Double)min)));
            double maxLong = max == null ? Double.MAX_VALUE : (maxInclusive ? (Double)max : DoublePoint.nextDown((double)((Double)max)));
            return DoublePoint.newRangeQuery((String)field, (double)minLong, (double)maxLong);
        }
        if (min instanceof Float || min == null && max instanceof Float) {
            float minLong;
            float f = min == null ? Float.MIN_VALUE : (minLong = minInclusive ? ((Float)min).floatValue() : FloatPoint.nextUp((float)((Float)min).floatValue()));
            float maxLong = max == null ? Float.MAX_VALUE : (maxInclusive ? ((Float)max).floatValue() : FloatPoint.nextDown((float)((Float)max).floatValue()));
            return FloatPoint.newRangeQuery((String)field, (float)minLong, (float)maxLong);
        }
        return null;
    }

    public static NumericRange<Double> newDoubleRange(String field, Double min, Double max, boolean minInclusive, boolean maxInclusive) {
        return new NumericRange<Double>(field, min, max, minInclusive, maxInclusive);
    }

    public static NumericRange<Float> newFloatRange(String field, Float min, Float max, boolean minInclusive, boolean maxInclusive) {
        return new NumericRange<Float>(field, min, max, minInclusive, maxInclusive);
    }

    public static NumericRange<Integer> newIntRange(String field, Integer min, Integer max, boolean minInclusive, boolean maxInclusive) {
        return new NumericRange<Integer>(field, min, max, minInclusive, maxInclusive);
    }

    public static NumericRange<Long> newLongRange(String field, Long min, Long max, boolean minInclusive, boolean maxInclusive) {
        return new NumericRange<Long>(field, min, max, minInclusive, maxInclusive);
    }

    public static NumericRange<?> newNumberRange(String field, String catalog, Number min, Number max, boolean minInclusive, boolean maxInclusive) {
        Catalog thecatalog = Catalogs.getCatalog((String)catalog);
        if (thecatalog == null) {
            return null;
        }
        FlintField.NumericType nt = thecatalog.getNumericType(field);
        if (nt == null) {
            return null;
        }
        switch (nt) {
            case DOUBLE: {
                return NumericRange.newDoubleRange(field, (Double)min, (Double)max, minInclusive, maxInclusive);
            }
            case FLOAT: {
                return NumericRange.newFloatRange(field, (Float)min, (Float)max, minInclusive, maxInclusive);
            }
            case INT: {
                return NumericRange.newIntRange(field, (Integer)min, (Integer)max, minInclusive, maxInclusive);
            }
            case LONG: {
                return NumericRange.newLongRange(field, (Long)min, (Long)max, minInclusive, maxInclusive);
            }
        }
        return null;
    }
}

