/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.web;

import com.blueconic.browscap.Capabilities;
import com.blueconic.browscap.ParseException;
import com.blueconic.browscap.UserAgentParser;
import com.blueconic.browscap.UserAgentService;
import com.pageseeder.common.util.InMemoryLRUCache;
import java.io.IOException;
import java.io.Serializable;
import org.eclipse.jdt.annotation.Nullable;

public final class UserAgent
implements Serializable {
    private static final InMemoryLRUCache<String, UserAgent> cache = new InMemoryLRUCache(10);
    private static final long serialVersionUID = 20250106L;
    private static @Nullable UserAgentParser parser = null;
    private final String raw;
    private final transient Capabilities capabilities;

    private UserAgent(String raw, Capabilities capabilities) {
        this.raw = raw;
        this.capabilities = capabilities;
    }

    public String getRaw() {
        return this.raw;
    }

    public String getBrowser() {
        return this.capabilities.getBrowser();
    }

    public String getBrowserType() {
        return this.capabilities.getBrowserType();
    }

    public String getBrowserMajorVersion() {
        return this.capabilities.getBrowserMajorVersion();
    }

    public String getDeviceType() {
        return this.capabilities.getDeviceType();
    }

    public String getPlatform() {
        return this.capabilities.getPlatform();
    }

    public String getPlatformVersion() {
        return this.capabilities.getPlatformVersion();
    }

    public static UserAgent fromString(String userAgent) {
        UserAgent ua = (UserAgent)cache.get((Object)userAgent);
        if (ua == null) {
            ua = UserAgent.parse(userAgent);
            cache.put((Object)userAgent, (Object)ua);
        }
        return ua;
    }

    public static UserAgent parse(String userAgent) {
        Capabilities capabilities = UserAgent.getParser().parse(userAgent);
        return new UserAgent(userAgent, capabilities);
    }

    private static UserAgentParser getParser() {
        UserAgentParser p = parser;
        if (p == null) {
            try {
                p = parser = new UserAgentService().loadParser();
            }
            catch (ParseException | IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return p;
    }
}

