/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.util;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.util.ValidationEntityResolver;
import com.pageseeder.base.util.ValidationErrorHandler;
import com.pageseeder.base.util.XMLParserErrorHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public final class XMLHelpers {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLHelpers.class);

    private XMLHelpers() {
    }

    public static SAXParserFactory safeSAXParserFactory() throws SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        return factory;
    }

    public static XMLReader safeXMLReader() throws SAXException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        return reader;
    }

    public static TransformerFactory safeTransformerFactory() {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "file");
        return factory;
    }

    public static void parse(InputStream in, ContentHandler handler) throws FoundationException {
        XMLHelpers.parse(in, handler, null, null);
    }

    public static void parse(InputStream in, ContentHandler handler, @Nullable List<String> errors, @Nullable List<String> warnings) throws FoundationException {
        try {
            XMLParserErrorHandler errorHandler = new XMLParserErrorHandler();
            XMLReader reader = XMLHelpers.safeXMLReader();
            reader.setContentHandler(handler);
            reader.setErrorHandler(errorHandler);
            try (InputStream inputStream = in;){
                reader.parse(new InputSource(in));
            }
            if (errors != null) {
                errors.addAll(errorHandler.getErrors());
            } else if (errorHandler.hasErrors()) {
                StringBuilder all = new StringBuilder();
                for (String e : errorHandler.getErrors()) {
                    all.append(e).append("\n");
                }
                throw new FoundationException(all.toString());
            }
            if (warnings != null) {
                warnings.addAll(errorHandler.getWarnings());
            }
        }
        catch (IOException ex) {
            throw new FoundationException("Failed to read/write XML", ex);
        }
        catch (SAXException ex) {
            throw new FoundationException(ex.getMessage(), ex);
        }
    }

    public static List<String> validateWellFormednessReturnErrors(InputStream in) throws SAXException, IOException {
        if (in == null) {
            throw new NullPointerException("Cannot validate a null file");
        }
        XMLReader reader = XMLHelpers.safeXMLReader();
        ValidationErrorHandler eh = new ValidationErrorHandler();
        reader.setErrorHandler(eh);
        reader.parse(new InputSource(in));
        return eh.getErrorList();
    }

    public static List<String> validateWellFormednessReturnErrors(String in) throws SAXException, IOException {
        if (in == null) {
            throw new NullPointerException("Cannot validate null content");
        }
        XMLReader reader = XMLHelpers.safeXMLReader();
        ValidationErrorHandler eh = new ValidationErrorHandler();
        reader.setErrorHandler(eh);
        reader.parse(new InputSource(new StringReader(in)));
        return eh.getErrorList();
    }

    public static String validateXmlFileWithSchema(String in, String schemaPath, String namespace) throws SAXException, IOException {
        return XMLHelpers.validateWithSchemaAndHandler(new InputSource(new StringReader(in)), schemaPath, namespace, null).getErrors();
    }

    public static List<String> validateXmlFileWithSchemaReturnErrors(InputStream in, String schemaPath, String namespace) throws SAXException, IOException {
        return XMLHelpers.validateWithSchemaAndHandler(new InputSource(in), schemaPath, namespace, null).getErrorList();
    }

    public static ValidationErrorHandler validateWithSchemaAndHandler(InputSource in, String schemaPath, String namespace, ContentHandler handler) throws SAXException, IOException {
        String path;
        if (in == null) {
            throw new NullPointerException("Cannot validate a null file");
        }
        XMLReader reader = XMLHelpers.safeXMLReader();
        reader.setFeature("http://xml.org/sax/features/validation", true);
        reader.setFeature("http://apache.org/xml/features/validation/schema", true);
        reader.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        if (handler != null) {
            reader.setContentHandler(handler);
        }
        ValidationErrorHandler eh = new ValidationErrorHandler();
        reader.setErrorHandler(eh);
        String string = path = new File(schemaPath).exists() ? new File(schemaPath).toURI().toURL().toString().replaceAll(" ", "%20") : schemaPath;
        if (namespace == null) {
            reader.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", path);
        } else {
            reader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", namespace + " " + path);
        }
        reader.setEntityResolver(new ValidationEntityResolver());
        reader.parse(in);
        return eh;
    }

    public static @Nullable String xmlToText(String xml) {
        xml = "<root>" + (String)xml + "</root>";
        XMLToTextHandler handler = new XMLToTextHandler();
        try {
            XMLHelpers.parse(new ByteArrayInputStream(((String)xml).getBytes(StandardCharsets.UTF_8)), handler);
        }
        catch (FoundationException ex) {
            LOGGER.error("Failed to create text content from HTML email", (Throwable)ex);
            return null;
        }
        return handler.text.toString();
    }

    private static final class XMLToTextHandler
    extends DefaultHandler {
        private StringWriter text = new StringWriter();

        private XMLToTextHandler() {
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.text.write(ch, start, length);
        }
    }
}

