/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.util;

import com.pageseeder.common.UnforeseenException;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.Rules;
import com.pageseeder.common.util.Strings;
import jakarta.mail.internet.MimeUtility;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;

public final class RuleUtils {
    private static final String ILLEGAL_FILENAME_CHARS = "/\\?%*:|<>\"";
    private static final Pattern ILLEGAL_URL_ENCODING = Pattern.compile("%[^0-9A-Fa-f]|%.[^0-9A-Fa-f]|%$|%[0-9A-Fa-f]$");
    private static final Pattern PSML_FRAGMENT = Pattern.compile("^(<[a-z-]+)");
    private static final int HT = 9;
    private static final int LF = 10;
    private static final int CR = 13;
    private static final int SP = 32;
    private static final int DEL = 127;
    private static final int APC = 159;

    private RuleUtils() {
    }

    public static String generateEmptyFragment(@Nullable String fragment) {
        Matcher m;
        if (fragment != null && (m = PSML_FRAGMENT.matcher(fragment)).find()) {
            return m.group(1) + " />";
        }
        return "<fragment />";
    }

    public static boolean isXMLMediaType(@Nullable String mediatype) {
        return "text/xml".equals(mediatype) || "application/xml".equals(mediatype) || "text/xml-external-parsed-entity".equals(mediatype) || "application/xml-external-parsed-entity".equals(mediatype) || "application/xml-dtd".equals(mediatype) || mediatype != null && mediatype.endsWith("+xml");
    }

    public static Collection<String> forbiddenAttachmentExtensions() {
        return Arrays.asList(Strings.split((String)GlobalSettings.getString((String)"forbiddenAttachmentExtensions", (String)"").toLowerCase(), (char)','));
    }

    public static Collection<String> forbiddenUploadExtensions() {
        return Arrays.asList(Strings.split((String)GlobalSettings.getString((String)"forbiddenUploadExtensions", (String)"").toLowerCase(), (char)','));
    }

    public static String[] delimitedToArray(String data, String delimiter) {
        StringTokenizer st = new StringTokenizer(data, delimiter);
        int length = st.countTokens();
        String[] out = (String[])Array.newInstance(String.class, length);
        for (int i = 0; i < length; ++i) {
            out[i] = st.nextToken();
        }
        return out;
    }

    public static String[] delimitedEmptyToArray(String data, String delim, @Nullable String empty) {
        String[] out = new String[]{};
        StringTokenizer st = new StringTokenizer(data, delim, true);
        int length = st.countTokens();
        if (length > 0) {
            int i;
            int delims = 0;
            for (i = 0; i < length; ++i) {
                if (!delim.equals(st.nextToken())) continue;
                ++delims;
            }
            out = (String[])Array.newInstance(String.class, delims + 1);
            st = new StringTokenizer(data, delim, true);
            for (i = 0; i < delims + 1; ++i) {
                if (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (delim.equals(token)) {
                        out[i] = empty;
                        continue;
                    }
                    out[i] = token;
                    if (!st.hasMoreTokens()) continue;
                    st.nextToken();
                    continue;
                }
                out[i] = empty;
            }
        }
        return out;
    }

    public static String defaultValue(@Nullable String value, String def) {
        if (value == null) {
            return def;
        }
        return value;
    }

    public static String encodeKey(String key) {
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA");
            sha.update(key.getBytes(StandardCharsets.ISO_8859_1));
            return MimeUtility.encodeWord((String)new String(sha.digest(), StandardCharsets.ISO_8859_1), (String)"ISO-8859-1", (String)"B");
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
            throw new UnforeseenException((Throwable)ex);
        }
    }

    public static String generatePassword() {
        String password = RuleUtils.encodeKey("j45tyw8" + System.currentTimeMillis());
        password = password.substring(19, 29);
        password = password.replaceAll("\\W", "X").toLowerCase();
        password = password.replace('1', '2');
        password = password.replace('l', 'z');
        password = password.replace('0', '9');
        password = password.replace('o', 'p');
        return password;
    }

    public static String generatePassword(int length) {
        if (length < 1 || length > 29) {
            throw new IllegalArgumentException("Password length must be from 1 to 29, not: " + length);
        }
        String password = RuleUtils.encodeKey("j45tyw8" + System.currentTimeMillis());
        password = password.substring(42 - length, 42);
        password = password.replaceAll("\\W", "X").toLowerCase();
        password = password.replace('1', '2');
        password = password.replace('l', 'z');
        password = password.replace('0', '9');
        password = password.replace('o', 'p');
        return password;
    }

    public static String removePasswordJsessionid(@Nullable String url) {
        if (url == null) {
            return "";
        }
        url = url.replaceAll("password=[^&]+", "password=XXXX");
        return url.replaceAll("jsessionid=[^&;]+", "jsessionid=XXXX");
    }

    public static String removeJsessionid(String path) {
        int i = path.indexOf(";jsessionid=");
        if (i != -1) {
            int j = path.indexOf(";", i + 1);
            if (j != -1) {
                return path.substring(0, i) + path.substring(j);
            }
            return path.substring(0, i);
        }
        return path;
    }

    public static String computeFullPath(String folder, String relativePath) {
        String myFolder = folder.endsWith("/") ? folder.substring(0, folder.length() - 1) : folder;
        String myPath = relativePath.replace("/./", "/").replaceFirst("^\\./", "");
        while (myPath.startsWith("../")) {
            myPath = myPath.substring(3);
            myFolder = myFolder.replaceAll("/[^/]+$", "");
        }
        return myFolder + "/" + myPath;
    }

    public static String urlEncodeFilepath(String filepath) {
        return RuleUtils.urlEncodeFilepath(filepath, StandardCharsets.UTF_8);
    }

    public static String urlEncodeFilepath(String filepath, Charset charset) {
        try {
            StringBuilder path = new StringBuilder();
            String fp = filepath;
            while (fp.indexOf(47) != -1) {
                path.append(URLEncoder.encode(fp.substring(0, fp.indexOf(47)), charset.name())).append('/');
                fp = fp.substring(1 + fp.indexOf(47));
            }
            return Rules.uriDBPathToEncodedPath((String)path.append(URLEncoder.encode(fp, charset.name())).toString());
        }
        catch (UnsupportedEncodingException ex) {
            throw new UnforeseenException((Throwable)ex);
        }
    }

    public static boolean containsInvalidURLChars(@Nullable String s) {
        if (s != null) {
            for (char c : s.toCharArray()) {
                if (c >= '!' && c <= '~' && c != '\"' && c != '<' && c != '>' && c != '\\' && c != '^' && c != '`' && c != '{' && c != '|' && c != '}' && c != '[' && c != ']') continue;
                return true;
            }
            return ILLEGAL_URL_ENCODING.matcher(s).find();
        }
        return false;
    }

    public static URL urlEncodeNormalize(String uriString) throws MalformedURLException {
        return RuleUtils.urlEncodeNormalize(uriString, true);
    }

    public static URL urlEncodeNormalize(String uriString, boolean orderParams) throws MalformedURLException {
        URL url = new URL(uriString);
        String protocol = url.getProtocol();
        if (!"http".equalsIgnoreCase(protocol) && !"https".equalsIgnoreCase(protocol)) {
            throw new MalformedURLException("Only http and https are supported.");
        }
        if (!Rules.isValidHost((String)url.getHost())) {
            throw new MalformedURLException("Host is not valid.");
        }
        int port = url.getPort() == -1 ? Rules.getDefaultPort((String)url.getProtocol()) : url.getPort();
        String path = url.getPath();
        StringBuilder npath = new StringBuilder();
        if (RuleUtils.containsInvalidURLChars(path)) {
            for (String string : path.split("/")) {
                if ("".equals(string)) continue;
                npath.append("/");
                npath.append(URLEncoder.encode(string, StandardCharsets.UTF_8));
            }
            path = npath.toString();
        }
        path = path.replaceAll("\\+", "%20");
        String query = url.getQuery();
        StringBuilder nquery = new StringBuilder();
        ArrayList<String> pl = new ArrayList<String>();
        if (query != null) {
            query = query.replaceAll("%20", "+");
            for (String param : query.split("&")) {
                if (param.startsWith("utm_source=") || param.startsWith("utm_medium=") || param.startsWith("utm_campaign=") || param.startsWith("utm_term=") || param.startsWith("utm_content=")) continue;
                pl.add(param);
            }
            if (orderParams) {
                Collections.sort(pl);
            }
            Iterator iterator = pl.iterator();
            while (iterator.hasNext()) {
                String param = (String)iterator.next();
                int i = param.indexOf(61);
                if (i != -1) {
                    String value;
                    String name = param.substring(0, i);
                    if (RuleUtils.containsInvalidURLChars(name)) {
                        name = URLEncoder.encode(name, StandardCharsets.UTF_8);
                    }
                    if (RuleUtils.containsInvalidURLChars(value = param.substring(i + 1))) {
                        value = URLEncoder.encode(value, StandardCharsets.UTF_8);
                    }
                    nquery.append(name);
                    nquery.append('=');
                    nquery.append(value);
                } else {
                    if (RuleUtils.containsInvalidURLChars(param)) {
                        param = URLEncoder.encode(param, StandardCharsets.UTF_8);
                    }
                    nquery.append(param);
                }
                if (!iterator.hasNext()) continue;
                nquery.append('&');
            }
        }
        String string = nquery.toString();
        String fragment = url.getRef();
        if (RuleUtils.containsInvalidURLChars(fragment)) {
            fragment = URLEncoder.encode(fragment, StandardCharsets.UTF_8);
        }
        return new URL(protocol, url.getHost(), port, path + (string.isEmpty() ? "" : "?") + string + (String)(fragment == null ? "" : "#" + fragment));
    }

    public static void makeXMLSafe(String text, StringBuilder xml) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (RuleUtils.isLegalXMLChar(c)) {
                switch (c) {
                    case '>': {
                        xml.append("&gt;");
                        break;
                    }
                    case '<': {
                        xml.append("&lt;");
                        break;
                    }
                    case '&': {
                        xml.append("&amp;");
                        break;
                    }
                    default: {
                        xml.append(c);
                        break;
                    }
                }
                continue;
            }
            xml.append('?');
        }
    }

    public static String makeXMLSafe(@Nullable String text) {
        if (text == null) {
            return "";
        }
        StringBuilder xml = new StringBuilder(text.length());
        RuleUtils.makeXMLSafe(text, xml);
        return xml.toString();
    }

    public static String replaceNonFilenameChars(String src) {
        if (src == null) {
            return null;
        }
        while (src.startsWith(".") || src.startsWith(" ")) {
            src = src.substring(1);
        }
        while (src.endsWith(".") || src.endsWith(" ")) {
            src = src.substring(0, src.length() - 1);
        }
        src = src.trim();
        String out = Strings.removeDiacritics((String)src);
        out = RuleUtils.toValidFilename(out, '_');
        return RuleUtils.replaceSubstring(out, "..", "_.");
    }

    public static String replaceNonFolderChars(String src) {
        return RuleUtils.replaceNonFilenameChars(src);
    }

    public static String replaceNonFolderCharsKeepSlashes(String src) {
        StringBuilder out = new StringBuilder();
        while (src.indexOf(47) != -1) {
            if (!src.startsWith("/") || out.length() == 0) {
                out.append(RuleUtils.replaceNonFilenameChars(src.substring(0, src.indexOf(47)))).append('/');
            }
            src = src.substring(1 + src.indexOf(47));
        }
        return out.append(RuleUtils.replaceNonFilenameChars(src)).toString();
    }

    public static String replaceSubstring(String src, String olds, String news) {
        if (!olds.isEmpty()) {
            int i = ((String)src).indexOf(olds);
            while (i != -1) {
                src = ((String)src).substring(0, i) + news + ((String)src).substring(i + olds.length());
                i = ((String)src).indexOf(olds, i + news.length());
            }
        }
        return src;
    }

    public static String toValidFilename(String src, char r) {
        if (!RuleUtils.isLegalFileNameChar(r)) {
            throw new IllegalArgumentException("Cannot replace illegal characters by illegal character '" + r + "'");
        }
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (RuleUtils.isLegalFileNameChar(c)) {
                out.append(c);
                continue;
            }
            out.append(r);
        }
        return RuleUtils.replaceSubstring(out.toString(), "..", r + ".");
    }

    public static boolean isLegalFileNameChar(char c) {
        return ILLEGAL_FILENAME_CHARS.indexOf(c) == -1 && c >= ' ' && c < '\u007f';
    }

    private static boolean isLegalXMLChar(char c) {
        return !(c < ' ' && c != '\t' && c != '\n' && c != '\r' || c >= '\u007f' && c <= '\u009f');
    }
}

