/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.util;

import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.properties.SettingsFile;
import java.io.File;
import org.eclipse.jdt.annotation.Nullable;

public final class Medias {
    public static final String UNKNOWN_MEDIATYPE = "application/octet-stream";

    private Medias() {
    }

    public static @Nullable String getMediaType(@Nullable File file) {
        if (file == null) {
            return null;
        }
        int dot = file.getName().lastIndexOf(46);
        if (dot < 0) {
            return null;
        }
        return Medias.getMediaType(file.getName().substring(dot + 1).toLowerCase());
    }

    public static @Nullable String getMediaTypeForPath(String path) {
        int dot = path.lastIndexOf(46);
        if (dot < 0) {
            return null;
        }
        return Medias.getMediaType(path.substring(dot + 1).toLowerCase());
    }

    public static String getMediaType(String extension) {
        return Settings.getString((SettingsFile)SettingsFile.MIME, (String)extension.toLowerCase(), (String)UNKNOWN_MEDIATYPE);
    }

    public static boolean isText(@Nullable String media) {
        if (media == null) {
            return false;
        }
        return media.startsWith("text") || media.endsWith("xml") || media.endsWith("javascript") || media.endsWith("json");
    }
}

