/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.util;

import com.pageseeder.common.properties.GlobalSettings;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;

public final class Cookies {
    private static final int MAX_AGE = 31536000;

    private Cookies() {
    }

    public static @Nullable Cookie getCookie(HttpServletRequest request, String name) {
        return Cookies.getCookie(request.getCookies(), name);
    }

    public static @Nullable Cookie getCookie(Cookie @Nullable [] cookies, String name) {
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    public static void removeCookie(HttpServletResponse res, String name) {
        Cookie c = new Cookie(name, null);
        c.setHttpOnly(true);
        c.setMaxAge(0);
        c.setPath(GlobalSettings.getSitePrefix());
        c.setSecure(true);
        res.addCookie(c);
    }

    public static void removeCookie(HttpServletResponse res, String name, String path) {
        Cookie c = new Cookie(name, null);
        c.setHttpOnly(true);
        c.setMaxAge(0);
        c.setPath(path);
        c.setSecure(true);
        res.addCookie(c);
    }

    public static void setCookie(HttpServletResponse res, String name, String value) {
        Cookie c = new Cookie(name, value);
        c.setHttpOnly(true);
        c.setMaxAge(31536000);
        c.setPath(GlobalSettings.getSitePrefix());
        c.setSecure(true);
        res.addCookie(c);
    }

    public static @Nullable String getCookieValue(HttpServletRequest req, String name) {
        Cookie c = Cookies.getCookie(req, name);
        return c == null ? null : c.getValue();
    }
}

