/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.serial;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.PrintException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class JSONOutputPrinter
extends OutputPrinter {
    private final Writer out;
    private final JsonGenerator json;

    public JSONOutputPrinter() {
        this(new StringWriter());
    }

    public JSONOutputPrinter(Writer out) {
        this.out = out;
        try {
            JsonFactory factory = new JsonFactory();
            this.json = factory.createGenerator(out);
        }
        catch (IOException ex) {
            throw new PrintException("Unable to instantiate JSON writer", ex);
        }
    }

    @Override
    public final OutputType getType() {
        return OutputType.JSON;
    }

    @Override
    public final void field(String name, boolean value, OutputPrinter.FieldOption option) {
        if (option == OutputPrinter.FieldOption.CSV_ONLY || option == OutputPrinter.FieldOption.NOT_JSON) {
            return;
        }
        try {
            this.json.writeBooleanField(JSONOutputPrinter.camelify(name), value);
        }
        catch (IOException ex) {
            throw new PrintException("Unable to write JSON boolean property", ex);
        }
    }

    @Override
    public final void field(String name, long value, OutputPrinter.FieldOption option) {
        if (option == OutputPrinter.FieldOption.CSV_ONLY || option == OutputPrinter.FieldOption.NOT_JSON) {
            return;
        }
        try {
            this.json.writeNumberField(JSONOutputPrinter.camelify(name), value);
        }
        catch (IOException ex) {
            throw new PrintException("Unable to write JSON numeric property", ex);
        }
    }

    @Override
    public final void field(String name, String value, OutputPrinter.FieldOption option) {
        if (option == OutputPrinter.FieldOption.CSV_ONLY || option == OutputPrinter.FieldOption.NOT_JSON) {
            return;
        }
        try {
            this.json.writeStringField(JSONOutputPrinter.camelify(name), value);
        }
        catch (IOException ex) {
            throw new PrintException("Unable to write JSON string property", ex);
        }
    }

    @Override
    public void field(String name, String[] values, OutputPrinter.FieldOption option) {
        if (option == OutputPrinter.FieldOption.CSV_ONLY || option == OutputPrinter.FieldOption.NOT_JSON) {
            return;
        }
        try {
            this.json.writeArrayFieldStart(JSONOutputPrinter.camelify(name));
            for (String value : values) {
                this.json.writeString(value);
            }
            this.json.writeEndArray();
        }
        catch (IOException ex) {
            throw new PrintException("Unable to write JSON string property", ex);
        }
    }

    @Override
    public void startObject(String name, OutputPrinter.ObjectOption option) {
        try {
            if (this.json.getOutputContext().inObject()) {
                this.json.writeObjectFieldStart(JSONOutputPrinter.camelify(name));
            } else {
                this.json.writeStartObject();
            }
        }
        catch (IOException ex) {
            throw new PrintException("Unable to start JSON object", ex);
        }
    }

    @Override
    public void endObject() {
        try {
            this.json.writeEndObject();
        }
        catch (IOException ex) {
            throw new PrintException("Unable to end JSON object", ex);
        }
    }

    @Override
    public void startCollection(String name, OutputPrinter.CollectionOption option) {
        try {
            if (this.json.getOutputContext().inObject()) {
                this.json.writeArrayFieldStart(JSONOutputPrinter.camelify(name));
            } else {
                this.json.writeStartArray();
            }
        }
        catch (IOException ex) {
            throw new PrintException("Unable to start JSON array", ex);
        }
    }

    @Override
    public void endCollection() {
        try {
            this.json.writeEndArray();
        }
        catch (IOException ex) {
            throw new PrintException("Unable to end JSON array", ex);
        }
    }

    @Override
    public void flush() {
        try {
            this.json.flush();
        }
        catch (IOException ex) {
            throw new PrintException("Unable to close element for collection", ex);
        }
    }

    @Override
    public void close() {
        try {
            this.json.close();
        }
        catch (IOException ex) {
            throw new PrintException("Unable to close element for collection", ex);
        }
    }

    public String toString() {
        this.flush();
        if (this.out instanceof StringWriter) {
            return this.out.toString();
        }
        return super.toString();
    }

    public static String camelify(String name) {
        int dash = name.indexOf(45);
        return dash < 0 ? name : JSONOutputPrinter.camelify(name, dash);
    }

    private static String camelify(String name, int from) {
        StringBuilder sb = new StringBuilder(name);
        for (int i = from; i < sb.length() - 1; ++i) {
            if (sb.charAt(i) != '-') continue;
            sb.deleteCharAt(i);
            sb.replace(i, i + 1, String.valueOf(Character.toUpperCase(sb.charAt(i))));
        }
        return sb.toString();
    }
}

