/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.serial;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.PrintException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.eclipse.jdt.annotation.Nullable;

public class CSVOutputPrinter
extends OutputPrinter {
    private static final int ISO_LOCAL_DATETIME_LENGTH = 19;
    private final Writer out;
    private final CSVPrinter csv;
    private String object = "";
    private static final char SUB_SEPARATOR = ',';
    private final List<String> columns = new ArrayList<String>();
    private final List<String> headers = new ArrayList<String>();
    private final List<String> datetimeFields = new ArrayList<String>();
    private final Deque<String> path = new ArrayDeque<String>();
    private final List<@Nullable Object> values = new ArrayList<Object>();
    private boolean useResultMode = false;
    private @Nullable String resultField = null;

    public CSVOutputPrinter() {
        this(new StringWriter());
    }

    public CSVOutputPrinter(Writer out) {
        this.out = out;
        try {
            this.csv = CSVFormat.DEFAULT.print((Appendable)out);
            this.csv.getOut().append('\ufeff');
        }
        catch (IOException ex) {
            throw new PrintException("Unable to instantiate JSON writer", ex);
        }
    }

    public void setColumns(String object, Iterable<String> columns) {
        if (!this.object.isEmpty()) {
            throw new IllegalStateException("CSV output can only be configured once!");
        }
        this.object = object;
        for (String c : columns) {
            this.columns.add(c);
            this.values.add(null);
        }
        this.useResultMode = "result".equals(this.object);
    }

    public void setDateTimeFields(List<String> fields) {
        this.datetimeFields.clear();
        this.datetimeFields.addAll(fields);
    }

    public void setHeaders(Iterable<String> headers) {
        this.headers.clear();
        for (String h : headers) {
            this.headers.add(h);
        }
    }

    @Override
    public final OutputType getType() {
        return OutputType.CSV;
    }

    @Override
    public final void field(String name, boolean value, OutputPrinter.FieldOption option) {
        this.setValue(name, (Object)value, ',');
    }

    @Override
    public final void field(String name, long value, OutputPrinter.FieldOption option) {
        this.setValue(name, (Object)value, ',');
    }

    @Override
    public final void field(String name, String value, OutputPrinter.FieldOption option) {
        this.setValue(name, (Object)value, ',');
    }

    @Override
    public void field(String name, String[] values, OutputPrinter.FieldOption option) {
        int i = this.getColumn(name);
        if (i >= 0) {
            String value = String.join((CharSequence)Character.toString(','), values);
            this.setValue(i, (Object)value, ',');
        }
    }

    @Override
    public void startObject(String name, OutputPrinter.ObjectOption option) {
        if (!this.headers.isEmpty()) {
            try {
                if (this.headers.get(0).matches("ID(?:_[^,\\s]{4})?")) {
                    this.csv.getOut().append("'");
                }
                this.csv.printRecord(this.headers);
            }
            catch (IOException ex) {
                throw new PrintException("Unable to print headers", ex);
            }
            this.headers.clear();
        }
        if (this.path.isEmpty() && this.object.equals(name)) {
            this.path.push("");
            this.resetValues();
        } else if (!this.path.isEmpty()) {
            String parent = this.path.peek();
            this.path.push((String)(!parent.isEmpty() ? parent + "." + name : name));
        }
    }

    @Override
    public void endObject() {
        if (!this.path.isEmpty()) {
            this.path.pop();
            if (this.path.isEmpty()) {
                try {
                    this.csv.printRecord(this.values);
                }
                catch (IOException ex) {
                    throw new PrintException("Unable to print record", ex);
                }
            }
        }
    }

    @Override
    public void startCollection(String name, OutputPrinter.CollectionOption option) {
        if (!this.path.isEmpty()) {
            String parent = this.path.peek();
            this.path.push((String)(!parent.isEmpty() ? parent + "." + name : name));
        }
    }

    @Override
    public void endCollection() {
        if (this.path.size() > 1) {
            this.path.pop();
        }
    }

    @Override
    public void flush() {
        try {
            this.csv.flush();
        }
        catch (IOException ex) {
            throw new PrintException("Unable to flush CSV output", ex);
        }
    }

    @Override
    public void close() {
        try {
            this.csv.close();
        }
        catch (IOException ex) {
            throw new PrintException("Unable to close CSV output", ex);
        }
    }

    public String toString() {
        this.flush();
        if (this.out instanceof StringWriter) {
            return this.out.toString();
        }
        return super.toString();
    }

    private String column(String field) {
        if (this.path.size() == 1) {
            return field;
        }
        return this.path.peek() + "." + field;
    }

    private int getColumn(String name) {
        if (this.path.isEmpty()) {
            return -1;
        }
        return this.columns.indexOf(this.column(name));
    }

    private void setValue(String name, Object value, char separator) {
        if (this.useResultMode) {
            if ("fields.field".equals(this.path.peek())) {
                if ("name".equals(name)) {
                    this.resultField = value.toString();
                } else if (this.resultField != null && ("date".equals(name) || "datetime".equals(name) || "value".equals(name))) {
                    Object v = "datetime".equals(name) ? CSVOutputPrinter.toExcelDatetime(value.toString()) : value;
                    int i = this.columns.indexOf(this.resultField);
                    if (i >= 0) {
                        this.setValue(i, v, separator);
                    }
                    this.resultField = null;
                }
            }
        } else {
            int i = this.getColumn(name);
            if (i >= 0) {
                if (this.datetimeFields.contains(name)) {
                    this.setValue(i, (Object)CSVOutputPrinter.toExcelDatetime(value.toString()), separator);
                } else {
                    this.setValue(i, value, separator);
                }
            }
        }
    }

    private void setValue(int i, Object value, char separator) {
        Object o = this.values.get(i);
        if (o != null) {
            String merge = o.toString() + separator + String.valueOf(value);
            this.values.set(i, merge);
        } else {
            this.values.set(i, value);
        }
    }

    private void resetValues() {
        this.values.replaceAll(i -> null);
    }

    private static String toExcelDatetime(String datetime) {
        String excel = datetime.replace('T', ' ');
        if (excel.length() > 19) {
            excel = excel.substring(0, 19);
        }
        return excel;
    }
}

