/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.security;

import com.pageseeder.base.security.GCM;
import com.pageseeder.common.util.BinaryFormat;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.LoggerFactory;

public final class UnsubscribeToken {
    private static final String KEY_ALIAS = "unsubscribe";
    private static final Long NULL_XLINK = -1L;
    private final Long group;
    private final String email;
    private final @Nullable Long xlink;
    private final LocalDate expires;

    private UnsubscribeToken(Long group, String email, @Nullable Long xlink, LocalDate expires) {
        this.group = group;
        this.email = email;
        this.xlink = xlink != null && !NULL_XLINK.equals(xlink) ? xlink : null;
        this.expires = expires;
    }

    public String email() {
        return this.email;
    }

    public Long group() {
        return this.group;
    }

    public @Nullable Long xlink() {
        return this.xlink;
    }

    public LocalDate expires() {
        return this.expires;
    }

    public boolean hasExpired() {
        return this.expires.isBefore(LocalDate.now());
    }

    public @Nullable String generateToken() {
        String xlinkAsString = this.xlink != null ? this.xlink.toString() : Long.toString(-1L);
        String message = String.join((CharSequence)"\n", this.email, xlinkAsString, this.expires.format(DateTimeFormatter.ISO_LOCAL_DATE));
        String authenticated = this.group.toString();
        return GCM.encryptSilently(KEY_ALIAS, message, authenticated, BinaryFormat.BASE_64_URL);
    }

    public static @Nullable String generateToken(Long group, String email, @Nullable Long xlink) {
        LocalDate expires = LocalDate.now().plusYears(1L);
        UnsubscribeToken token = new UnsubscribeToken(group, email, xlink, expires);
        return token.generateToken();
    }

    public static @Nullable UnsubscribeToken parse(String token, Long group) {
        String[] components;
        String message = GCM.decryptSilently(KEY_ALIAS, Objects.requireNonNull(token), group.toString(), BinaryFormat.BASE_64_URL);
        if (message != null && (components = message.split("\\n")).length == 3) {
            String email = components[0];
            String xlink = components[1];
            String expires = components[2];
            try {
                Long xl = Long.valueOf(xlink);
                LocalDate date = LocalDate.parse(expires);
                return new UnsubscribeToken(group, email, xl, date);
            }
            catch (IllegalArgumentException | DateTimeException ex) {
                LoggerFactory.getLogger(UnsubscribeToken.class).warn("Unable to parse token", (Throwable)ex);
            }
        }
        return null;
    }
}

