/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.security;

import com.pageseeder.base.security.PasswordFormat;
import com.pageseeder.base.security.PasswordFormatException;
import com.pageseeder.common.UnforeseenException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class SimplePassword
extends PasswordFormat {
    private static final int SALT_LENGTH_BYTES = 8;
    private static final int SALT_LENGTH_CHAR = 12;
    private final int power;

    SimplePassword(int power) {
        super(8, false);
        if (power < 0 || power > 9) {
            throw new IllegalArgumentException();
        }
        this.power = power;
    }

    public int getPower() {
        return this.power;
    }

    public static SimplePassword getInstance(String algorithm) throws PasswordFormatException {
        if (algorithm.length() < 2 || algorithm.charAt(0) != 's') {
            throw new PasswordFormatException("Algorithm code not start with 's':");
        }
        try {
            return new SimplePassword(Integer.parseInt(Character.toString(algorithm.charAt(1))));
        }
        catch (NumberFormatException ex) {
            throw new PasswordFormatException("Algorithm code does not specify power");
        }
    }

    @Override
    public boolean check(String enteredPassword, String storedPassword) {
        String salt = storedPassword.substring(2, 14);
        String hash = storedPassword.substring(14);
        return this.generateHash(enteredPassword, salt).equals(hash);
    }

    @Override
    public byte[] generateHash(String password, byte[] salt) {
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA-256");
            sha.update(salt);
            sha.update(password.getBytes(StandardCharsets.UTF_8));
            byte[] hash = sha.digest();
            double iter = Math.pow(2.0, 11.0 + (double)this.power);
            int i = 0;
            while ((double)i < iter) {
                sha.reset();
                hash = sha.digest(hash);
                ++i;
            }
            return hash;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new UnforeseenException((Throwable)ex);
        }
    }

    @Override
    public String format(byte[] salt, byte[] hash) {
        return "s" + this.power + this.asString(salt) + this.asString(hash);
    }

    public String toString() {
        return "Simple(" + this.power + ")";
    }
}

