/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.security;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.XMLHelpers;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class IdentityConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentityConfig.class);
    private static final IdentityConfig DEFAULT = new IdentityConfig(Collections.emptyList(), Collections.emptyList(), AuthenticationOptions.INTERNAL, null, null);
    private final List<IdentityProvider> providers;
    private final List<Domain> domains;
    private final AuthenticationOptions defaultAuth;
    private final @Nullable String defaultProvider;
    private final @Nullable Portal portal;

    private IdentityConfig(List<IdentityProvider> providers, List<Domain> domains, AuthenticationOptions defaultAuth, @Nullable String defaultProvider, @Nullable Portal portal) {
        this.providers = providers;
        this.domains = domains;
        this.defaultAuth = defaultAuth;
        this.defaultProvider = defaultProvider;
        this.portal = portal;
    }

    public AuthenticationOptions getDefaultAuth() {
        return this.defaultAuth;
    }

    public @Nullable String getDefaultProvider() {
        return this.defaultProvider;
    }

    public @Nullable String getPortalHref() {
        return this.portal != null ? this.portal.href : null;
    }

    public @Nullable String getPortalTitle() {
        return this.portal != null ? this.portal.title : null;
    }

    public @Nullable Portal getPortal() {
        return this.portal;
    }

    public Set<String> filterExternalProviders(String authorityUrl, Set<String> clientIds) {
        return clientIds.stream().filter(aud -> this.isExternalProvider(authorityUrl, (String)aud)).collect(Collectors.toSet());
    }

    public boolean isExternalProvider(String authorityUrl, String clientId) {
        for (IdentityProvider provider : this.providers) {
            if (!provider.authorityUrl.equals(authorityUrl) || !provider.clientId.equals(clientId)) continue;
            return true;
        }
        return false;
    }

    public boolean allowsPassword(@Nullable String domainName) {
        if (domainName == null || domainName.isEmpty()) {
            return false;
        }
        return this.getAuthentication((String)domainName).allowsPassword;
    }

    public boolean allowsIDToken(@Nullable String domainName) {
        if (domainName == null || domainName.isEmpty()) {
            return false;
        }
        return this.getAuthentication((String)domainName).allowsIDToken;
    }

    public boolean allowsProvider(@Nullable String domainName, @Nullable String providerId) {
        if (domainName == null || domainName.isEmpty()) {
            return false;
        }
        Domain domain = this.findDomain(domainName);
        if (domain != null) {
            if (!domain.auth.allowsIDToken()) {
                return false;
            }
            if (domain.providers.isEmpty()) {
                return true;
            }
            return domain.providers.contains(providerId);
        }
        if (!this.defaultAuth.allowsIDToken()) {
            return false;
        }
        if (this.defaultProvider != null) {
            return this.defaultProvider.equals(providerId);
        }
        return true;
    }

    public boolean allowsPasswordForEmail(@Nullable String email) {
        if (email == null || email.isEmpty() || "No Email".equals(email) || email.indexOf(64) == -1) {
            return true;
        }
        return this.allowsPassword(this.toDomain(email));
    }

    public boolean allowsIDTokenForEmail(@Nullable String email) {
        return this.allowsIDToken(this.toDomain(email));
    }

    public boolean allowsProviderForEmail(@Nullable String email, String authorityUrl, Set<String> clientIds) {
        for (String clientId : clientIds) {
            if (!this.allowsProviderForEmail(email, authorityUrl, clientId)) continue;
            return true;
        }
        return false;
    }

    public boolean allowsProviderForEmail(@Nullable String email, String authorityUrl, String clientId) {
        IdentityProvider p = this.findProvider(authorityUrl, clientId);
        return p != null && this.allowsProvider(this.toDomain(email), p.id);
    }

    private @Nullable String toDomain(@Nullable String email) {
        if (email == null) {
            return null;
        }
        int at = email.indexOf(64);
        if (at <= 0) {
            return null;
        }
        return email.substring(at + 1);
    }

    public AuthenticationOptions getAuthentication(String domainName) {
        Domain domain = this.findDomain(domainName);
        return domain != null ? domain.auth : this.defaultAuth;
    }

    private @Nullable Domain findDomain(String domainName) {
        for (Domain domain : this.domains) {
            if (!domain.name.equals(domainName)) continue;
            return domain;
        }
        String wildcard = domainName.replaceFirst("^[^.]{1,256}\\.", "*.");
        for (Domain domain : this.domains) {
            if (!domain.name.equals(wildcard)) continue;
            return domain;
        }
        return null;
    }

    private @Nullable IdentityProvider findProvider(String authorityUrl, String clientId) {
        for (IdentityProvider provider : this.providers) {
            if (!provider.authorityUrl.equals(authorityUrl) || !provider.clientId.equals(clientId)) continue;
            return provider;
        }
        return null;
    }

    public static IdentityConfig defaultConfig() {
        return DEFAULT;
    }

    public static IdentityConfig load(File file) {
        IdentityConfig config = IdentityConfig.defaultConfig();
        LOGGER.info("Loading external identity config from {}", (Object)file.getName());
        try (FileInputStream in = new FileInputStream(file);){
            InputSource source = new InputSource(in);
            config = IdentityConfig.load(source);
            LOGGER.info("Loaded external ID providers: {}", config.providers);
            LOGGER.info("Loaded external domains: {}", config.domains);
        }
        catch (Exception ex) {
            LOGGER.error("Unable to read identity config: {}", (Object)ex.getMessage(), (Object)ex);
        }
        return config;
    }

    public static IdentityConfig load(InputSource source) {
        try {
            SAXParserFactory factory = XMLHelpers.safeSAXParserFactory();
            SAXParser parser = factory.newSAXParser();
            Handler handler = new Handler();
            parser.parse(source, (DefaultHandler)handler);
            return new IdentityConfig(handler.providers, handler.domains, handler.defaultAuth, handler.defaultProvider, handler.portal);
        }
        catch (SAXParseException ex) {
            LOGGER.error("Unable to parse identity config: {}, line {}, column {}", new Object[]{ex.getMessage(), ex.getLineNumber(), ex.getColumnNumber()});
        }
        catch (Exception ex) {
            LOGGER.error("Unable to load identity config: {}", (Object)ex.getMessage(), (Object)ex);
        }
        return IdentityConfig.defaultConfig();
    }

    public void output(UniversalPrinter printer) {
        printer.startObject("identity-config");
        printer.field("default-authentication", this.defaultAuth.name().toLowerCase());
        if (this.defaultProvider != null) {
            printer.field("default-provider", this.defaultProvider.toLowerCase());
        }
        if (this.portal != null) {
            printer.startObject("portal");
            printer.field("title", this.portal.title);
            printer.field("href", this.portal.href);
            if (this.portal.display != PortalDisplay.ON_ERROR) {
                printer.field("display", this.portal.display.name().toLowerCase());
            }
            printer.endObject();
        }
        printer.startCollection("providers", OutputPrinter.CollectionOption.JSON_ONLY);
        for (IdentityProvider provider : this.providers) {
            printer.startObject("provider");
            if (!provider.id.isEmpty()) {
                printer.field("id", provider.id);
            }
            printer.field("client-id", provider.clientId);
            printer.field("authority-url", provider.authorityUrl);
            printer.field("description", provider.description);
            printer.field("title", provider.title);
            printer.endObject();
        }
        printer.endCollection();
        printer.startCollection("domains", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Domain domain : this.domains) {
            printer.startObject("domain");
            printer.field("name", domain.name);
            printer.field("authentication", domain.auth.name().toLowerCase());
            if (domain.auth == AuthenticationOptions.EXTERNAL) {
                printer.field("external-only", true);
            }
            if (!domain.providers.isEmpty()) {
                printer.field("providers", domain.providers.toArray(new String[0]));
            }
            printer.endObject();
        }
        printer.endCollection();
        printer.endObject();
    }

    private static class Handler
    extends DefaultHandler {
        private final List<IdentityProvider> providers = new ArrayList<IdentityProvider>();
        private final List<Domain> domains = new ArrayList<Domain>();
        private @Nullable Portal portal = null;
        private AuthenticationOptions defaultAuth = AuthenticationOptions.INTERNAL;
        private @Nullable String defaultProvider = null;
        private @Nullable Locator locator = null;

        private Handler() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            try {
                switch (qName) {
                    case "external-identity": {
                        this.handleExternalIdentity();
                        break;
                    }
                    case "identity-config": {
                        this.handleIdentityConfig(atts);
                        break;
                    }
                    case "provider": {
                        this.handleProvider(atts);
                        break;
                    }
                    case "domain": {
                        this.handleDomain(atts);
                        break;
                    }
                    case "portal": {
                        this.handlePortal(atts);
                        break;
                    }
                    default: {
                        LOGGER.error("Found unknown element in identity-config.xml");
                        break;
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                throw new SAXParseException(ex.getMessage(), this.locator);
            }
        }

        private void handleExternalIdentity() {
            LOGGER.warn("Identity config uses legacy element `external-identity`, use `identity-config` instead");
        }

        private void handleIdentityConfig(Attributes atts) {
            String defaultAuthAtt = atts.getValue("default-authentication");
            if (defaultAuthAtt != null) {
                this.defaultAuth = AuthenticationOptions.valueOf(defaultAuthAtt.toUpperCase());
            }
            this.defaultProvider = atts.getValue("default-provider");
        }

        private void handleProvider(Attributes atts) {
            String authorityUrl = atts.getValue("authority-url");
            String clientId = atts.getValue("client-id");
            String description = atts.getValue("description");
            String title = atts.getValue("title");
            String id = atts.getValue("id");
            this.providers.add(new IdentityProvider(authorityUrl, clientId, description, title, id));
        }

        private void handleDomain(Attributes atts) {
            String name = atts.getValue("name");
            AuthenticationOptions auth = this.getAuthenticationMechanism(atts);
            List<String> domainProviders = this.getDomainProviders(atts);
            this.domains.add(new Domain(name, auth, domainProviders));
        }

        private List<String> getDomainProviders(Attributes atts) {
            String providerAttributes = atts.getValue("providers");
            if (providerAttributes != null) {
                return Arrays.asList(providerAttributes.split(" "));
            }
            if (this.defaultProvider != null) {
                return Collections.singletonList(this.defaultProvider);
            }
            return Collections.emptyList();
        }

        private AuthenticationOptions getAuthenticationMechanism(Attributes atts) {
            String authAtt = atts.getValue("authentication");
            if (authAtt != null) {
                return AuthenticationOptions.fromAttribute(authAtt);
            }
            if ("true".equals(atts.getValue("external-only"))) {
                LOGGER.warn("Identity config uses legacy attribute `external-only=true`, use `authentication=external` instead");
                return AuthenticationOptions.EXTERNAL;
            }
            return AuthenticationOptions.ANY;
        }

        private void handlePortal(Attributes atts) {
            PortalDisplay display;
            String href = atts.getValue("href");
            String title = atts.getValue("title");
            String displayAttribute = atts.getValue("display");
            PortalDisplay portalDisplay = display = displayAttribute != null ? PortalDisplay.fromAttribute(displayAttribute) : PortalDisplay.ON_ERROR;
            if (title != null && href != null) {
                this.portal = new Portal(title, href, display);
            } else {
                LOGGER.error("Missing required attribute for portal in identity config");
            }
        }
    }

    private static class Domain {
        private final String name;
        private final AuthenticationOptions auth;
        private final List<String> providers;

        public Domain(String name, AuthenticationOptions auth, List<String> providers) {
            this.name = name;
            this.auth = auth;
            this.providers = providers;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Portal {
        private final String title;
        private final String href;
        private final PortalDisplay display;

        public Portal(String title, String href, PortalDisplay display) {
            this.title = title;
            this.href = href;
            this.display = display;
        }

        public String getTitle() {
            return this.title;
        }

        public PortalDisplay getDisplay() {
            return this.display;
        }

        public String getHref() {
            return this.href;
        }
    }

    private static class IdentityProvider {
        private final String authorityUrl;
        private final String clientId;
        private final String description;
        private final String title;
        private final String id;

        public IdentityProvider(String authorityUrl, String clientId, @Nullable String description, @Nullable String title, @Nullable String id) {
            this.authorityUrl = authorityUrl;
            this.clientId = clientId;
            this.description = Objects.toString(description, "");
            this.title = Objects.toString(title, "");
            this.id = Objects.toString(id, "");
        }

        public String toString() {
            return this.authorityUrl + " (" + this.title + ")";
        }
    }

    public static enum AuthenticationOptions {
        INTERNAL(true, false),
        EXTERNAL(false, true),
        ANY(true, true),
        NONE(false, false);

        private final boolean allowsPassword;
        private final boolean allowsIDToken;

        private AuthenticationOptions(boolean allowsPassword, boolean allowsIDToken) {
            this.allowsIDToken = allowsIDToken;
            this.allowsPassword = allowsPassword;
        }

        public boolean allowsIDToken() {
            return this.allowsIDToken;
        }

        public boolean allowsPassword() {
            return this.allowsPassword;
        }

        static AuthenticationOptions fromAttribute(String value) {
            for (AuthenticationOptions auth : AuthenticationOptions.values()) {
                if (!auth.name().toLowerCase().equals(value)) continue;
                return auth;
            }
            throw new IllegalArgumentException("Invalid authentication value");
        }
    }

    public static enum PortalDisplay {
        ON_ERROR,
        ALWAYS,
        ONLY;


        static PortalDisplay fromAttribute(String display) {
            for (PortalDisplay p : PortalDisplay.values()) {
                if (!p.name().toLowerCase().equals(display)) continue;
                return p;
            }
            throw new IllegalArgumentException("Invalid display value");
        }
    }
}

