/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.rule;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.LocatorRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.Notify;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkChanges;
import com.pageseeder.base.util.HTMLSanitizer;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Content;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupForXLink;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.LocatorForXLink;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.model.XLinkForAttachedXLink;
import com.pageseeder.db.util.Labels;
import com.pageseeder.db.util.XLinks;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class XLinkRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(XLinkRule.class);

    private XLinkRule() {
    }

    public static void archiveReverseXRefsForFragment(Database db, URI uri, String fragment, Group group, Date modified) throws QueryFailedException {
        Collection xrefs = DatabaseQuery.getReverseXRefsByURIFragmentGroup((Database)db, (URI)uri, (String)fragment, (Group)group);
        for (XLink xref : xrefs) {
            xref.setStatus("Documentation-Old");
            xref.setStatusChangedDate(modified);
            Collection lfxs = xref.getLocatorsForXLinkCol();
            for (LocatorForXLink lfx : lfxs) {
                URI u;
                Locator loc;
                if (!"xref-source-manual-link".equals(lfx.getRole()) || (loc = lfx.getLocator()) == null || (u = loc.getURI()) == null) continue;
                u.setLastModified(modified);
            }
        }
    }

    public static boolean archiveXLink(XLink xlink) {
        boolean archived = false;
        String role = xlink.getContentRole();
        if (role == null) {
            xlink.setContentRole("Archive");
            archived = true;
        } else if (!(role.startsWith("archive-") || "Archive".equals(role) || "Description".equals(role))) {
            xlink.setContentRole("archive-" + role);
            archived = true;
        }
        return archived;
    }

    public static String getAuthorName(XLink xlink) {
        return xlink.getMember() != null ? MemberRule.getFullName(xlink.getMember()) : xlink.getAuthorName();
    }

    public static Collection<Group> getGroups(XLink xlink) {
        ArrayList<Group> groups = new ArrayList<Group>();
        Iterator i = xlink.getGroupsForXLink();
        while (i.hasNext()) {
            GroupForXLink gfx = (GroupForXLink)i.next();
            groups.add(gfx.getGroup());
        }
        return groups;
    }

    public static @Nullable Group getMainGroup(XLink xlink) {
        return XLinkRule.getMainGroup(XLinkRule.getGroups(xlink));
    }

    public static String getMainGroupName(XLink xlink) {
        Group main = XLinkRule.getMainGroup(xlink);
        if (main == null) {
            return "";
        }
        return main.getName();
    }

    public static @Nullable Group getMainGroup(Collection<Group> groups) {
        Objects.requireNonNull(groups, "No groups specified");
        for (Group group : groups) {
            if (GroupRule.isAdminGroup(group.getName()) || GroupRule.isPublicGroup(group.getName())) continue;
            return group;
        }
        return null;
    }

    public static void addXLink(Database db, XLink xl, URI uri, String locFrag, @Nullable Long replyToId) throws DatabaseException {
        if (replyToId != null) {
            XLink replyTo = DatabaseQuery.getXLinkById((Database)db, (Long)replyToId);
            XLink threadRoot = XLinks.getThreadRoot((XLink)replyTo);
            threadRoot.addReplies(xl);
        } else {
            LocatorRule.addXLinkToLocator(db, xl, uri, locFrag);
        }
    }

    public static boolean addGroups(Database db, XLink xlink, String @Nullable [] groups) throws DatabaseException {
        boolean isPublic = false;
        boolean adminAdded = false;
        if (groups != null) {
            for (String name : groups) {
                Group group = DatabaseQuery.getGroupByName((Database)db, (String)name);
                if (group == null) continue;
                GroupForXLink gfx = GroupForXLink.create((Database)db);
                gfx.setGroup(group);
                xlink.addGroupsForXLink(gfx);
                gfx = gfx.insert(db);
                if (GroupRule.isAdminGroup(name)) {
                    adminAdded = true;
                }
                if (!group.hasFlag('p')) continue;
                isPublic = true;
            }
        }
        if (!adminAdded) {
            Group admin = DatabaseQuery.getGroupByName((Database)db, (String)"admin");
            GroupForXLink gfx = GroupForXLink.create((Database)db);
            gfx.setGroup(admin);
            xlink.addGroupsForXLink(gfx);
            gfx = gfx.insert(db);
        }
        return isPublic;
    }

    public static boolean addGroups(Database db, XLink xlink, @Nullable Collection<Group> groups) throws DatabaseException {
        Group admin;
        boolean isPublic = false;
        boolean adminAdded = false;
        Collection<Group> cur_groups = XLinkRule.getGroups(xlink);
        if (groups != null) {
            for (Group group : groups) {
                if (!cur_groups.contains(group)) {
                    GroupForXLink gfx = GroupForXLink.create((Database)db);
                    gfx.setGroup(group);
                    xlink.addGroupsForXLink(gfx);
                    gfx = gfx.insert(db);
                    if (GroupRule.isAdminGroup(group.getName())) {
                        adminAdded = true;
                    }
                }
                if (!group.hasFlag('p')) continue;
                isPublic = true;
            }
        }
        if (!adminAdded && !cur_groups.contains(admin = DatabaseQuery.getGroupByName((Database)db, (String)"admin"))) {
            GroupForXLink gfx = GroupForXLink.create((Database)db);
            gfx.setGroup(admin);
            xlink.addGroupsForXLink(gfx);
            gfx = gfx.insert(db);
        }
        return isPublic;
    }

    public static List<Long> modifyGroupsByURI(Database db, URI uri, Group sourceGroup, String[] groups, Object predicate) throws DatabaseException {
        ArrayList<Group> addGroups = new ArrayList<Group>();
        for (String value : groups) {
            if (value == null || value.isEmpty()) continue;
            Group group = null;
            if (value.matches("^\\d.*?$")) {
                try {
                    group = DatabaseQuery.getGroupById((Database)db, (Long)Long.parseLong(value));
                }
                catch (NumberFormatException e) {
                    group = null;
                }
            }
            if (group == null) {
                group = DatabaseQuery.getGroupByName((Database)db, (String)value);
            }
            if (group == null) continue;
            addGroups.add(group);
        }
        return XLinkRule.modifyGroupsByURI(db, uri, sourceGroup, addGroups, predicate);
    }

    public static List<Long> modifyGroupsByURI(Database db, URI uri, @Nullable Group sourceGroup, Collection<Group> addGrpc, @Nullable Object lfxPredicate) throws DatabaseException {
        ArrayList<Long> xlinkIds = new ArrayList<Long>();
        if (addGrpc.isEmpty()) {
            return xlinkIds;
        }
        Group group = DatabaseQuery.getGroupByName((Database)db, (String)"admin");
        assert (group != null);
        addGrpc.add(group);
        Iterator loci = uri.getLocators();
        while (loci.hasNext()) {
            Iterator lfxi;
            Locator loc = (Locator)loci.next();
            Iterator iterator = lfxi = lfxPredicate == null ? loc.getXLinksForLocator() : loc.getXLinksForLocator(lfxPredicate);
            while (lfxi.hasNext()) {
                LocatorForXLink lfx = (LocatorForXLink)lfxi.next();
                XLink xl = lfx.getXLink();
                Collection<Group> cur_grpc = XLinkRule.getGroups(xl);
                if (sourceGroup == null || cur_grpc.contains(sourceGroup)) {
                    XLinkRule.modifyGroups(db, xl, addGrpc);
                    xlinkIds.add(xl.getId());
                }
                Iterator replies = xl.getReplies();
                while (replies.hasNext()) {
                    XLink reply = (XLink)replies.next();
                    cur_grpc = XLinkRule.getGroups(reply);
                    if (sourceGroup != null && !cur_grpc.contains(sourceGroup)) continue;
                    XLinkRule.modifyGroups(db, reply, addGrpc);
                    xlinkIds.add(reply.getId());
                }
            }
        }
        return xlinkIds;
    }

    public static XLink copyXLink(Database db, XLink xlink) throws DatabaseException {
        return XLinkRule.copyXLinkWithGroups(db, xlink, XLinkRule.getGroups(xlink));
    }

    public static XLink copyXLinkWithGroups(Database db, XLink xlink, Collection<Group> groups) throws DatabaseException {
        Objects.requireNonNull(xlink, "Cannot copy null xlink");
        XLink copy = XLink.create((Database)db);
        copy.setAccepted(xlink.getAccepted());
        copy.setAssignedDate(xlink.getAssignedDate());
        copy.setAssignedTo(xlink.getAssignedTo());
        copy.setAuthorEmail(xlink.getAuthorEmail());
        copy.setAuthorName(xlink.getAuthorName());
        copy.setAuthorOnly(xlink.getAuthorOnly());
        copy.setContentRole(xlink.getContentRole());
        copy.setContentTitle(xlink.getContentTitle());
        copy.setDate(xlink.getDate());
        copy.setDueDate(xlink.getDueDate());
        copy.setExternalUserId(xlink.getExternalUserId());
        copy.setMember(xlink.getMember());
        copy.setModeratorOnly(xlink.getModeratorOnly());
        copy.setModifiedBy(xlink.getModifiedBy());
        copy.setModifiedDate(xlink.getModifiedDate());
        copy.setPriority(xlink.getPriority());
        copy.setProperties(xlink.getProperties());
        copy.setStatus(xlink.getStatus());
        copy.setStatusChangedBy(xlink.getStatusChangedBy());
        copy.setStatusChangedDate(xlink.getStatusChangedDate());
        copy.setType(xlink.getType());
        XLinkRule.addGroups(db, copy, groups);
        Iterator conti = xlink.getContents();
        while (conti.hasNext()) {
            Content cont = (Content)conti.next();
            Content copy_cont = Content.create((Database)db);
            copy_cont.setBinaryData(cont.getBinaryData());
            copy_cont.setData(cont.getData());
            copy_cont.setType(cont.getType());
            copy.addContents(copy_cont);
        }
        return copy;
    }

    public static void deleteXLink(Database db, XLink xlink) throws DatabaseException {
        XLinkRule.deleteXLink(db, xlink, false);
    }

    public static void deleteXLink(Database db, XLink xlink, boolean uriXlink) throws DatabaseException {
        xlink.setThreadEnd(null);
        Iterator replies = xlink.getReplies();
        while (replies.hasNext()) {
            XLink reply = (XLink)replies.next();
            xlink.removeReplies(reply);
            reply.delete(db);
            reply = null;
        }
        if (!uriXlink) {
            XLinkRule.removeXLink(db, xlink, true);
        }
        xlink.delete(db);
    }

    public static void deleteXLink(Database db, Transaction tr, XLink xlink, @Nullable Locator locator) throws DatabaseException {
        XLink threadRoot = XLinks.getThreadRoot((XLink)xlink);
        if (locator != null) {
            XLinkRule.moveReplies(db, xlink, locator);
        }
        XLinkRule.removeXLink(db, xlink, true);
        for (Content c : xlink.getContentsCol()) {
            c.delete(db);
        }
        for (GroupForXLink gfx : xlink.getGroupsForXLinkCol()) {
            gfx.delete(db);
        }
        if (!xlink.equals((Object)threadRoot) && xlink.equals((Object)threadRoot.getThreadEnd())) {
            XLinkRule.updateThreadEnd(threadRoot);
        }
        xlink.setThreadEnd(null);
        tr.commitAndStart();
        xlink.delete(db);
    }

    public static @Nullable XLink moveReplies(Database db, XLink xlink, Locator locator) throws DatabaseException {
        XLink firstReply;
        Collection replies = xlink.getRepliesCol();
        XLink xLink = firstReply = replies == null || replies.isEmpty() ? null : (XLink)replies.iterator().next();
        if (firstReply != null) {
            LocatorRule.addXLinkToLocator(db, firstReply, locator);
            if (replies != null) {
                for (XLink reply : replies) {
                    if (reply.getId().equals(firstReply.getId())) continue;
                    firstReply.addReplies(reply);
                    xlink.removeReplies(reply);
                }
            }
            xlink.removeReplies(firstReply);
            XLinkRule.updateThreadEnd(firstReply);
        }
        return firstReply;
    }

    public static void updateThreadEnd(XLink root) {
        XLink end = root;
        Collection replies = root.getRepliesCol();
        for (XLink reply : replies) {
            if (XLinks.isArchived((XLink)reply) || !reply.getAccepted().booleanValue() || reply.getId().compareTo(end.getId()) <= 0) continue;
            end = reply;
        }
        root.setThreadEnd(end);
    }

    public static boolean isTask(@Nullable XLink xl) {
        if (xl == null) {
            return false;
        }
        XLink root = XLinks.getThreadRoot((XLink)xl);
        XLink end = root.getThreadEnd();
        if (end != null) {
            return XLinkRule.hasStatusAcceptedAndNotArchived(end);
        }
        return XLinkRule.hasStatusAcceptedAndNotArchived(root);
    }

    private static boolean hasStatusAcceptedAndNotArchived(XLink xl) {
        return xl.getStatus() != null && xl.getAccepted() != false && !XLinks.isArchived((XLink)xl);
    }

    public static boolean isIndexable(@Nullable XLink xlink) {
        if (xlink == null) {
            return false;
        }
        String role = xlink.getContentRole();
        return "Comment".equals(role) || "File Attachment".equals(role) || "archive-Comment".equals(role) || "archive-File Attachment".equals(role) || "Workflow".equals(role);
    }

    public static boolean isPublic(XLink xlink) {
        Iterator grpi = xlink.getGroupsForXLink();
        while (grpi.hasNext()) {
            GroupForXLink gfxl = (GroupForXLink)grpi.next();
            Group group = gfxl.getGroup();
            if (!group.hasFlag('p')) continue;
            return true;
        }
        return false;
    }

    public static Date parseDueDate(String dueDate) throws ParseException {
        if (dueDate.length() == 10) {
            int eighteen_hours = 64800000;
            Date date = ISO8601.CALENDAR_DATE.parse(dueDate);
            date.setTime(date.getTime() + 64800000L);
            return date;
        }
        return ISO8601.DATETIME.parse(dueDate);
    }

    public static boolean belongsToGroup(@Nullable XLink xl, @Nullable Group group) {
        if (xl == null || group == null) {
            return false;
        }
        for (GroupForXLink gfx : xl.getGroupsForXLinkCol()) {
            if (gfx.getGroup().getId().longValue() != group.getId().longValue()) continue;
            return true;
        }
        return false;
    }

    public static boolean modifyGroups(Database db, XLink xlink, Collection<Group> groups) throws DatabaseException {
        boolean isPublic = false;
        Collection<Group> cur_grps = XLinkRule.getGroups(xlink);
        ArrayList<Group> modifiableGroups = new ArrayList<Group>(groups);
        if (!GroupRule.containsAdminGroup(modifiableGroups)) {
            modifiableGroups.add(DatabaseQuery.getGroupByName((Database)db, (String)"admin"));
        }
        for (Group group : modifiableGroups) {
            if (GroupRule.isPublicGroup(group.getName())) continue;
            if (!cur_grps.contains(group)) {
                GroupForXLink gfx = GroupForXLink.create((Database)db);
                gfx.setGroup(group);
                xlink.addGroupsForXLink(gfx);
                gfx = gfx.insert(db);
                cur_grps.add(group);
            }
            if (!group.hasFlag('p')) continue;
            isPublic = true;
        }
        Iterator curi = xlink.getGroupsForXLink();
        while (curi.hasNext()) {
            GroupForXLink gfx = (GroupForXLink)curi.next();
            Group group = gfx.getGroup();
            if (modifiableGroups.contains(group)) continue;
            xlink.removeGroupsForXLink(gfx);
            gfx.delete(db);
            gfx = null;
        }
        return isPublic;
    }

    public static void removeXLink(Database db, XLink xlink, boolean allLocators) throws DatabaseException {
        XLink threadRoot = XLinks.getThreadRoot((XLink)xlink);
        if (xlink != threadRoot) {
            threadRoot.removeReplies(xlink);
        } else if (allLocators) {
            LocatorRule.removeAllXLinkLocators(db, xlink);
        } else {
            LocatorForXLink locfxl = LocatorRule.getLocatorForXLinkByXLink(xlink);
            Locator loc = locfxl.getLocator();
            xlink.removeLocatorsForXLink(locfxl);
            loc.removeXLinksForLocator(locfxl);
            xlink.removeReplies(xlink);
            locfxl.delete(db);
            locfxl = null;
        }
    }

    public static void removeAttachments(Database db, XLink xlink) throws DatabaseException {
        Iterator loci = xlink.getLocatorsForXLink();
        while (loci.hasNext()) {
            LocatorForXLink locfxl = (LocatorForXLink)loci.next();
            Locator loc = locfxl.getLocator();
            if (locfxl.getRole() == null) continue;
            xlink.removeLocatorsForXLink(locfxl);
            loc.removeXLinksForLocator(locfxl);
            locfxl.delete(db);
            Object var3_3 = null;
        }
    }

    public static void moveAttachments(XLink from, XLink to) {
        Iterator loci = from.getLocatorsForXLink();
        while (loci.hasNext()) {
            LocatorForXLink locfxl = (LocatorForXLink)loci.next();
            if (locfxl.getRole() == null) continue;
            to.addLocatorsForXLink(locfxl);
            from.removeLocatorsForXLink(locfxl);
        }
    }

    public static Collection<Group> getXRefGroups(XLink xref, Group group, Database db) throws DatabaseException {
        URI source = null;
        URI target = null;
        boolean reverselink = true;
        for (LocatorForXLink lfx : xref.getLocatorsForXLinkCol()) {
            URI uri = lfx.getLocator().getURI();
            if (lfx.getRole() != null && lfx.getRole().contains("xref-source")) {
                if (lfx.getRole().equals("xref-source")) {
                    reverselink = false;
                }
                source = uri;
                continue;
            }
            target = uri;
        }
        if (source == null || target == null) {
            LOGGER.error("Found invalid XRef XLink (id {}) with no source or target", (Object)xref.getId());
        }
        ArrayList<Group> groups = new ArrayList<Group>(GroupRule.getEditGroups(db, group, source));
        if (target != null && reverselink && !target.getExternal().booleanValue()) {
            Collection<Group> targetGroups = GroupRule.getEditGroups(db, group, target);
            for (Group gp : targetGroups) {
                if (groups.contains(gp)) continue;
                groups.add(gp);
            }
        }
        return groups;
    }

    public static String getVersionName(Database db, URI uri, @Nullable Long versionid, @Nullable Publication pub) throws QueryFailedException {
        if (versionid == null || versionid < 0L) {
            return "current";
        }
        if (versionid == 0L) {
            return "original";
        }
        List<XLink> versions = URIRule.getReleasesForURI(db, uri, pub, 1, -1, null);
        for (XLink xl : versions) {
            if (xl.getId() < versionid) continue;
            return xl.getContentTitle();
        }
        return "current";
    }

    public static @Nullable Long getValidRelease(Database db, URI uri, @Nullable Long releaseID, @Nullable String releaseVersion, @Nullable Publication pub) throws QueryFailedException {
        if ("".equals(releaseVersion) || "current".equals(releaseVersion)) {
            releaseVersion = null;
        }
        if ((releaseID == null || releaseID == -1L) && releaseVersion == null) {
            return null;
        }
        if (releaseID != null && releaseID == 0L) {
            return 0L;
        }
        if ("original".equals(releaseVersion)) {
            return 0L;
        }
        NumericalVersion release_num = null;
        try {
            if (releaseVersion != null) {
                release_num = new NumericalVersion(releaseVersion);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Date release_date = null;
        try {
            if (releaseVersion != null) {
                release_date = ISO8601.CALENDAR_DATE.isParsable(releaseVersion) ? ISO8601.CALENDAR_DATE.parse(releaseVersion) : null;
            }
        }
        catch (ParseException ex) {
            LOGGER.warn("Invalid version date: {}: {}", (Object)releaseVersion, (Object)ex.getMessage());
        }
        List<XLink> releases = URIRule.getReleasesForURI(db, uri, pub == null ? Publications.blank(uri, null) : pub, 1, -1, null);
        XLink tempVersion = null;
        NumericalVersion temp_version_num = new NumericalVersion("0");
        Date temp_version_date = null;
        Iterator iterator = releases.iterator();
        while (iterator.hasNext()) {
            XLink xLink;
            XLink xl = xLink = (XLink)iterator.next();
            String version = xl.getContentTitle();
            if (releaseID != null) {
                if (!releaseID.equals(xl.getId())) continue;
                return releaseID;
            }
            if (release_num != null) {
                try {
                    NumericalVersion versionNumber = new NumericalVersion(version);
                    if (versionNumber.compareTo(release_num) > 0 || versionNumber.compareTo(temp_version_num) < 0 || versionNumber.compareTo(temp_version_num) <= 0 && (tempVersion == null || xl.getId() <= tempVersion.getId())) continue;
                    tempVersion = xl;
                    temp_version_num = versionNumber;
                }
                catch (NumberFormatException versionNumber) {}
                continue;
            }
            if (release_date != null) {
                try {
                    Date version_date = null;
                    try {
                        version_date = ISO8601.CALENDAR_DATE.isParsable(version) ? ISO8601.CALENDAR_DATE.parse(version) : null;
                    }
                    catch (ParseException ex) {
                        LOGGER.warn("Invalid version date {} for {}: {}", new Object[]{releaseVersion, xl.getId(), ex.getMessage()});
                    }
                    if (version_date == null || !version_date.before(release_date) && !XLinkRule.sameDate(release_date, version_date) || temp_version_date != null && !version_date.after(temp_version_date) && (!XLinkRule.sameDate(temp_version_date, version_date) || xl.getId() <= tempVersion.getId())) continue;
                    tempVersion = xl;
                    temp_version_date = version_date;
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (releaseVersion == null || !releaseVersion.equals(version) || tempVersion != null && xl.getId() <= tempVersion.getId()) continue;
            tempVersion = xl;
        }
        if (tempVersion != null) {
            return tempVersion.getId();
        }
        if (releaseID != null) {
            return -1L;
        }
        return 0L;
    }

    private static boolean sameDate(@Nullable Date first, @Nullable Date second) {
        if (first == null || second == null) {
            return false;
        }
        Calendar f = Calendar.getInstance();
        f.setTime(first);
        Calendar s = Calendar.getInstance();
        s.setTime(second);
        return f.get(5) == s.get(5) && f.get(2) == s.get(2) && f.get(1) == s.get(1);
    }

    public static boolean unarchiveXLink(XLink xl) {
        boolean res = false;
        String role = xl.getContentRole();
        if ("Archive".equals(role)) {
            xl.setContentRole("Comment");
            res = true;
        } else if (role.startsWith("archive-")) {
            xl.setContentRole(role.substring(8));
            res = true;
        }
        return res;
    }

    public static XLink createEditXLink(URI uri, String fragment, String title, String role, @Nullable String status, boolean editBehavior, Group group, @Nullable String properties, String @Nullable [] labels, String content, String contentType, Date creationDate, Member mem, Database db) throws DatabaseException {
        Objects.requireNonNull(mem, "Cannot create an edit with a null member, use other method.");
        return XLinkRule.createEditXLink(uri, fragment, title, role, status, editBehavior, group, properties, labels, content, contentType, mem, null, null, null, creationDate, db);
    }

    public static XLink createEditXLink(URI uri, String fragment, String title, String role, @Nullable String status, boolean editBehavior, Group group, @Nullable String properties, String @Nullable [] labels, String content, String contentType, @Nullable Member mem, @Nullable String externalUserID, @Nullable String externalFName, @Nullable String externalEmail, @Nullable Date creationDate, Database db) throws DatabaseException {
        XLink xl = XLink.create((Database)db);
        xl.setContentRole(role);
        xl.setAccepted(Boolean.TRUE);
        xl.setModeratorOnly(Boolean.FALSE);
        xl.setContentTitle(title);
        if (mem != null) {
            xl.setMember(mem);
        } else {
            if (externalUserID != null) {
                xl.setExternalUserId(externalUserID);
            }
            if (externalFName != null) {
                xl.setAuthorName(externalFName);
            } else {
                xl.setAuthorName("Anonymous");
            }
            if (externalEmail != null) {
                xl.setAuthorEmail(externalEmail);
            } else {
                xl.setAuthorEmail("No Email");
            }
        }
        xl.setDate(creationDate == null ? new Date() : creationDate);
        xl.setProperties(properties);
        if (labels != null && labels.length > 0) {
            Labels.setLabels((XLink)xl, (String[])labels);
        }
        xl.setStatus(status);
        XLinkRule.addGroups(db, xl, GroupRule.getEditGroups(db, group, uri));
        Content cont = Content.create((Database)db);
        cont.setType(!editBehavior && "Documentation-Hidden".equals(role) ? "text/plain" : contentType);
        cont.setData(content);
        xl.addContents(cont);
        xl = xl.insert(db);
        XLinkRule.addXLink(db, xl, uri, fragment, null);
        return xl;
    }

    public static XLink createXRefXLink(Group group, String contentrole, String title, Member author, String[] labels, String type, boolean reverseLink, String reverseTitle, String reverseType, URI sourceUri, String sourceFragment, URI targetUri, String targetFragment, Date creationDate, Database db) throws DatabaseException {
        XLink xl = XLink.create((Database)db);
        xl.setContentRole(contentrole);
        xl.setAccepted(Boolean.valueOf(true));
        xl.setModeratorOnly(Boolean.valueOf(false));
        xl.setContentTitle(title == null ? "No Title" : title);
        xl.setMember(author);
        xl.setDate(creationDate == null ? new Date() : creationDate);
        if (labels != null && labels.length > 0) {
            Labels.setLabels((XLink)xl, (String[])labels);
        }
        Collection<Group> xgrpc = GroupRule.getEditGroups(db, group, sourceUri);
        if (reverseLink && !targetUri.getExternal().booleanValue()) {
            Collection<Group> xgrpc2 = GroupRule.getEditGroups(db, group, targetUri);
            for (Group grp : xgrpc2) {
                if (xgrpc.contains(grp)) continue;
                xgrpc.add(grp);
            }
        }
        XLinkRule.addGroups(db, xl, xgrpc);
        xl = xl.insert(db);
        try {
            Locator sloc = LocatorRule.getLocatorByURIFragment(db, sourceUri, sourceFragment, "page-link");
            Locator tloc = LocatorRule.getLocatorByURIFragment(db, targetUri, targetFragment, "page-link");
            LocatorRule.addXLinkToLocator(db, xl, sloc, reverseLink ? "xref-source-manual-link" : "xref-source", reverseLink ? reverseTitle : null, type);
            LocatorRule.addXLinkToLocator(db, xl, tloc, "xref-link", title, reverseLink ? reverseType : null);
        }
        catch (DatabaseException ex) {
            xl.delete(db);
            throw ex;
        }
        return xl;
    }

    public static XLink createStructureXLink(URI uri, Group group, Database db, String content, Member author, @Nullable Date created, String contentTitle) throws DatabaseException {
        return XLinkRule.createStructureXLink(uri, group, db, content, author, created, contentTitle, false);
    }

    public static XLink createStructureXLink(URI uri, Group group, Database db, String content, Member author, @Nullable Date created, String contentTitle, boolean statusNew) throws DatabaseException {
        XLink xl = XLink.create((Database)db);
        xl.setContentRole("Documentation-Structure");
        xl.setContentTitle(contentTitle);
        xl.setAccepted(Boolean.TRUE);
        xl.setModeratorOnly(Boolean.FALSE);
        xl.setMember(author);
        xl.setDate(created == null ? new Date() : created);
        if (statusNew) {
            xl.setStatus("Documentation-New");
        }
        XLinkRule.addGroups(db, xl, GroupRule.getEditGroups(db, group, uri));
        LocatorRule.addXLinkToLocator(db, xl, uri, "default");
        Content structureContent = Content.create((Database)db);
        structureContent.setType("text/xml");
        structureContent.setData(content);
        xl.addContents(structureContent);
        structureContent.insert(db);
        return xl.insert(db);
    }

    public static XLink createWorkflowXLink(Database db, URI uri, Member author, Date created, @Nullable String status, @Nullable String priority, @Nullable Long assigntoId, @Nullable Member assignto, @Nullable Date duedate, String[] labels, String content, String contentType, boolean draft, Group group, boolean updateCache) throws FoundationException, DatabaseException, URIException {
        Collection<Object> grps;
        Date last_assigned_date;
        XLink xl = XLink.create((Database)db);
        xl.setContentRole("Workflow");
        xl.setAccepted(Boolean.TRUE);
        xl.setModeratorOnly(Boolean.FALSE);
        xl.setContentTitle(uri.getDisplayTitle());
        xl.setMember(author);
        xl.setDate(created);
        if (draft) {
            xl.setAccepted(Boolean.valueOf(false));
            xl.setAuthorOnly(Boolean.valueOf(true));
        }
        XLink root = URIRule.getRootWorkflowForURI(db, uri);
        XLink last = null;
        if (status == null || priority == null || duedate == null || assigntoId == null) {
            last = URIRule.getLatestWorkflowForURI(db, root);
        }
        if (status == null && last == null) {
            throw new URIException("Status is required for first workflow");
        }
        status = status == null && last != null ? last.getStatus() : status;
        xl.setStatus(status);
        xl.setPriority(priority == null && last != null ? last.getPriority() : priority);
        xl.setDueDate((Date)(duedate == null && last != null ? last.getDueDate() : (new Date(0L).equals(duedate) ? null : duedate)));
        xl.setAssignedTo((Member)(assigntoId == null && last != null ? last.getAssignedTo() : (Long.valueOf(0L).equals(assigntoId) ? null : assignto)));
        Date date = last_assigned_date = last != null ? last.getAssignedDate() : null;
        if (xl.getAssignedTo() != null) {
            if (last == null || last.getAssignedTo() == null || !last.getAssignedTo().getId().equals(xl.getAssignedTo().getId())) {
                xl.setAssignedDate(created);
            } else if (last_assigned_date != null) {
                xl.setAssignedDate(new Date(last_assigned_date.getTime()));
            }
        }
        Labels.addLabels((XLink)xl, (String[])labels);
        if (uri.getExternal().booleanValue()) {
            grps = Collections.singleton(group);
        } else {
            grps = DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri.getId());
            grps = GroupRule.removePublicGroup(grps);
            if (root != null && !draft) {
                XLinkRule.modifyGroups(db, root, grps);
            }
        }
        XLinkRule.addGroups(db, xl, grps);
        Content cont = Content.create((Database)db);
        cont.setType(contentType);
        cont.setData(content);
        xl.addContents(cont);
        if (!draft) {
            if (root != null) {
                root.setThreadEnd(xl);
            } else {
                xl.setThreadEnd(xl);
            }
        }
        xl = xl.insert(db);
        XLinkRule.addXLink(db, xl, uri, "default", root == null ? null : root.getId());
        if (!draft) {
            if (updateCache) {
                DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), group.getName(), group.getId());
                resolver.modifyStatusInCache(status, uri.getLastModified(), created);
            }
            uri.setLastModified(created);
        }
        return xl;
    }

    public static void sendWorkflowNotification(Database db, Transaction tr, URI uri, XLink xl, Notify notify, Boolean async) throws DatabaseException, EmailException, FoundationException {
        XLinkChanges xlinkChange = new XLinkChanges(uri, async);
        xlinkChange.addXLinkChange(xl, "status-added", notify);
        if (notify != Notify.SILENT) {
            tr.commitAndStart();
        }
        xlinkChange.process(db);
        if (xlinkChange.getStatus() != XLinkChanges.ChangeStatus.SUCCESS) {
            LOGGER.error("XLinkChanges Status: {} Message: {}", (Object)xlinkChange.getStatus(), (Object)xlinkChange.getStatusMessage());
            xlinkChange.rollback(db);
            throw new FoundationException("Workflow could not be submitted: " + RuleUtils.defaultValue(xlinkChange.getStatusMessage(), "An error occured"));
        }
    }

    public static XLink createVersionXLink(Database db, URI uri, String version, @Nullable XLink publication, Member author, Date created, String[] labels, String content, Group group, Notify notify, Boolean async) throws FoundationException, DatabaseException {
        XLink xl = new XLink();
        xl.setContentRole("Documentation-Version");
        xl.setAccepted(Boolean.TRUE);
        xl.setModeratorOnly(Boolean.FALSE);
        xl.setContentTitle(version);
        xl.setMember(author);
        xl.setDate(created);
        Labels.addLabels((XLink)xl, (String[])labels);
        XLinkRule.addGroups(db, xl, GroupRule.getEditGroups(db, group, uri));
        Content cont = Content.create((Database)db);
        cont.setType("text/plain");
        cont.setData(content);
        xl.addContents(cont);
        xl = xl.insert(db);
        if (publication != null) {
            XLinkForAttachedXLink att = new XLinkForAttachedXLink();
            att.setXLink(xl);
            att.setAttachedXLink(publication);
            att.insert(db);
            xl.addAttached(att);
        }
        XLinkRule.addXLink(db, xl, uri, "default", null);
        uri.setLastModified(created);
        if (notify != Notify.SILENT) {
            Emails.sendNewVersion(db, xl, uri, notify, async);
        }
        return xl;
    }

    public static @Nullable String validateContent(String contenttype, @Nullable String content) throws FoundationException {
        if (content == null) {
            return null;
        }
        if (contenttype.endsWith("/xml") || contenttype.endsWith("+xml")) {
            try {
                List<String> errors;
                Object validate = content;
                if (contenttype.equals("application/xhtml+xml")) {
                    if ((content = HTMLSanitizer.sanitizeForComments(content)).isEmpty() && !Strings.isEmpty((String)validate)) {
                        throw new FoundationException("The XHTML content elements are not supported.");
                    }
                    validate = "<content>" + content + "</content>";
                }
                if (!(errors = XMLHelpers.validateWellFormednessReturnErrors((String)validate)).isEmpty()) {
                    throw new FoundationException("The content was invalid: " + String.join((CharSequence)", ", errors));
                }
            }
            catch (IOException | SAXException ex) {
                throw new FoundationException("The content was invalid: " + ex.getMessage());
            }
        }
        return content;
    }

    public static class NumericalVersion
    implements Comparable {
        private final int major;
        private final int minor;

        public NumericalVersion(String version) throws NumberFormatException {
            Objects.requireNonNull(version, "Version can't be null");
            int i = version.indexOf(46);
            if (i == -1) {
                this.major = Integer.parseInt(version);
                this.minor = 0;
            } else {
                this.major = Integer.parseInt(version.substring(0, i));
                this.minor = Integer.parseInt(version.substring(i + 1));
            }
            if (this.major < 0 || this.minor < 0) {
                throw new NumberFormatException();
            }
        }

        public int compareTo(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            NumericalVersion other = (NumericalVersion)o;
            if (this.major < other.major) {
                return -1;
            }
            if (this.major > other.major) {
                return 1;
            }
            if (this.minor < other.minor) {
                return -1;
            }
            if (this.minor > other.minor) {
                return 1;
            }
            return 0;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NumericalVersion)) {
                return false;
            }
            NumericalVersion other = (NumericalVersion)o;
            return this.major == other.major && this.minor == other.minor;
        }

        public int hashCode() {
            return Objects.hash(this.major, this.minor);
        }

        public String toString() {
            return this.major + "." + this.minor;
        }
    }
}

