/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.rule;

import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.rule.AdminRule;
import com.pageseeder.base.rule.Notify;
import com.pageseeder.base.rule.XLinkChange;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.annotation.Nullable;

public class XLinkChanges {
    protected ChangeStatus status = ChangeStatus.UNDEFINED;
    protected @Nullable String statusMessage = null;
    protected URI uri;
    protected Boolean async = false;
    protected Collection<XLinkChange> changes = new ArrayList<XLinkChange>();

    public XLinkChanges(URI uri, Boolean async) {
        this.uri = uri;
        this.async = async;
    }

    public ChangeStatus getStatus() {
        return this.status;
    }

    public @Nullable String getStatusMessage() {
        return this.statusMessage;
    }

    public void addXLinkChange(XLink xl, String changeType, Notify notify) {
        this.changes.add(new XLinkChange(xl, changeType, notify));
    }

    public void process(Database db) throws DatabaseException, EmailException {
        for (XLinkChange xlinkChange : this.changes) {
            boolean statusChanged = xlinkChange.getType().contains("status");
            boolean modified = xlinkChange.getType().contains("modified");
            Notify notify = xlinkChange.getNotify();
            if (notify == Notify.SILENT || !AdminRule.checkDate() || Emails.areDisabled()) continue;
            if ("moderated".equals(xlinkChange.getType())) {
                Emails.sendAcceptComment(db, XLinkRule.getMainGroup(xlinkChange.getXLink()), xlinkChange.getXLink(), this.async);
                this.statusMessage = "Comments submitted to moderator.";
                continue;
            }
            XLink xl = xlinkChange.getXLink();
            boolean delayed = Emails.sendNewComment(db, xl, null, null, notify, statusChanged, modified, this.async);
            if (!delayed) continue;
            this.statusMessage = "Due to the large number of recipients, delivery of notifications may take some time.";
        }
        this.status = ChangeStatus.SUCCESS;
    }

    public void rollback(Database db) {
        for (XLinkChange xLinkChange : this.changes) {
            XLink xl = xLinkChange.getXLink();
            if (xLinkChange.getType().startsWith("added") || xLinkChange.getType().startsWith("status-added")) {
                XLinkRule.archiveXLink(xl);
                continue;
            }
            if (!"archived".equals(xLinkChange.getType())) continue;
            XLinkRule.unarchiveXLink(xl);
        }
    }

    public static enum ChangeStatus {
        UNDEFINED,
        SUCCESS,
        ERROR;

    }
}

