/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.rule;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.db.model.Group;
import java.util.ArrayList;
import java.util.List;

public class URISharing
implements UniversallyPrintable {
    private final boolean isPublic;
    private final int hiddenGroups;
    private final List<GroupShare> shares = new ArrayList<GroupShare>();

    private URISharing(boolean isPublic, List<GroupShare> shares, int hiddenGroups) {
        this.shares.addAll(shares);
        this.isPublic = isPublic;
        this.hiddenGroups = hiddenGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(OutputPrinter out) {
        out.startObject("sharing");
        out.field("status", this.shares.size() > 1 || this.hiddenGroups > 0 || this.isPublic ? "shared" : "private");
        if (this.hiddenGroups > 0) {
            out.field("hidden", this.hiddenGroups);
        }
        if (this.isPublic) {
            out.field("public", true);
        }
        out.startCollection("share", OutputPrinter.CollectionOption.JSON_ONLY);
        UniversalPrinter printer = new UniversalPrinter(out);
        for (GroupShare share : this.shares) {
            out.startObject("share");
            if (share.owner) {
                out.field("owner", true);
            }
            out.field("editable", share.editable);
            out.field("addcomments", share.canComment);
            try {
                printer.writeGroup(share.group);
            }
            finally {
                out.endObject();
            }
        }
        out.endCollection();
        out.endObject();
    }

    public static class GroupShare {
        private final Group group;
        private final boolean owner;
        private final boolean editable;
        private final boolean canComment;

        private GroupShare(Group group, boolean owner, boolean editable, boolean canComment) {
            this.group = group;
            this.owner = owner;
            this.editable = editable;
            this.canComment = canComment;
        }
    }

    public static class Builder {
        private boolean isPublic = false;
        private int hiddenGroups = 0;
        private final List<GroupShare> shares = new ArrayList<GroupShare>();

        public Builder isPublic(boolean p) {
            this.isPublic = p;
            return this;
        }

        public Builder hiddenGroups(int nb) {
            this.hiddenGroups = nb;
            return this;
        }

        public void addGroup(Group group, boolean owner, boolean editable, boolean canComment) {
            this.shares.add(new GroupShare(group, owner, editable, canComment));
        }

        public URISharing build() {
            return new URISharing(this.isPublic, this.shares, this.hiddenGroups);
        }
    }
}

