/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.rule;

import com.pageseeder.common.properties.Settings;
import java.io.File;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Thumbnails {
    private static final Logger LOGGER = LoggerFactory.getLogger(Thumbnails.class);
    private static final int GROUP_BY = 1000;
    private static @Nullable File ROOT;

    private Thumbnails() {
    }

    public static boolean hasThumbnail(@Nullable String mediatype) {
        return mediatype != null && (mediatype.startsWith("image") || mediatype.equals("application/pdf"));
    }

    public static File notAnImage() {
        return new File(new File(Settings.getContextPath()), "weborganic/display/no-image.png");
    }

    public static void delete(@Nullable File thumbnail) {
        if (thumbnail != null && thumbnail.exists() && !thumbnail.getName().equals("no-image.png")) {
            thumbnail.delete();
        }
    }

    public static void deleteThumbnails(long uriid, String mediatype) {
        if (ROOT == null || !Thumbnails.hasThumbnail(mediatype)) {
            return;
        }
        String dirname = Long.toString(uriid / 1000L);
        File dir = new File(ROOT, dirname);
        if (!dir.exists()) {
            return;
        }
        String filename = Long.toString(uriid % 1000L);
        File[] thumbnails = dir.listFiles((file, s) -> s.startsWith(filename + "-") || s.startsWith(filename + "."));
        if (thumbnails != null) {
            for (File thumbnail : thumbnails) {
                thumbnail.delete();
            }
        }
    }

    public static @Nullable File toThumbnailFile(long uriid, String mediatype, int size, boolean padding) {
        if (ROOT == null) {
            return null;
        }
        String extension = Thumbnails.getExtension(mediatype, padding);
        String dirname = Long.toString(uriid / 1000L);
        Object filename = Long.toString(uriid % 1000L);
        if (size != 0) {
            filename = (String)filename + "-" + size;
        }
        if (padding) {
            filename = (String)filename + "-padding";
        }
        File dir = new File(ROOT, dirname);
        dir.mkdirs();
        return new File(dir, (String)filename + extension);
    }

    private static String getExtension(String mediatype, boolean padding) {
        if ("image/svg+xml".equals(mediatype)) {
            return ".svg";
        }
        if ("application/pdf".equals(mediatype)) {
            return ".jpg";
        }
        if (padding || "image/gif".equals(mediatype) || "image/png".equals(mediatype)) {
            return ".png";
        }
        return ".jpg";
    }

    static {
        File webapp = new File(Settings.getContextPath());
        File thumbs = new File(webapp, "WEB-INF/state/cache/thumbnail");
        if (thumbs.exists()) {
            ROOT = thumbs;
        } else if (thumbs.mkdirs()) {
            ROOT = thumbs;
        } else {
            LOGGER.warn("Thumbnail: caching disabled, {} does not exists or no write permission", (Object)thumbs);
        }
    }
}

