/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.rule;

import org.eclipse.jdt.annotation.Nullable;

public enum Notification {
    IMMEDIATE("Immediate", null),
    DAILY("Daily", Character.valueOf('i')),
    WEEKLY("Weekly", Character.valueOf('w')),
    ESSENTIAL("Essential", Character.valueOf('l')),
    NONE("None", Character.valueOf('n'));

    private final String type;
    private final @Nullable Character flag;

    private Notification(String type, Character flag) {
        this.type = type;
        this.flag = flag;
    }

    public String type() {
        return this.type;
    }

    public @Nullable Character flag() {
        return this.flag;
    }

    public static @Nullable Notification forType(@Nullable String type) {
        for (Notification n : Notification.values()) {
            if (!n.type().equalsIgnoreCase(type)) continue;
            return n;
        }
        return null;
    }

    public static Notification forFlags(@Nullable String flags) {
        if (flags == null) {
            return IMMEDIATE;
        }
        for (Notification n : Notification.values()) {
            if (n.flag() == null || flags.indexOf(n.flag().charValue()) == -1) continue;
            return n;
        }
        return IMMEDIATE;
    }

    public String toString() {
        return this.name().toLowerCase();
    }
}

