/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.rule;

import com.pageseeder.base.rule.MemberForGroupRule;
import com.pageseeder.base.rule.Notification;
import com.pageseeder.base.rule.SubGroupRole;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupForGroup;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.db.model.MemberForGroupStatus;
import com.pageseeder.db.model.MemberGroupDetails;
import com.pageseeder.db.model.Role;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public final class Membership {
    private final Group parentGroup;
    private final Map<GroupForGroup, MemberForGroup> subgroups = new HashMap<GroupForGroup, MemberForGroup>();
    private final Member member;
    private final @Nullable MemberForGroup memberForGroup;
    private @Nullable SubGroupRole role = null;
    private boolean inheritRole = true;
    private @Nullable Notification notification = null;
    private boolean inheritNotification = true;
    private boolean listed = false;
    private boolean inheritListed = true;

    public Membership(Group mainGroup, Member m) {
        this.member = m;
        this.parentGroup = mainGroup;
        this.memberForGroup = null;
    }

    public Membership(MemberForGroup mfg) {
        this.member = mfg.getMember();
        this.parentGroup = mfg.getGroup();
        this.memberForGroup = mfg;
    }

    public boolean isInheritRole() {
        return this.inheritRole;
    }

    public boolean isInheritNotification() {
        return this.inheritNotification;
    }

    public boolean isInheritListed() {
        return this.inheritListed;
    }

    public boolean isSubGroupMember() {
        return this.memberForGroup == null;
    }

    public @Nullable Long getMemberForGroupID() {
        return this.memberForGroup == null ? null : this.memberForGroup.getId();
    }

    public Collection<GroupForGroup> getSubgroups() {
        return this.subgroups.keySet();
    }

    public @Nullable String getSubgroupsAsString() {
        StringBuilder subgroupsAsString = new StringBuilder();
        for (GroupForGroup subgroup : this.subgroups.keySet()) {
            if (subgroupsAsString.length() > 0) {
                subgroupsAsString.append(',');
            }
            subgroupsAsString.append(subgroup.getMemberGroup().getName());
        }
        return subgroupsAsString.length() > 0 ? subgroupsAsString.toString() : null;
    }

    public Member getMember() {
        return this.member;
    }

    public Group getGroup() {
        return this.parentGroup;
    }

    public void addSubGroup(GroupForGroup subgroup, MemberForGroup mfg) {
        if (MemberForGroupStatus.NORMAL == MemberForGroupRule.getStatus(mfg)) {
            this.subgroups.put(subgroup, mfg);
        }
    }

    public @Nullable Role getRole() {
        if (this.memberForGroup != null) {
            return MemberForGroupRule.getRole(this.memberForGroup);
        }
        this.computeFields();
        return this.role == null ? null : this.role.role();
    }

    public boolean getListed() {
        if (this.memberForGroup != null) {
            return this.memberForGroup.getListed() == Boolean.TRUE;
        }
        this.computeFields();
        return this.listed;
    }

    public @Nullable Notification getNotification() {
        if (this.memberForGroup != null) {
            return Notification.forType(this.memberForGroup.getNotification());
        }
        this.computeFields();
        return this.notification;
    }

    public @Nullable Date getCreated() {
        if (this.memberForGroup != null) {
            return this.memberForGroup.getCreated();
        }
        return null;
    }

    public @Nullable MemberGroupDetails getMemberGroupDetails() {
        if (this.memberForGroup != null) {
            return this.memberForGroup.getMemberGroupDetails();
        }
        return null;
    }

    public boolean isDeleted() {
        if (this.memberForGroup != null) {
            return MemberForGroupRule.isDeletedMember(this.memberForGroup);
        }
        for (MemberForGroup submfg : this.subgroups.values()) {
            if (MemberForGroupRule.isDeletedMember(submfg)) continue;
            return false;
        }
        return true;
    }

    public MemberForGroupStatus getStatus() {
        if (this.memberForGroup != null) {
            return MemberForGroupRule.getStatus(this.memberForGroup);
        }
        return MemberForGroupStatus.NORMAL;
    }

    private void computeFields() {
        if (this.role == null || this.notification == null) {
            for (GroupForGroup subgroup : this.subgroups.keySet()) {
                Notification subgroupNotification;
                MemberForGroup mfg = this.subgroups.get(subgroup);
                SubGroupRole subgroupRole = null;
                if (subgroup.getRoleFlags() != null) {
                    subgroupRole = SubGroupRole.forGroupForGroupFlags(subgroup.getRoleFlags());
                    this.inheritRole = false;
                } else {
                    Role role = MemberForGroupRule.getRole(mfg);
                    if (role != null) {
                        subgroupRole = SubGroupRole.forAttribute(role.attribute());
                    }
                }
                if (subgroupRole != null && subgroupRole.isHigher(this.role)) {
                    this.role = subgroupRole;
                }
                if (subgroup.getNotification() != null) {
                    this.inheritNotification = false;
                }
                if (this.notificationIsHigher(subgroupNotification = Notification.forType(subgroup.getNotification() == null ? mfg.getNotification() : subgroup.getNotification()), this.notification)) {
                    this.notification = subgroupNotification;
                }
                if (subgroup.getListed() != null) {
                    this.inheritListed = false;
                }
                if ((subgroup.getListed() == null || !subgroup.getListed().booleanValue()) && (subgroup.getListed() != null || mfg.getListed() == null || !mfg.getListed().booleanValue())) continue;
                this.listed = true;
            }
        }
    }

    private boolean notificationIsHigher(@Nullable Notification n1, @Nullable Notification n2) {
        if (n1 == null) {
            return false;
        }
        if (n2 == null) {
            return true;
        }
        if (n1 == Notification.IMMEDIATE) {
            return true;
        }
        if (n1 == Notification.ESSENTIAL && (n2 == Notification.DAILY || n2 == Notification.WEEKLY || n2 == Notification.NONE)) {
            return true;
        }
        if (n1 == Notification.DAILY && (n2 == Notification.WEEKLY || n2 == Notification.NONE)) {
            return true;
        }
        return n1 == Notification.WEEKLY && n2 == Notification.NONE;
    }
}

