/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.rule;

import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.HostRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.common.util.Rules;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.GroupURIForGroup;
import com.pageseeder.db.model.Host;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.annotation.Nullable;

public final class GroupURIForGroupRule {
    private GroupURIForGroupRule() {
    }

    public static @Nullable Group getDefaultGroupForGroupURIs(Collection<GroupURIForGroup> gurifgs) {
        Group found = null;
        for (GroupURIForGroup gurifg : gurifgs) {
            Group grp = gurifg.getGroup();
            GroupURI guri = gurifg.getGroupURI();
            if (!GroupURIRule.isDefaultGroupURI(guri, grp) || found != null && found.getName().length() >= grp.getName().length()) continue;
            found = grp;
        }
        return found;
    }

    public static Collection<GroupURIForGroup> getGroupURIForGroupsForURL(Database db, URL url, boolean folder) throws DatabaseException {
        ArrayList<GroupURIForGroup> gurifgs = new ArrayList<GroupURIForGroup>();
        int urlPort = url.getPort() == -1 ? Rules.getDefaultPort((String)url.getProtocol()) : url.getPort();
        String hostname = url.getHost();
        Host host = DatabaseQuery.getHostByName((Database)db, (String)(hostname = HostRule.resolveAlias(db, hostname)));
        if (host != null) {
            Collection<GroupURI> guris = URIRule.matchGroupURIs(db, url.getProtocol(), hostname, urlPort, url.getFile());
            for (GroupURI guri : guris) {
                if (folder && guri.getPath() != null && !guri.getPath().endsWith("/*")) continue;
                gurifgs.addAll(guri.getGroupURIForGroupsCol());
            }
        }
        return gurifgs;
    }
}

