/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.publication;

import com.pageseeder.base.document.URIException;
import com.pageseeder.base.publication.NumberedTOC;
import com.pageseeder.base.publication.PublicationManager;
import com.pageseeder.base.publication.UpdateQueue;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.LocatorRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.model.XLinkForAttachedXLink;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.toc.DocumentTree;
import org.pageseeder.psml.toc.FragmentNumbering;
import org.pageseeder.psml.toc.PublicationConfig;
import org.pageseeder.psml.toc.PublicationTree;
import org.pageseeder.psml.toc.XRefLoopException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Publications {
    private static final Logger LOGGER = LoggerFactory.getLogger(Publications.class);
    private static final Comparator<Publication> PUBLICATION_TITLE_COMPARATOR = Comparator.comparing(Publication::getTitle).thenComparing(Publication::getId);
    private static final String VALID_PUBLICATION_ID = "[a-zA-Z0-9_-]+";
    private static final String VALID_PUBLICATION_TYPE = "[a-zA-Z0-9_]+";

    private Publications() {
    }

    public static void sortByTitle(List<Publication> list) {
        list.sort(PUBLICATION_TITLE_COMPARATOR);
    }

    public static boolean isValidPublicationID(@Nullable String id) {
        return id != null && id.matches(VALID_PUBLICATION_ID) && id.length() <= 250;
    }

    public static boolean isValidPublicationType(@Nullable String type) {
        return type != null && type.matches(VALID_PUBLICATION_TYPE) && type.length() <= 50;
    }

    public static void print(Publication pub, UniversalPrinter out) {
        Publications.print(pub, out, true);
    }

    public static void print(Publication pub, UniversalPrinter out, boolean closed) {
        out.startObject("publication");
        if (pub.getId() != null) {
            out.field("id", pub.getId());
        }
        out.field("hostid", pub.getHostId());
        out.field("rooturiid", pub.getRootURIId());
        if (pub.getTitle() != null) {
            out.field("title", pub.getTitle());
        }
        out.field("defaultgroupid", pub.getDefaultGroupId());
        if (pub.getType() != null) {
            out.field("type", pub.getType());
        }
        if (closed) {
            out.endObject();
        }
    }

    public static Publication blank(URI uri, @Nullable Group group) {
        return new Publication("", -1L, uri.getId().longValue(), uri.getLastModified(), uri.getDisplayTitle(), -1L, group != null ? group.getId() : -1L, "default");
    }

    public static Publication create(Database db, Member author, String id, URI uri, Group group, String type) throws DatabaseException {
        XLink xlink;
        Publication existing;
        XLink root = uri.getXLink();
        if (root == null) {
            URIRule.addURIHistoryXLink(uri, author, db);
            root = uri.getXLink();
        }
        if ((existing = DatabaseQuery.getPublicationByPublicationIDHost((Database)db, (String)id, (Host)uri.getHost())) != null) {
            URI other = DatabaseQuery.getURIById((Database)db, (Long)existing.getRootURIId());
            xlink = DatabaseQuery.getXLinkById((Database)db, (Long)existing.getXLinkId());
            other.getXLink().removeReplies(xlink);
            root.addReplies(xlink);
            xlink.setModifiedDate(new Date());
            xlink.setModifiedBy(author);
            XLinkRule.modifyGroups(db, xlink, GroupRule.getEditGroups(db, group, uri));
            Collection locators = DatabaseQuery.getLocatorsForPublication((Database)db, (XLink)xlink);
            for (Locator locator : locators) {
                locator.removePublications(xlink);
            }
        } else {
            xlink = new XLink();
            xlink.setContentRole("publication");
            xlink.setContentTitle(id);
            xlink.setType(type);
            xlink.setAccepted(Boolean.valueOf(true));
            xlink.setMember(author);
            xlink.setDate(new Date());
            XLinkRule.addGroups(db, xlink, GroupRule.getEditGroups(db, group, uri));
            root.addReplies(xlink);
            xlink = xlink.insert(db);
        }
        Group defaultGroup = URIRule.getDefaultGroupForURI(db, uri.getId());
        Group pubGroup = defaultGroup != null && XLinkRule.belongsToGroup(xlink, defaultGroup) ? defaultGroup : group;
        Publication pub = new Publication(xlink, uri, pubGroup);
        PublicationManager manager = PublicationManager.singleton();
        manager.clearCachedTOC(pub);
        Locator loc = LocatorRule.getLocatorByURIFragment(db, uri, "default");
        loc.addPublications(xlink);
        return pub;
    }

    public static Publication edit(Database db, Publication pub, String id, String type) throws DatabaseException, URIException {
        if (id != null && !id.equals(pub.getId())) {
            Host host = DatabaseQuery.getHostById((Database)db, (long)pub.getHostId());
            if (host == null) {
                throw new DatabaseException("Publication ID " + id + " has invalid host ID " + pub.getHostId() + ".");
            }
            Publication existing = DatabaseQuery.getPublicationByPublicationIDHost((Database)db, (String)id, (Host)host);
            if (existing != null) {
                throw new URIException("Publication ID " + id + " is already in use on URI ID " + existing.getRootURIId() + ".");
            }
        }
        try {
            PublicationManager.singleton().getNumberedTOC(db, pub, true);
        }
        catch (XRefLoopException host) {
            // empty catch block
        }
        PublicationManager.singleton().clearCachedTOC(pub);
        XLink xlink = DatabaseQuery.getXLinkById((Database)db, (Long)pub.getXLinkId());
        if (xlink == null) {
            throw new DatabaseException("Invalid publication " + pub.getId() + " has no XLink");
        }
        xlink.setType(type);
        xlink.setContentTitle(id);
        return new Publication(id, pub.getHostId(), pub.getRootURIId(), pub.getRootModified(), pub.getTitle(), xlink.getId().longValue(), pub.getDefaultGroupId(), type);
    }

    public static Set<URI> delete(Database db, Publication pub) throws DatabaseException {
        XLink xlink = DatabaseQuery.getXLinkById((Database)db, (Long)pub.getXLinkId());
        if (xlink == null) {
            throw new DatabaseException("Invalid publication " + pub.getId() + " has no XLink");
        }
        for (XLink version : DatabaseQuery.getXLinksByAttachedTo((Database)db, (Long)xlink.getId())) {
            XLinkRule.archiveXLink(version);
        }
        XLinkRule.archiveXLink(xlink);
        PublicationManager.singleton().clearCachedTOC(pub);
        HashSet<URI> uris = new HashSet<URI>();
        Collection locators = DatabaseQuery.getLocatorsForPublication((Database)db, (XLink)xlink);
        for (Locator locator : locators) {
            locator.removePublications(xlink);
            uris.add(locator.getURI());
        }
        return uris;
    }

    public static void deletePermanently(Database db, Publication pub) throws DatabaseException {
        XLink xlink = DatabaseQuery.getXLinkById((Database)db, (Long)pub.getXLinkId());
        if (xlink == null) {
            throw new DatabaseException("Invalid publication " + pub.getId() + " has no XLink");
        }
        Collection attachedto = DatabaseQuery.getXLinksForAttachedByAttachedTo((Database)db, (Long)xlink.getId());
        for (XLinkForAttachedXLink xfax : attachedto) {
            XLink xl = xfax.getXLink();
            xl.delete(db);
            xfax.delete(db);
            xfax = null;
        }
        Collection locators = DatabaseQuery.getLocatorsForPublication((Database)db, (XLink)xlink);
        for (Locator locator : locators) {
            locator.removePublications(xlink);
        }
        xlink.delete(db);
        xlink = null;
        PublicationManager.singleton().clearCachedTOC(pub);
    }

    public static List<Publication> getAncestorPublications(Database db, URI uri, UserDetails userdetails) throws QueryFailedException {
        List found = DatabaseQuery.getPublicationsByURIGroups((Database)db, (Long)uri.getId(), new ArrayList<String>(userdetails.flags().keySet()));
        found.sort(PUBLICATION_TITLE_COMPARATOR);
        return found;
    }

    public static @Nullable Publication getDefaultPublication(Database db, URI uri, UserDetails userdetails, Group cgroup, String version, String publicationid) throws DatabaseException {
        Publication publication = Publications.findValidURIPublication(db, publicationid, true, uri);
        if (publication == null) {
            publication = Publications.findValidURIVersionPublication(db, publicationid, version, uri, cgroup);
        }
        if (publication == null) {
            List<Publication> all = Publications.getAncestorPublications(db, uri, userdetails);
            Publication publication2 = publication = all.isEmpty() ? null : all.iterator().next();
            if (publicationid != null) {
                for (Publication pub : all) {
                    if (!publicationid.equals(pub.getId())) continue;
                    publication = pub;
                    break;
                }
            }
        }
        return publication;
    }

    public static @Nullable NumberedTOC getDefaultNumberedToc(Database db, long uriid, UserDetails userdetails) throws DatabaseException, XRefLoopException {
        URI turi = DatabaseQuery.getURIById((Database)db, (Long)uriid);
        if (turi != null) {
            NumberedTOC toc = Publications.getDefaultNumberedToc(db, turi, userdetails);
            if (toc != null) {
                return toc;
            }
            Group defaultGroup = URIRule.getDefaultGroupForURI(turi);
            if (defaultGroup == null) {
                return null;
            }
            PublicationManager manager = PublicationManager.singleton();
            Publication pub = Publications.blank(turi, defaultGroup);
            PublicationConfig pubconf = manager.getPublicationConfig(defaultGroup, pub.getType());
            DocumentTree doctree = PublicationManager.singleton().parseDocument(db, turi.getId(), defaultGroup, true);
            PublicationTree pubtree = new PublicationTree(doctree.normalize(pubconf.getTocTitleCollapse()));
            FragmentNumbering numbering = new FragmentNumbering(pubtree, pubconf);
            return new NumberedTOC(pubtree, numbering, pub.getDefaultGroupId(), pub.getType(), false, pub.getRootModified(), false);
        }
        return null;
    }

    public static @Nullable NumberedTOC getDefaultNumberedToc(Database db, URI uri, UserDetails userdetails) throws DatabaseException, XRefLoopException {
        List embedded = DatabaseQuery.getPublicationsByURIEmbeded((Database)db, (Long)uri.getId());
        Publication root = DatabaseQuery.getPublicationByRootURI((Database)db, (URI)uri, (boolean)false);
        if (root != null) {
            embedded.add(root);
        }
        embedded.sort(PUBLICATION_TITLE_COMPARATOR);
        if (!embedded.isEmpty()) {
            List<Publication> all = Publications.getAncestorPublications(db, uri, userdetails);
            for (Publication pub : embedded) {
                if (!all.contains(pub)) continue;
                return PublicationManager.singleton().getNumberedTOC(db, pub, true);
            }
        }
        return null;
    }

    public static int getDefaultPosition(Database db, URI uri, @Nullable Publication publication, @Nullable String version, int position, @Nullable String positionStr) throws DatabaseException {
        if (positionStr != null && positionStr.matches("^\\d+$")) {
            position = Integer.parseInt(positionStr);
        } else if (publication != null) {
            try {
                FragmentNumbering numbering = version != null && !version.isEmpty() && !"current".equals(version) ? PublicationManager.singleton().getNumberedTOC(db, publication, version, uri).getFragmentNumbering() : PublicationManager.singleton().getNumberedTOC(db, publication, true).getFragmentNumbering();
                for (int i = 1; i <= 100; ++i) {
                    if (numbering.getPrefix(uri.getId().longValue(), i) == null) continue;
                    position = i;
                    break;
                }
            }
            catch (XRefLoopException ex) {
                LOGGER.error("Unable to calculate publication position: {}", (Object)ex.getMessage());
            }
        }
        return position;
    }

    public static @Nullable Publication getPublicationByPublicationIDGroup(Database db, String pubid, Group group) throws DatabaseException {
        GroupURI guri = GroupURIRule.getDefaultGroupURI(group);
        if (guri == null) {
            return null;
        }
        return DatabaseQuery.getPublicationByPublicationIDHost((Database)db, (String)pubid, (Host)guri.getHost());
    }

    public static @Nullable Publication findValidURIPublication(Database db, @Nullable String publicationid, boolean reload, URI uri) {
        if (publicationid == null) {
            return null;
        }
        try {
            DocumentTree dtree;
            Publication publication = DatabaseQuery.getPublicationByPublicationIDHost((Database)db, (String)publicationid, (Host)uri.getHost());
            if (publication != null && (dtree = PublicationManager.singleton().getNumberedTOC(db, publication, reload).getPublicationTree().tree(uri.getId().longValue())) != null) {
                return publication;
            }
        }
        catch (DatabaseException | XRefLoopException ex) {
            LoggerFactory.getLogger(Publications.class).error("Failed to load publication " + publicationid, ex);
        }
        return null;
    }

    public static @Nullable Publication findValidURIVersionPublication(Database db, @Nullable String publicationid, String version, URI uri, Group group) throws DatabaseException {
        if (Strings.isEmpty((String)publicationid)) {
            return null;
        }
        Publication pub = Publications.getPublicationByPublicationIDGroup(db, publicationid, group);
        Long releaseId = XLinkRule.getValidRelease(db, uri, null, version, pub);
        if (releaseId != null && releaseId != 0L) {
            return pub;
        }
        return null;
    }

    public static void updateURI(URI uri) {
        if (URIRule.isPSML(uri)) {
            UpdateQueue.singleton().addUpdate(uri.getId(), false);
        }
    }

    public static void updateURI(Long uriid) {
        UpdateQueue.singleton().addUpdate(uriid, false);
    }
}

