/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.publication;

import com.pageseeder.base.cache.SafeCacheWrapper;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.PSMLFiles;
import com.pageseeder.base.publication.NumberedTOC;
import com.pageseeder.base.publication.UpdateQueue;
import com.pageseeder.base.rule.LocatorRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.toc.DocumentTree;
import org.pageseeder.psml.toc.DocumentTreeHandler;
import org.pageseeder.psml.toc.FragmentNumbering;
import org.pageseeder.psml.toc.PublicationConfig;
import org.pageseeder.psml.toc.PublicationTree;
import org.pageseeder.psml.toc.Reference;
import org.pageseeder.psml.toc.XRefLoopException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PublicationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublicationManager.class);
    private static final PublicationManager SINGLETON = new PublicationManager();
    private static final int MAX_PARA_TITLE_TREES = 2000;
    private final SafeCacheWrapper<String, NumberedTOC> publicationTOCCache = SafeCacheWrapper.getInstance("publication-tocs");
    private final SafeCacheWrapper<String, NumberedTOC> publicationTOCVersionCache = SafeCacheWrapper.getInstance("publication-tocs-version");
    private final Map<String, PublicationConfig> publicationConfigs = new ConcurrentHashMap<String, PublicationConfig>();

    private PublicationManager() {
    }

    public static PublicationManager singleton() {
        return SINGLETON;
    }

    public final void clearCachedTOC(Publication pub) {
        String key = this.getCacheKey(pub);
        LOGGER.debug("Clear publication TOC with key={}", (Object)key);
        this.publicationTOCCache.remove(key);
    }

    public final void clearCachedTOCVersion(Publication pub, String version) {
        String key = this.getVersionCacheKey(pub, version);
        LOGGER.debug("Clear publication TOC version with key={}", (Object)key);
        this.publicationTOCVersionCache.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final NumberedTOC getNumberedTOC(Database db, Publication pub, boolean update) throws XRefLoopException, DatabaseException {
        NumberedTOC toc;
        String key = this.getCacheKey(pub);
        this.publicationTOCCache.acquireWriteLockOnKey(key);
        Map<Long, Integer> removedLocators = new HashMap<Long, Integer>();
        try {
            toc = this.getCachedTOC(key);
            if (toc == null) {
                toc = new NumberedTOC(new PublicationTree(), null, pub.getDefaultGroupId(), pub.getType(), true, new Date(), true);
            }
            if (toc.updateRequired() && update || toc.getFragmentNumbering() == null) {
                Group pubgroup = DatabaseQuery.getGroupById((Database)db, (Long)pub.getDefaultGroupId());
                if (pubgroup == null) {
                    throw new QueryFailedException("Group not found for ID: " + pub.getDefaultGroupId());
                }
                PublicationConfig pubconfig = this.getPublicationConfig(pubgroup, pub.getType());
                PublicationTree pubtree = toc.getPublicationTree();
                if (toc.getFragmentNumbering() == null) {
                    LOGGER.debug("TOC cache new key: {}", (Object)key);
                    pubtree = this.createPublicationTree(db, pub, pubgroup, pubconfig, null);
                }
                ArrayList<Long> unusedIds = new ArrayList<Long>();
                HashMap transclusions = new HashMap();
                FragmentNumbering numbering = new FragmentNumbering(pubtree, pubconfig, unusedIds, transclusions);
                if (!unusedIds.isEmpty()) {
                    LOGGER.debug("TOC remove trees {} key: {}", unusedIds, (Object)key);
                    XLink pubXlink = DatabaseQuery.getXLinkById((Database)db, (Long)pub.getXLinkId());
                    removedLocators = this.removeUnusedURIsForPublication(db, unusedIds, pubtree, pubXlink);
                }
                pubtree = pubtree.modify(unusedIds, new HashMap(), transclusions, pub.getRootURIId());
                toc = new NumberedTOC(pubtree, numbering, pub.getDefaultGroupId(), pub.getType(), false, new Date(), toc.newlyCreated());
                this.putCachedTOC(key, toc);
            }
        }
        finally {
            this.publicationTOCCache.releaseWriteLockOnKey(key);
        }
        if (!removedLocators.isEmpty()) {
            new Transaction(db).commitAndStart();
            this.registerPublicationChanges(db, pub, null, removedLocators, null);
        }
        return toc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final NumberedTOC getNumberedTOC(Database db, Publication pub, String version, URI uri) throws XRefLoopException, DatabaseException {
        NumberedTOC toc;
        XLink xl;
        Long releaseId = XLinkRule.getValidRelease(db, uri, null, version, pub);
        version = releaseId == null ? "current" : (releaseId == 0L ? "original" : ((xl = DatabaseQuery.getXLinkById((Database)db, (Long)releaseId)) != null ? xl.getContentTitle() : "original"));
        String key = this.getVersionCacheKey(pub, version);
        this.publicationTOCVersionCache.acquireWriteLockOnKey(key);
        try {
            PublicationTree pubtree;
            toc = this.getCachedTOCVersion(key);
            PublicationTree publicationTree = pubtree = toc == null ? null : toc.getPublicationTree();
            if (toc == null || pubtree == null || pubtree.id() != pub.getRootURIId()) {
                Group pubGroup = DatabaseQuery.getGroupById((Database)db, (Long)pub.getDefaultGroupId());
                if (pubGroup == null) {
                    throw new QueryFailedException("Group not found for ID: " + pub.getDefaultGroupId());
                }
                PublicationConfig pubConfig = this.getPublicationConfig(pubGroup, pub.getType());
                DocumentTree tree = this.parseDocument(db, pub.getRootURIId(), pubGroup, true, version, pub);
                PublicationTree pubTree = new PublicationTree(tree);
                HashMap<Long, DocumentTree> newTrees = new HashMap<Long, DocumentTree>();
                this.addDescendantTrees(db, tree, "default", pubGroup, pubConfig, newTrees, version, pub);
                pubTree = pubTree.modify(new ArrayList(), newTrees, new HashMap(), pub.getRootURIId());
                FragmentNumbering numbering = new FragmentNumbering(pubTree, pubConfig);
                toc = new NumberedTOC(pubTree, numbering, pub.getDefaultGroupId(), pub.getType(), false, new Date(), false);
                this.putCachedTOCVersion(key, toc);
            }
        }
        finally {
            this.publicationTOCVersionCache.releaseWriteLockOnKey(key);
        }
        return toc;
    }

    public PublicationTree createPublicationTree(Database db, Publication pub, Group pubGroup, PublicationConfig pubConfig, @Nullable Map<Long, Integer> locators) throws DatabaseException {
        HashMap<Long, DocumentTree> newTrees = new HashMap<Long, DocumentTree>();
        XLink pubXlink = DatabaseQuery.getXLinkById((Database)db, (Long)pub.getXLinkId());
        DocumentTree tree = this.parseDocument(db, pub.getRootURIId(), pubGroup, true);
        PublicationTree pubTree = new PublicationTree(tree);
        HashMap<Long, List<Long>> transclusions = new HashMap<Long, List<Long>>();
        PublicationManager.addTransclusionParents(tree.id(), -1L, transclusions);
        if (locators != null) {
            URI uri = DatabaseQuery.getURIById((Database)db, (Long)pub.getRootURIId());
            Locator loc = LocatorRule.getLocatorByURIFragment(db, uri, "default");
            loc.addPublications(pubXlink);
            locators.put(loc.getId(), 1);
        }
        this.addDescendantTrees(db, tree, "default", pubGroup, pubConfig, pubTree, false, newTrees, new ArrayList<Long>(), pubXlink, transclusions, locators);
        return pubTree.modify(new ArrayList(), newTrees, transclusions, pub.getRootURIId());
    }

    private Map<Long, Integer> removeUnusedURIsForPublication(Database db, List<Long> unusedIds, PublicationTree pubTree, XLink pubXlink) throws DatabaseException {
        HashMap<Long, Integer> locators = new HashMap<Long, Integer>();
        ArrayList<String> types = new ArrayList<String>();
        types.add("transclude");
        for (Long uriid : unusedIds) {
            DocumentTree tree;
            URI uri = DatabaseQuery.getURIById((Database)db, (Long)uriid);
            if (uri == null) continue;
            if (!this.isLocatorUsed(db, unusedIds, pubTree, types, uri.getId(), "default")) {
                Locator locator = LocatorRule.getLocatorByURIFragment(db, uri, "default");
                LOGGER.debug("Publication {} remove URIID-fragment: {}-default", (Object)pubXlink.getContentTitle(), (Object)uriid);
                locator.removePublications(pubXlink);
                locators.put(locator.getId(), -1);
            }
            if ((tree = pubTree.tree(uriid.longValue())) == null) continue;
            for (Reference ref : tree.listReferences()) {
                if (Reference.Type.TRANSCLUDE != ref.type() || this.isLocatorUsed(db, unusedIds, pubTree, types, ref.uri(), ref.targetfragment())) continue;
                URI turi = DatabaseQuery.getURIById((Database)db, (Long)ref.uri());
                Locator tlocator = LocatorRule.getLocatorByURIFragment(db, turi, ref.targetfragment());
                LOGGER.debug("Publication {} remove URIID-fragment: {}-{}", new Object[]{pubXlink.getContentTitle(), ref.uri(), ref.targetfragment()});
                tlocator.removePublications(pubXlink);
                locators.put(tlocator.getId(), -1);
            }
        }
        return locators;
    }

    private boolean isLocatorUsed(Database db, List<Long> unusedIds, PublicationTree pubTree, List<String> types, long uriid, String fragment) throws QueryFailedException {
        boolean used = false;
        for (DatabaseQuery.URIFragmentPair reverseXRef : DatabaseQuery.getXLinksByReverseXRefsURITypeAllGroups((Database)db, (Long)uriid, (String)fragment, (boolean)false, types)) {
            if (unusedIds.contains(reverseXRef.getUri()) || !pubTree.containsTree(reverseXRef.getUri().longValue())) continue;
            used = true;
        }
        return used;
    }

    private static void addTransclusionParents(long id, long parentId, Map<Long, List<Long>> transclusions) {
        LOGGER.debug("TOC add transclusion from parent ID: {} to URI ID: {}", (Object)parentId, (Object)id);
        List parents = transclusions.computeIfAbsent(id, i -> new ArrayList());
        if (!parents.contains(parentId)) {
            parents.add(parentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTreeUpdates(UpdateQueue.Update update) {
        Database db;
        LOGGER.debug("TOC UPDATE for URI ID {}", (Object)update.uriid);
        try {
            db = Database.open();
        }
        catch (OpenDatabaseException ex) {
            LOGGER.error("Unable to open database: {}", (Object)ex.getMessage());
            return;
        }
        Transaction tr = null;
        try {
            tr = new Transaction(db);
            tr.begin();
            List publications = DatabaseQuery.getPublicationsByURI((Database)db, (Long)update.uriid);
            for (Publication pub : publications) {
                String key = this.getCacheKey(pub);
                this.publicationTOCCache.acquireWriteLockOnKey(key);
                HashMap<Long, Integer> existingUris = new HashMap<Long, Integer>();
                HashMap<Long, Integer> addedLocators = new HashMap<Long, Integer>();
                HashMap<Long, Integer> existingLocators = new HashMap();
                try {
                    PublicationTree pubtree;
                    Map transclusions;
                    List<Long> transcluded;
                    Group pubGroup = DatabaseQuery.getGroupById((Database)db, (Long)pub.getDefaultGroupId());
                    PublicationConfig pubConfig = this.getPublicationConfig(pubGroup, pub.getType());
                    NumberedTOC toc = this.getCachedTOC(key);
                    if (toc == null) {
                        toc = new NumberedTOC(this.createPublicationTree(db, pub, pubGroup, pubConfig, null), new FragmentNumbering(), pub.getDefaultGroupId(), pub.getType(), true, new Date(), true);
                    }
                    if ((transcluded = (List<Long>)(transclusions = (pubtree = toc.getPublicationTree()).transclusions()).get(update.uriid)) == null && pubtree.tree(update.uriid) == null) {
                        transcluded = Collections.singletonList(0L);
                    }
                    ArrayList<Long> unusedIds = new ArrayList<Long>();
                    HashMap<Long, DocumentTree> newTrees = new HashMap<Long, DocumentTree>();
                    if (update.delete && pubtree.id() != update.uriid) {
                        LOGGER.debug("TOC remove URI ID {} key: {}", (Object)update.uriid, (Object)key);
                        unusedIds.add(update.uriid);
                    }
                    if (!update.delete || transcluded != null) {
                        int tocsize = pubtree.ids().size();
                        XLink pubXlink = DatabaseQuery.getXLinkById((Database)db, (Long)pub.getXLinkId());
                        if (!update.delete && (transcluded == null || transcluded.contains(-1L))) {
                            LOGGER.debug("TOC add trees key: {}", (Object)key);
                            DocumentTree tree = this.parseDocument(db, update.uriid, pubGroup, tocsize + newTrees.size() <= 2000);
                            this.addDescendantTrees(db, tree, "default", pubGroup, pubConfig, pubtree, toc.newlyCreated(), newTrees, new ArrayList<Long>(), pubXlink, transclusions, addedLocators);
                            existingUris.put(update.uriid, 1);
                        }
                        if (transcluded != null) {
                            existingLocators = this.getExistingLocatorsForPublication(db, update.uriid, pubXlink);
                            for (Long uriid : transcluded) {
                                if (uriid == -1L) {
                                    URI uri = DatabaseQuery.getURIById((Database)db, (Long)update.uriid);
                                    Locator loc = LocatorRule.getLocatorByURIFragment(db, uri, "default");
                                    existingLocators.put(loc.getId(), 0);
                                    continue;
                                }
                                if (uriid == 0L) continue;
                                DocumentTree tree = this.parseDocument(db, uriid, pubGroup, tocsize + newTrees.size() <= 2000);
                                this.addDescendantTrees(db, tree, "default", pubGroup, pubConfig, pubtree, toc.newlyCreated(), newTrees, new ArrayList<Long>(), pubXlink, transclusions, existingLocators);
                                existingUris.put(uriid, 1);
                            }
                            this.removeUnusedLocatorsForPublication(db, existingLocators, pubXlink);
                        }
                        Iterator entryIt = transclusions.entrySet().iterator();
                        while (entryIt.hasNext()) {
                            Map.Entry entry = entryIt.next();
                            List value = (List)entry.getValue();
                            if (value.size() != 1 || (Long)value.get(0) != -1L) continue;
                            LOGGER.debug("TOC remove transclusion from URI ID: {}", entry.getKey());
                            entryIt.remove();
                        }
                    }
                    pubtree = pubtree.modify(unusedIds, newTrees, transclusions, pubtree.id());
                    toc = new NumberedTOC(pubtree, toc.getFragmentNumbering(), toc.getDefaultGroupId(), toc.getPublicationType(), true, new Date(), false);
                    this.putCachedTOC(key, toc);
                    tr.commitAndStart();
                }
                finally {
                    this.publicationTOCCache.releaseWriteLockOnKey(key);
                }
                this.registerPublicationChanges(db, pub, existingUris, existingLocators, addedLocators);
            }
            tr.commit();
        }
        catch (Exception ex) {
            LOGGER.error("Error updating trees for URI ID " + update.uriid + " :" + ex.getMessage(), (Throwable)ex);
            if (tr != null) {
                tr.abort();
            }
        }
        finally {
            db.close();
            db = null;
        }
    }

    private Map<Long, Integer> getExistingLocatorsForPublication(Database db, long uriid, XLink pubXlink) throws QueryFailedException {
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        Collection locators = DatabaseQuery.getLocatorsForPublicationByURI((Database)db, (long)uriid, (XLink)pubXlink);
        for (Locator locator : locators) {
            map.put(locator.getId(), -1);
        }
        return map;
    }

    private void removeUnusedLocatorsForPublication(Database db, Map<Long, Integer> locators, XLink pubXlink) throws DatabaseException {
        for (Map.Entry<Long, Integer> entry : locators.entrySet()) {
            if (entry.getValue() != -1) continue;
            Locator loc = DatabaseQuery.getLocatorById((Database)db, (Long)entry.getKey());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Publication {} remove URIID-fragment: {}-{}", new Object[]{pubXlink.getContentTitle(), loc.getURI().getId(), loc.getFragment()});
            }
            loc.removePublications(pubXlink);
        }
    }

    private void addDescendantTrees(Database db, DocumentTree tree, String fragment, Group pubGroup, PublicationConfig config, Map<Long, DocumentTree> trees, String version, Publication pub) throws DatabaseException {
        if (tree != null) {
            long uriid = tree.id();
            LOGGER.debug("Version TOC add new tree URI ID: {}", (Object)uriid);
            trees.put(uriid, tree.normalize(config.getTocTitleCollapse()));
            for (Reference ref : tree.listReferences()) {
                if (!"default".equals(fragment) && !ref.fragment().equals(fragment) || trees.containsKey(ref.uri()) || Reference.Type.TRANSCLUDE == ref.type()) continue;
                DocumentTree tree2 = this.parseDocument(db, ref.uri(), pubGroup, trees.size() <= 2000, version, pub);
                this.addDescendantTrees(db, tree2, ref.targetfragment(), pubGroup, config, trees, version, pub);
            }
        }
    }

    private void addDescendantTrees(Database db, DocumentTree tree, String fragment, Group pubGroup, PublicationConfig config, PublicationTree pubTree, boolean force, Map<Long, DocumentTree> trees, List<Long> addedTrees, XLink pubXlink, Map<Long, List<Long>> transclusions, @Nullable Map<Long, Integer> locators) throws DatabaseException {
        if (tree != null) {
            long uriid = tree.id();
            addedTrees.add(uriid);
            LOGGER.debug("TOC add new tree URI ID: {}", (Object)uriid);
            trees.put(uriid, tree.normalize(config.getTocTitleCollapse()));
            for (Reference ref : tree.listReferences()) {
                boolean transclusion;
                if (!"default".equals(fragment) && !ref.fragment().equals(fragment)) continue;
                boolean bl = transclusion = Reference.Type.TRANSCLUDE == ref.type();
                if (addedTrees.contains(ref.uri()) && !transclusion) continue;
                if (transclusion || "default".equals(ref.targetfragment())) {
                    if (locators != null) {
                        URI uri = DatabaseQuery.getURIById((Database)db, (Long)ref.uri());
                        assert (uri != null);
                        Locator loc = LocatorRule.getLocatorByURIFragment(db, uri, ref.targetfragment());
                        Integer existing = locators.get(loc.getId());
                        if (existing == null) {
                            if (loc.addPublications(pubXlink)) {
                                LOGGER.debug("Publication {} add URIID-fragment: {}-{}", new Object[]{pubXlink.getContentTitle(), uri.getId(), loc.getFragment()});
                                locators.put(loc.getId(), 1);
                            }
                        } else if (existing == -1) {
                            locators.put(loc.getId(), 0);
                        }
                    }
                    PublicationManager.addTransclusionParents(ref.uri(), transclusion ? uriid : -1L, transclusions);
                }
                if (pubTree.containsTree(ref.uri()) && !force || transclusion) continue;
                Transaction tr = new Transaction(db);
                if (tr != null && addedTrees.size() % 10 == 0) {
                    tr.commitAndStart();
                }
                DocumentTree tree2 = this.parseDocument(db, ref.uri(), pubGroup, pubTree.ids().size() + trees.size() <= 2000);
                this.addDescendantTrees(db, tree2, ref.targetfragment(), pubGroup, config, pubTree, force, trees, addedTrees, pubXlink, transclusions, locators);
            }
        }
    }

    public void lockPublicationCache(Publication pub) {
        String key = this.getCacheKey(pub);
        this.publicationTOCCache.acquireWriteLockOnKey(key);
    }

    public void unlockPublicationCache(Publication pub) {
        String key = this.getCacheKey(pub);
        this.publicationTOCCache.releaseWriteLockOnKey(key);
    }

    public DocumentTree parseDocument(InputStream is, long uriid, boolean paraTitles) throws SAXException {
        DocumentTree tree;
        try {
            DocumentTreeHandler handler = new DocumentTreeHandler(uriid);
            handler.setParaTitles(paraTitles);
            SAXParserFactory factory = XMLHelpers.safeSAXParserFactory();
            SAXParser parser = factory.newSAXParser();
            parser.parse(is, (DefaultHandler)handler);
            tree = (DocumentTree)handler.get();
        }
        catch (IOException | ParserConfigurationException ex) {
            throw new SAXException(ex);
        }
        if (tree == null) {
            throw new SAXException("Unknown error");
        }
        return tree;
    }

    public @Nullable DocumentTree parseDocument(Database db, long uriid, Group pubGroup, boolean paraTitles) {
        return this.parseDocument(db, uriid, pubGroup, paraTitles, null, null);
    }

    public @Nullable DocumentTree parseDocument(Database db, long uriid, Group pubGroup, boolean paraTitles, @Nullable String version, @Nullable Publication publication) {
        DocumentTree tree = null;
        try {
            Long releaseId;
            URI uri = DatabaseQuery.getURIById((Database)db, (Long)uriid);
            if (uri == null) {
                LOGGER.error("URI not found for URID {}", (Object)uriid);
                return null;
            }
            Group group = PublicationManager.getDocumentGroup(db, uri, pubGroup);
            DocumentContentResolver resolver = new DocumentContentResolver(uriid, group.getName());
            UserDetails.Builder userDetails = new UserDetails.Builder();
            userDetails.setFlags("admin", "");
            resolver.setTransclude(userDetails.build());
            resolver.setPSMLFormat(true);
            if (version != null && (releaseId = XLinkRule.getValidRelease(db, uri, null, version, publication)) != null) {
                resolver.setReleaseId(releaseId);
            }
            tree = this.parseDocument(resolver.getContent(db), uriid, paraTitles);
        }
        catch (Exception ex) {
            LOGGER.error("Error parsing document tree for URID {}: {}", (Object)uriid, (Object)ex.getMessage());
        }
        return tree;
    }

    public static Group getDocumentGroup(Database db, URI uri, Group pubGroup) throws DatabaseException {
        Group defaultGroup;
        Group group = pubGroup;
        if (!URIRule.isDefaultGroup(uri, group) && !URIRule.belongsToGroup(db, uri.getId(), group.getName()) && (defaultGroup = URIRule.getDefaultGroupForURI(uri)) != null) {
            group = defaultGroup;
        }
        return group;
    }

    public PublicationConfig getPublicationConfig(Group group, String type) {
        String template = group.getOwnerDirectory();
        String globalTemplate = GlobalSettings.getGlobalTemplate();
        PublicationConfig config = this.getPublicationConfig(template, type);
        if (config == null) {
            config = this.getPublicationConfig(globalTemplate, type);
        }
        if (config == null) {
            config = this.getPublicationConfig("default", "default");
        }
        if (config == null) {
            LOGGER.error("Default publication config not found");
            return new PublicationConfig();
        }
        return config;
    }

    private @Nullable PublicationConfig getPublicationConfig(@Nullable String template, String type) {
        if (Strings.isEmpty((String)template)) {
            return null;
        }
        String key = template + "-" + type;
        PublicationConfig config = this.publicationConfigs.get(key);
        if (config == null) {
            try {
                File configfile = PSMLFiles.findPublicationConfigFile(template, type);
                if (configfile != null) {
                    LOGGER.debug("Loading publication config for project {}, type {} from file system.", (Object)template, (Object)type);
                    config = PublicationConfig.loadPublicationConfigFile((File)configfile);
                    this.publicationConfigs.put(template + "-" + type, config);
                }
            }
            catch (IOException ex) {
                LOGGER.error("Unable to load publication config for project {}, type {}: {}", new Object[]{template, type, ex.getMessage()});
                return new PublicationConfig();
            }
        }
        return config;
    }

    private void registerPublicationChanges(Database db, Publication pub, @Nullable Map<Long, Integer> uris, @Nullable Map<Long, Integer> existingLocators, @Nullable Map<Long, Integer> addedLocators) throws QueryFailedException {
        Locator loc;
        HashSet<URI> added = new HashSet<URI>();
        HashSet<URI> modified = new HashSet<URI>();
        HashSet<URI> existing = new HashSet<URI>();
        HashSet<URI> removed = new HashSet<URI>();
        if (uris != null) {
            for (Map.Entry<Long, Integer> entry : uris.entrySet()) {
                URI uri;
                if (entry.getValue() != 1 || (uri = DatabaseQuery.getURIById((Database)db, (Long)entry.getKey())) == null) continue;
                modified.add(uri);
            }
        }
        if (addedLocators != null) {
            for (Map.Entry<Long, Integer> entry : addedLocators.entrySet()) {
                loc = DatabaseQuery.getLocatorById((Database)db, (Long)entry.getKey());
                if (loc == null) continue;
                added.add(loc.getURI());
            }
        }
        if (existingLocators != null) {
            for (Map.Entry<Long, Integer> entry : existingLocators.entrySet()) {
                loc = DatabaseQuery.getLocatorById((Database)db, (Long)entry.getKey());
                if (loc == null) continue;
                if (entry.getValue() == 1) {
                    added.add(loc.getURI());
                    continue;
                }
                if (entry.getValue() == -1) {
                    removed.add(loc.getURI());
                    continue;
                }
                existing.add(loc.getURI());
            }
        }
        removed.removeAll(existing);
        removed.removeAll(added);
        removed.removeAll(modified);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Publication {} changes added: {}, modified: {}, removed: {}", new Object[]{pub.getId(), PublicationManager.urisToIds(added), PublicationManager.urisToIds(modified), PublicationManager.urisToIds(removed)});
        }
        ChangesManager.getInstance().modifyPublication(db, null, pub, added, modified, removed, Collections.emptyList());
    }

    private static String urisToIds(Collection<URI> uris) {
        return uris.stream().map(u -> String.valueOf(u.getId())).collect(Collectors.joining(","));
    }

    public void reloadPublicationConfig(Group group, String type) {
        String template = group.getOwnerDirectory();
        this.reloadPublicationConfig(template, type);
    }

    public void reloadPublicationConfig(String template, String type) {
        String key = template + "-" + type;
        this.publicationConfigs.remove(key);
    }

    public void putCachedTOC(Publication pub, NumberedTOC toc) {
        this.putCachedTOC(this.getCacheKey(pub), toc);
    }

    private void putCachedTOC(String key, NumberedTOC toc) {
        LOGGER.debug("Put publication TOC cache with key={}", (Object)key);
        this.publicationTOCCache.put(key, toc);
    }

    private void putCachedTOCVersion(String key, NumberedTOC toc) {
        LOGGER.debug("Put publication TOC version cache with key={}", (Object)key);
        this.publicationTOCVersionCache.put(key, toc);
    }

    private @Nullable NumberedTOC getCachedTOC(String key) {
        LOGGER.debug("Get publication TOC cache with key={}", (Object)key);
        return this.publicationTOCCache.get(key);
    }

    private @Nullable NumberedTOC getCachedTOCVersion(String key) {
        LOGGER.debug("Get publication TOC cache with key={}", (Object)key);
        return this.publicationTOCVersionCache.get(key);
    }

    private String getCacheKey(Publication pub) {
        return pub.getId() + "-" + pub.getHostId();
    }

    private String getVersionCacheKey(Publication pub, String version) {
        return pub.getId() + "-" + pub.getHostId() + "~" + version;
    }
}

