/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.publication;

import com.pageseeder.base.document.PSMLContentUtils;
import com.pageseeder.base.publication.NumberedTOC;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.util.ExportUtils;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.process.util.XMLUtils;
import org.pageseeder.psml.toc.FragmentNumbering;
import org.pageseeder.psml.toc.PublicationConfig;
import org.pageseeder.psml.toc.PublicationTree;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterNSImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ContentAdjustor
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentAdjustor.class);
    public static final Pattern PREFIX_HEADING_PARENTNUMBER = Pattern.compile(".{0,500}?\\{(prefix|heading|parentnumber)}.{0,500}");
    public static final Pattern PLACEHOLDER_ELEMENT = Pattern.compile("<placeholder\\s+name=\"([^\"]+)\"\\s*>([^<]*)</placeholder>");
    private final @Nullable NumberedTOC toc;
    private final PublicationConfig pubConfig;
    private @Nullable Map<String, String> pubMetadata = null;
    private final long uriid;
    private final String publicationid;
    private final int position;
    private final boolean transcluded;
    private final boolean diff;
    private @Nullable UserDetails userDetails;
    private Database db;
    private final XMLWriter output;
    private boolean interpublicationXrefs = true;
    private int independent = 0;
    private @Nullable String context = null;
    private @Nullable String parentFolder = null;
    private @Nullable String groupRoot = null;
    private @Nullable String currentFragment = null;
    private int currentIndex = 1;
    private int currentHeadingIndex = 1;
    private @Nullable String currentContent = null;
    private Stack<Integer> currentXRefLevels = new Stack();
    private int inMediaFragment = 0;
    private boolean inDiff = false;

    public ContentAdjustor(Writer out, @Nullable NumberedTOC toc, @Nullable PublicationConfig pubconf, long uriid, String publicationid, int position, boolean transclude, boolean diff, @Nullable UserDetails userdetails, Database db) {
        this.publicationid = publicationid;
        this.position = position;
        this.pubConfig = pubconf;
        this.toc = toc;
        this.transcluded = transclude;
        this.diff = diff;
        this.uriid = uriid;
        this.output = new XMLWriterNSImpl(out);
        this.userDetails = userdetails;
        this.db = db;
    }

    public void writeXMLDeclaration() throws IOException {
        this.output.xmlDecl();
    }

    public void setInterpublicationXrefs(boolean resolve) {
        this.interpublicationXrefs = resolve;
    }

    public void setIndependent(int ind) {
        this.independent = ind;
    }

    public void setPublicationMetadata(Map<String, String> metadata) {
        this.pubMetadata = metadata;
    }

    public void setRelativePaths(String folder, String ctxt, String groupctxt) {
        this.parentFolder = folder;
        this.context = RuleUtils.urlEncodeFilepath(ctxt.replaceAll("/$", "")) + "/";
        this.groupRoot = RuleUtils.urlEncodeFilepath(groupctxt.replaceAll("/$", "")) + "/";
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.output.setPrefixMapping(uri, prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        HashMap<String, String> adjusted = new HashMap<String, String>();
        if ("media-fragment".equals(localName)) {
            ++this.inMediaFragment;
        }
        if (this.inMediaFragment == 0 && "diff".equals(localName)) {
            this.inDiff = true;
        }
        if (this.inMediaFragment == 0 && (this.inDiff && this.diff || !this.inDiff && !this.diff)) {
            if (this.toc != null) {
                this.adjustForPublication(localName, attributes, adjusted);
            }
            if ("xref".equals(localName) && "template".equals(attributes.getValue("display"))) {
                this.adjustXref(attributes);
            }
            if (this.parentFolder != null) {
                this.adjustPaths(localName, attributes, adjusted);
            }
        }
        if ("document".equals(localName) && this.inMediaFragment == 0 && !this.diff && this.toc != null) {
            adjusted.put("level", "processed");
            adjusted.put("publicationid", this.publicationid);
            adjusted.put("position", Integer.toString(this.position));
        }
        if (this.pubMetadata != null && this.inMediaFragment == 0 && "placeholder".equals(localName)) {
            this.adjustPlaceholder(attributes);
        }
        try {
            this.output.openElement(Strings.isEmpty((String)uri) ? null : uri, localName, true);
            for (int i = 0; i < attributes.getLength(); ++i) {
                String u = Strings.isEmpty((String)attributes.getURI(i)) ? null : attributes.getURI(i);
                String name = attributes.getLocalName(i);
                String value = adjusted.containsKey(name) ? (String)adjusted.get(name) : attributes.getValue(i);
                this.output.attribute(u, name, value);
            }
            for (String name : adjusted.keySet()) {
                if (attributes.getValue(name) != null) continue;
                this.output.attribute(name, (String)adjusted.get(name));
            }
        }
        catch (IOException ex) {
            this.error(ex);
        }
    }

    private void adjustForPublication(String localName, Attributes attributes, Map<String, String> adjusted) {
        if (PSMLContentUtils.isFragmentElement(localName) && this.currentFragment == null && this.currentXRefLevels.isEmpty()) {
            this.currentFragment = attributes.getValue("id");
            this.currentIndex = 1;
        }
        if ("heading".equals(localName)) {
            this.adjustHeading(attributes, adjusted);
        } else if ("para".equals(localName)) {
            this.adjustPara(attributes, adjusted);
        } else if ("reversexref".equals(localName) && "template".equals(attributes.getValue("forwarddisplay"))) {
            this.adjustReverseXref(attributes, adjusted);
        }
        if ("blockxref".equals(localName) || "xref".equals(localName)) {
            this.adjustTransclusion(attributes);
        }
    }

    private void adjustTransclusion(Attributes attributes) {
        if ("transclude".equals(attributes.getValue("type"))) {
            int current;
            String level = attributes.getValue("level");
            int n = current = this.currentXRefLevels.isEmpty() ? 0 : this.currentXRefLevels.peek();
            if (Strings.isDigits((String)level)) {
                this.currentXRefLevels.push(current + Integer.parseInt(level));
            } else {
                this.currentXRefLevels.push(current);
            }
        } else {
            this.currentXRefLevels.push(0);
        }
    }

    private void adjustReverseXref(Attributes attributes, Map<String, String> adjusted) {
        String targetfrag = attributes.getValue("forwardfrag");
        String title = attributes.getValue("forwardtitle");
        if (title != null && PREFIX_HEADING_PARENTNUMBER.matcher(title).matches()) {
            String sourceuri = attributes.getValue("uriid");
            adjusted.put("forwardtitle", this.adjustXRefTitle(title, targetfrag, this.uriid, this.toc, false, Long.toString(this.uriid).equals(sourceuri) ? Integer.valueOf(this.position) : null));
        }
    }

    private void adjustXref(Attributes attributes) {
        String title = attributes.getValue("title");
        if (title != null && PREFIX_HEADING_PARENTNUMBER.matcher(title).matches()) {
            String targetfrag = attributes.getValue("frag");
            String targeturi = attributes.getValue("uriid");
            if (targeturi != null) {
                PublicationTree pubtree;
                long targeturiid = Long.parseLong(targeturi);
                NumberedTOC targettoc = this.toc;
                PublicationTree publicationTree = pubtree = this.toc != null ? this.toc.getPublicationTree() : null;
                if (this.interpublicationXrefs && (this.toc == null || !pubtree.containsTree(targeturiid) && !pubtree.transclusions().containsKey(targeturiid))) {
                    try {
                        targettoc = Publications.getDefaultNumberedToc(this.db, targeturiid, this.userDetails);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Unable to resolve template in URI ID {} for interpublication xref to {}: {}", new Object[]{this.uriid, targeturiid, ex.getMessage()});
                    }
                } else if (this.toc != null && !pubtree.containsTree(targeturiid) && !pubtree.transclusions().containsKey(targeturiid)) {
                    return;
                }
                if (targettoc != null) {
                    this.currentContent = this.adjustXRefTitle(title, targetfrag, targeturiid, targettoc, true, Long.toString(this.uriid).equals(targeturi) ? Integer.valueOf(this.position) : null);
                }
            }
        }
    }

    private void adjustPaths(String elemName, Attributes attributes, Map<String, String> adjusted) {
        if ("image".equals(elemName) && attributes.getValue("src") != null) {
            adjusted.put("src", ExportUtils.relativiseFullPath(attributes.getValue("src"), this.parentFolder, this.context, this.groupRoot, this.independent));
        } else if (("xref".equals(elemName) || "blockXref".equalsIgnoreCase(elemName) || "reversexref".equals(elemName)) && !"true".equals(attributes.getValue("external")) && attributes.getValue("href") != null) {
            adjusted.put("href", ExportUtils.relativiseFullPath(attributes.getValue("href"), this.parentFolder, this.context, this.groupRoot, this.independent));
        }
    }

    private void adjustPlaceholder(Attributes attributes) {
        String name = attributes.getValue("name");
        if (name != null) {
            this.currentContent = XMLUtils.escape((String)this.pubMetadata.get(name));
        }
    }

    private String resolvePlaceholders(String orig) {
        if (this.pubMetadata == null) {
            return orig;
        }
        Matcher m = PLACEHOLDER_ELEMENT.matcher(orig);
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            String cont = XMLUtils.escape((String)this.pubMetadata.get(m.group(1)));
            if (cont == null) {
                cont = m.group(2);
            }
            m.appendReplacement(sb, "<placeholder name=\"");
            sb.append(m.group(1)).append("\">").append(cont).append("</placeholder>");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private void adjustPara(Attributes attributes, Map<String, String> adjusted) {
        String level;
        if ("true".equals(attributes.getValue("numbered"))) {
            FragmentNumbering.Prefix p;
            FragmentNumbering.Prefix prefix = p = this.transcluded ? this.toc.getFragmentNumbering().getTranscludedPrefix(this.uriid, this.position, this.currentFragment, this.currentIndex) : this.toc.getFragmentNumbering().getPrefix(this.uriid, this.position, this.currentFragment, this.currentIndex);
            if (p != null) {
                adjusted.put("prefix", p.value);
            }
        }
        if ((level = attributes.getValue("indent")) != null && level.matches("\\d+")) {
            if (this.pubConfig.getParaLevelAdjust() == PublicationConfig.LevelAdjust.CONTENT) {
                FragmentNumbering.Prefix p = this.toc.getFragmentNumbering().getPrefix(this.uriid, this.position);
                if (p != null) {
                    int transcludeLevel;
                    int n = transcludeLevel = this.currentXRefLevels.isEmpty() ? 0 : this.currentXRefLevels.peek();
                    if (this.pubConfig.getParaLevelRelativeTo() == PublicationConfig.LevelRelativeTo.DOCUMENT) {
                        int newlevel = Integer.parseInt(level) + transcludeLevel + p.level - 1;
                        adjusted.put("indent", String.valueOf(newlevel > 0 ? newlevel : 1));
                    } else {
                        Integer adj = this.currentHeadingIndex > 0 ? this.currentHeadingIndex : (Integer)this.toc.getPublicationTree().tree(this.uriid).fragmentlevels().get(this.currentFragment);
                        int newlevel = transcludeLevel + p.level - 1 + (adj == null ? 0 : adj);
                        adjusted.put("indent", String.valueOf(newlevel > 0 ? newlevel : 1));
                    }
                }
            } else if (!this.currentXRefLevels.isEmpty() && this.pubConfig.getParaLevelRelativeTo() == PublicationConfig.LevelRelativeTo.DOCUMENT) {
                int transcludeLevel = this.currentXRefLevels.isEmpty() ? 0 : this.currentXRefLevels.peek();
                adjusted.put("indent", String.valueOf(Integer.parseInt(level) + transcludeLevel));
            }
        }
        ++this.currentIndex;
    }

    private void adjustHeading(Attributes attributes, Map<String, String> adjusted) {
        String level;
        if ("true".equals(attributes.getValue("numbered"))) {
            FragmentNumbering.Prefix p;
            FragmentNumbering.Prefix prefix = p = this.transcluded ? this.toc.getFragmentNumbering().getTranscludedPrefix(this.uriid, this.position, this.currentFragment, this.currentIndex) : this.toc.getFragmentNumbering().getPrefix(this.uriid, this.position, this.currentFragment, this.currentIndex);
            if (p != null) {
                adjusted.put("prefix", p.value);
            }
        }
        if (this.pubConfig.getHeadingLevelAdjust() == PublicationConfig.LevelAdjust.CONTENT) {
            level = attributes.getValue("level");
            if (level != null && level.matches("\\d+")) {
                this.currentHeadingIndex = Integer.parseInt(level);
                int transcludeLevel = this.currentXRefLevels.isEmpty() ? 0 : this.currentXRefLevels.peek();
                FragmentNumbering.Prefix p = this.toc.getFragmentNumbering().getPrefix(this.uriid, this.position);
                if (p != null) {
                    int newlevel = this.currentHeadingIndex + transcludeLevel + p.level - 1;
                    adjusted.put("level", String.valueOf(newlevel > 0 ? newlevel : 1));
                }
            }
        } else if (!this.currentXRefLevels.isEmpty() && (level = attributes.getValue("level")) != null && level.matches("\\d+")) {
            this.currentHeadingIndex = Integer.parseInt(level);
            int transcludeLevel = this.currentXRefLevels.isEmpty() ? 0 : this.currentXRefLevels.peek();
            adjusted.put("level", String.valueOf(this.currentHeadingIndex + transcludeLevel));
        }
        ++this.currentIndex;
    }

    public String adjustXRefTitle(String title, String targetfrag, long targeturiid, NumberedTOC targettoc, boolean xml, @Nullable Integer position) {
        FragmentNumbering.Prefix prefix = null;
        if (title.contains("{prefix}") || title.contains("{parentnumber}")) {
            int found_pos = 0;
            if (position != null) {
                prefix = ContentAdjustor.getPrefixForFirstSecondIndex(targetfrag, targeturiid, targettoc, position);
            } else {
                for (int i = 1; i <= 100; ++i) {
                    if (prefix == null) {
                        prefix = ContentAdjustor.getPrefixForFirstSecondIndex(targetfrag, targeturiid, targettoc, i);
                        found_pos = i;
                    }
                    if (prefix == null || targettoc.getFragmentNumbering().getPrefix(targeturiid, i) == null) continue;
                    if (found_pos == i) break;
                    prefix = ContentAdjustor.getPrefixForFirstSecondIndex(targetfrag, targeturiid, targettoc, i);
                    break;
                }
            }
        }
        String newPrefix = prefix == null ? null : prefix.value;
        String newHeading = targettoc.getPublicationTree().getFragmentHeading(targeturiid, targetfrag);
        String newParentNumber = prefix == null ? null : prefix.parentNumber;
        newPrefix = newPrefix != null && xml ? XMLUtils.escape((String)newPrefix) : newPrefix;
        String string = newParentNumber = newParentNumber != null && xml ? XMLUtils.escape((String)newParentNumber) : newParentNumber;
        if (title.contains("{heading}") && newHeading != null) {
            newHeading = this.resolvePlaceholders(newHeading);
            if (!xml) {
                newHeading = XMLHelpers.xmlToText(newHeading);
            }
        }
        return title.replace("{prefix}", newPrefix == null ? "?" : newPrefix).replace("{heading}", newHeading == null ? "?" : newHeading).replace("{parentnumber}", newParentNumber == null ? "" : newParentNumber);
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable FragmentNumbering.Prefix getPrefixForFirstSecondIndex(String targetfrag, long targeturiid, NumberedTOC targettoc, Integer position) {
        FragmentNumbering.Prefix prefix = targettoc.getFragmentNumbering().getPrefix(targeturiid, position.intValue(), targetfrag, 1);
        if (prefix == null) {
            prefix = targettoc.getFragmentNumbering().getPrefix(targeturiid, position.intValue(), targetfrag, 2);
        }
        return prefix;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("media-fragment".equals(localName)) {
            --this.inMediaFragment;
        }
        if (this.inMediaFragment == 0 && "diff".equals(localName)) {
            this.inDiff = false;
        }
        if (this.toc != null && this.inMediaFragment == 0 && (this.inDiff && this.diff || !this.inDiff && !this.diff)) {
            if (PSMLContentUtils.isFragmentElement(localName) && this.currentXRefLevels.isEmpty()) {
                this.currentFragment = null;
            }
            if ("blockxref".equals(localName) || "xref".equals(localName)) {
                this.currentXRefLevels.pop();
            }
        }
        try {
            if (this.currentContent != null) {
                this.output.writeXML(this.currentContent);
                this.currentContent = null;
            }
            this.output.closeElement();
        }
        catch (IOException ex) {
            this.error(ex);
        }
    }

    private void error(IOException e) throws SAXException {
        throw new SAXException("Failed to write XML to output: " + e.getMessage());
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.output.flush();
        }
        catch (IOException e) {
            this.error(e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (this.currentContent == null) {
                this.output.writeText(ch, start, length);
            }
        }
        catch (IOException ex) {
            this.error(ex);
        }
    }
}

