/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.permission;

import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupForXLink;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import java.util.Iterator;
import org.slf4j.LoggerFactory;

public final class ViewXLinkCheck
extends PermissionCheck {
    public ViewXLinkCheck(XLink xl) {
        this.xl = xl;
    }

    public ViewXLinkCheck(URI uri, XLink xl) {
        this.uri = uri;
        this.xl = xl;
    }

    @Override
    public boolean hasAccess(Database db, Permissions perm) {
        Iterator gfxi = this.xl.getGroupsForXLink();
        while (gfxi.hasNext()) {
            Group grp = ((GroupForXLink)gfxi.next()).getGroup();
            boolean groupValid = grp.getFlags() != null && grp.getFlags().contains("p") || perm.getDisplayGroups().contains(grp.getName());
            if (!groupValid || !this.xl.getAccepted().booleanValue() && !perm.getEditAllXLinks().booleanValue()) continue;
            return true;
        }
        if (this.xl.getAuthorOnly().booleanValue()) {
            if (this.xl.getMember() == null) {
                return true;
            }
            try {
                Long memberid = perm.getMemberId();
                Member mem = null;
                if (memberid != null && (mem = DatabaseQuery.getMemberById((Database)db, (Long)memberid)) == null) {
                    throw new DatabaseException("Member not found with ID: " + memberid);
                }
                if (mem != null && this.xl.getMember() == mem || perm.getExternalUserId() != null && perm.getExternalUserId().equals(this.xl.getExternalUserId())) {
                    return true;
                }
            }
            catch (DatabaseException ex) {
                LoggerFactory.getLogger(ViewXLinkCheck.class).error("Unable to perform check", (Throwable)ex);
            }
        }
        return false;
    }
}

