/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.permission;

import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.db.Database;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;

public final class RegisterForGroupCheck
extends PermissionCheck {
    private Member mem = null;
    private String message = null;

    public RegisterForGroupCheck(Group group) {
        this.grp = group;
    }

    @Override
    public boolean hasAccess(Database db, Permissions perm) {
        boolean res = false;
        if (perm.getEditGroup().booleanValue()) {
            res = true;
        } else if (this.mem == null || this.mem.getId().equals(perm.getMemberId())) {
            if (GroupRule.isPublicGroup(this.grp.getControlGroupName())) {
                res = true;
            } else if (perm.getUserDetails() != null && this.grp.getControlGroupName() != null && perm.getUserDetails().flags().containsKey(this.grp.getControlGroupName())) {
                res = true;
            } else {
                this.message = "You do not have access to register for this group.";
            }
        } else {
            this.message = "Your login does not match the registration details.";
        }
        return res;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

