/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.permission;

import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.oauth.model.AccessToken;
import com.pageseeder.base.oauth.model.AccessTokenManager;
import com.pageseeder.base.permission.PermissionException;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.GroupURIData;
import com.pageseeder.base.rule.GroupURIForGroupRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.security.CSRF;
import com.pageseeder.base.security.LockedAccountException;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.base.web.WebTransaction;
import com.pageseeder.base.web.WebUtilities;
import com.pageseeder.common.oauth.HTTP;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.Base64;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.GroupURIForGroup;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Role;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.oauth.Scope;
import com.pageseeder.db.util.GroupURIs;
import com.pageseeder.db.util.Groups;
import com.pageseeder.db.util.URIs;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jdt.annotation.Nullable;

public final class Permissions {
    public static final String SAVE_RELEASE = "save-release";
    public static final String CREATE_WORKFLOW = "create-workflow";
    public static final String EDIT_COMMENTS = "edit-comments";
    public static final String DELETE_COMMENTS = "delete-comments";
    public static final String ARCHIVE_COMMENTS = "archive-comments";
    public static final String DELETE_DOCUMENTS = "delete-documents";
    public static final String MANAGE_DOCUMENTS = "manage-documents";
    private Status status = Status.UNDEFINED;
    private @Nullable String statusMessage = null;
    private @Nullable String uriString = null;
    private @Nullable Boolean isFolder = null;
    private @Nullable Long uriId = null;
    private @Nullable Long guriId = null;
    private @Nullable Long xLinkId = null;
    private @Nullable Set<String> xLinkGroupNames = null;
    private @Nullable String groupName = null;
    private boolean authenticate = false;
    private @Nullable Long memberid = null;
    private @Nullable UserDetails userDetails = null;
    private @Nullable String externalUserEmail = null;
    private @Nullable String externalUserFullName = null;
    private @Nullable String externalUserId = null;
    private boolean adminDatabase = false;
    private boolean adminSystem = false;
    private boolean createProject = false;
    private boolean develop = false;
    private boolean manageAccount = false;
    private boolean manageOAuth = false;
    private boolean manageWebhook = false;
    private boolean editAllURLs = false;
    private boolean addURLs = false;
    private boolean viewGroup = false;
    private boolean editGroup = false;
    private boolean archiveGroup = false;
    private boolean deleteGroup = false;
    private boolean configProject = false;
    private boolean viewMembers = false;
    private boolean viewURI = false;
    private boolean editURI = false;
    private boolean archiveURI = false;
    private boolean deleteURI = false;
    private boolean addXLinks = false;
    private boolean addEditXLinks = false;
    private boolean addWorkflowXLinks = false;
    private boolean setGroups = false;
    private boolean editXLinks = false;
    private boolean archiveXLinks = false;
    private boolean deleteXLinks = false;
    private boolean editAllXLinks = false;
    private boolean approveAllXLinks = false;
    private boolean archiveAllXLinks = false;
    private boolean assignAllXLinks = false;
    private boolean deleteAllXLinks = false;
    private Collection<String> addGroups = new ArrayList<String>();
    private Collection<String> displayGroups = new ArrayList<String>();
    private @Nullable HttpServletRequest req;
    private @Nullable HttpServletResponse res;
    private @Nullable Set<Scope> scopes = null;

    private void cacheGroupURIs(Database db, @Nullable Group grp, @Nullable URI uri) throws DatabaseException {
        if (grp == null || uri == null) {
            return;
        }
        HttpServletRequest request = this.req;
        if (request != null) {
            HttpSession session = request.getSession(false);
            if (session == null) {
                return;
            }
            WebTransaction wtr = new WebTransaction(session, "Login", false);
            if (!grp.getName().equals(wtr.get("cachedGroupName")) || !uri.getId().equals(wtr.get("cachedURIId"))) {
                ArrayList<GroupURIData> gurids = new ArrayList<GroupURIData>();
                Collection guris = DatabaseQuery.getGroupURIsByURIGroup((Database)db, (URI)uri, (Group)grp);
                for (GroupURI guri : guris) {
                    GroupURIData gurid = new GroupURIData();
                    gurid.setScheme(guri.getScheme());
                    gurid.setHostName(guri.getHost().getName());
                    gurid.setPort(guri.getPort());
                    gurid.setPath(guri.getPath());
                    gurids.add(gurid);
                }
                wtr.add("cachedGroupURIs", gurids);
                wtr.add("cachedGroupName", grp.getName());
                wtr.add("cachedURIId", uri.getId());
            }
        }
    }

    private @Nullable String[] getAutoLoginUsernamePassword() {
        String[] credentials = new String[]{null, null};
        HttpServletRequest request = this.req;
        if (request != null) {
            String authorization = request.getHeader("Authorization");
            if (authorization != null) {
                if (authorization.startsWith("Basic")) {
                    String base64 = authorization.substring("Basic".length()).trim();
                    try {
                        String pair = Base64.decode((String)base64, (Charset)StandardCharsets.UTF_8);
                        credentials = pair.split(":", 2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            } else {
                credentials = new String[]{request.getParameter("username"), request.getParameter("password")};
            }
        }
        return credentials;
    }

    public Collection<String> getAddGroups() {
        return this.addGroups;
    }

    public @Nullable String getExternalUserEmail() {
        return this.externalUserEmail;
    }

    public @Nullable String getExternalUserFullName() {
        return this.externalUserFullName;
    }

    public @Nullable String getExternalUserId() {
        return this.externalUserId;
    }

    public Collection<String> getDisplayGroups() {
        return this.displayGroups;
    }

    public Status getStatus() {
        return this.status;
    }

    public @Nullable String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(@Nullable String message) {
        this.statusMessage = message;
    }

    public @Nullable Long getMemberId() {
        return this.memberid;
    }

    public boolean isLoggedIn() {
        return this.memberid != null;
    }

    public void setMemberId(Long id) {
        this.memberid = id;
    }

    public @Nullable UserDetails getUserDetails() {
        return this.userDetails;
    }

    public void setUserDetails(UserDetails details) {
        this.userDetails = details;
    }

    public Boolean getAdminDatabase() {
        return this.adminDatabase;
    }

    public Boolean getAdminSystem() {
        return this.adminSystem;
    }

    public boolean getCreateProject() {
        return this.createProject;
    }

    public boolean getDevelop() {
        return this.develop;
    }

    public boolean getManageAccount() {
        return this.manageAccount;
    }

    public boolean getManageOAuth() {
        return this.manageOAuth;
    }

    public boolean getManageWebhook() {
        return this.manageWebhook;
    }

    public Boolean getEditAllURLs() {
        return this.editAllURLs;
    }

    public Boolean getAddURLs() {
        return this.addURLs;
    }

    public Boolean getViewGroup() {
        return this.viewGroup;
    }

    public Boolean getEditGroup() {
        return this.editGroup;
    }

    public Boolean getArchiveGroup() {
        return this.archiveGroup;
    }

    public Boolean getDeleteGroup() {
        return this.deleteGroup;
    }

    public Boolean getConfigProject() {
        return this.configProject;
    }

    public Boolean getViewMembers() {
        return this.viewMembers;
    }

    public Boolean getViewURI() {
        return this.viewURI;
    }

    public Boolean getEditURI() {
        return this.editURI;
    }

    public Boolean getArchiveURI() {
        return this.archiveURI;
    }

    public Boolean getDeleteURI() {
        return this.deleteURI;
    }

    public Boolean getAddXLinks() {
        return this.addXLinks;
    }

    public Boolean getAddEditXLinks() {
        return this.addEditXLinks;
    }

    public Boolean getAddWorkflowXLinks() {
        return this.addWorkflowXLinks;
    }

    public Boolean getSetGroups() {
        return this.setGroups;
    }

    public Boolean getEditXLinks() {
        return this.editXLinks;
    }

    public Boolean getArchiveXLinks() {
        return this.archiveXLinks;
    }

    public Boolean getDeleteXLinks() {
        return this.deleteXLinks;
    }

    public Boolean getEditAllXLinks() {
        return this.editAllXLinks;
    }

    public Boolean getApproveAllXLinks() {
        return this.approveAllXLinks;
    }

    public Boolean getArchiveAllXLinks() {
        return this.archiveAllXLinks;
    }

    public Boolean getAssignAllXLinks() {
        return this.assignAllXLinks;
    }

    public Boolean getDeleteAllXLinks() {
        return this.deleteAllXLinks;
    }

    public void loadPermissions(Database db) throws PermissionException {
        if (this.req == null && this.userDetails == null) {
            throw new PermissionException(new IllegalStateException("HTTP Request or User Details must be set."));
        }
        try {
            URI uri = null;
            GroupURI guri = null;
            if (this.uriId != null) {
                uri = DatabaseQuery.getURIById((Database)db, (Long)this.uriId);
            } else if (this.guriId != null) {
                guri = DatabaseQuery.getGroupURIById((Database)db, (Long)this.guriId);
                if (guri == null) {
                    throw new DatabaseException("Group URI not found: " + this.guriId);
                }
                uri = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)guri.getScheme(), (String)guri.getHost().getName(), (Integer)guri.getPort(), (String)GroupURIs.truncatePath((String)guri.getPath()));
            }
            if (!this.loadUserDetailsFromOAuth(db, uri) && !this.loadUserDetailsFromSession(db, uri)) {
                return;
            }
            boolean admin = false;
            Role role = null;
            boolean notUsersPersonalGroup = false;
            if (this.memberid == null && this.authenticate && this.req != null && this.res != null) {
                SecurityUtils.resource(this.req, this.res);
                this.status = Status.RESPONSE_RETURNED;
                return;
            }
            if (this.memberid != null) {
                admin = MemberRule.isAdministrator(this.userDetails.flags());
            }
            Collection<Group> grpc = new ArrayList<Group>();
            ArrayList<Object> rgrpc = new ArrayList();
            ArrayList<GroupURIForGroup> gurifgs = new ArrayList();
            this.displayGroups = new ArrayList<String>();
            if (this.groupName != null) {
                notUsersPersonalGroup = this.isNotUsersPersonalGroup(db, this.groupName);
                role = this.setGroupPermissions(db, grpc);
                rgrpc = new ArrayList<Group>(grpc);
            }
            boolean external = false;
            if (uri != null) {
                gurifgs = DatabaseQuery.getGroupURIForGroupsByURI((Database)db, (URI)uri);
                grpc = GroupRule.getGroupsFromGroupURIForGroups(gurifgs);
                external = guri == null && URIs.isExternal((URI)uri);
                role = this.setURIPermissions(db, uri, role, grpc, external);
            } else if (this.uriString != null) {
                URL url = null;
                try {
                    url = new URL(this.uriString);
                }
                catch (MalformedURLException ex) {
                    throw new PermissionException("Not a valid URL: " + this.uriString, ex);
                }
                boolean folder = this.isFolder != null && this.isFolder != false;
                gurifgs = GroupURIForGroupRule.getGroupURIForGroupsForURL(db, url, folder);
                grpc = GroupRule.getGroupsFromGroupURIForGroups(gurifgs);
                external = URIRule.isExternal(url, db);
                role = this.setURIStringPermissions(role, grpc, external);
            }
            Group uriDefaultGroup = GroupURIForGroupRule.getDefaultGroupForGroupURIs(gurifgs);
            if (uriDefaultGroup != null) {
                notUsersPersonalGroup = this.isNotUsersPersonalGroup(db, uriDefaultGroup.getName());
            }
            this.setRolePermissions(admin, role);
            this.setURLPermissions();
            boolean archived = this.setArchivePermissions(grpc);
            this.disableURIPermissions(admin, grpc, external);
            this.setViewURIPermissions(db, grpc, external);
            Collection<Object> resourceGroups = new ArrayList<Group>(grpc);
            if (resourceGroups.isEmpty()) {
                if (this.xLinkGroupNames != null) {
                    resourceGroups = GroupRule.removeAdminGroup(GroupRule.getGroupsByNames(db, this.xLinkGroupNames));
                } else if (this.groupName != null) {
                    resourceGroups = rgrpc;
                }
            }
            grpc = MemberRule.removeNonCommentGroups(grpc, this.userDetails.flags());
            this.setSelectedGroupPermissions(admin, role, grpc, gurifgs, external, uriDefaultGroup, archived);
            this.setXLinkPermissions(admin);
            this.setPersonalGroupPermissions(admin, notUsersPersonalGroup);
            this.restrictPermissionsByScope(db, admin, resourceGroups, external);
        }
        catch (DatabaseException | IOException | ServletException ex) {
            throw new PermissionException((Exception)ex);
        }
        this.status = Status.SUCCESS;
    }

    private void setPersonalGroupPermissions(boolean admin, boolean notUsersPersonalGroup) {
        String adminEnable = GlobalSettings.getString((String)"adminEnable", (String)"");
        if (!(!notUsersPersonalGroup || admin && adminEnable.contains("access-personal"))) {
            boolean addXlinks = this.addXLinks;
            this.resetPermissions();
            this.addXLinks = addXlinks;
            if (admin) {
                this.adminSystem = true;
                this.editGroup = true;
                this.viewMembers = true;
            }
        }
    }

    private void setXLinkPermissions(boolean admin) {
        if (this.xLinkGroupNames != null) {
            boolean approver = false;
            boolean manager = false;
            boolean contributor = false;
            if (this.memberid != null) {
                for (String name : this.xLinkGroupNames) {
                    if (!approver) {
                        approver = MemberRule.isContributorForGroupNameFlag(this.userDetails.flags(), name, "a");
                    }
                    if (!manager) {
                        manager = MemberRule.isContributorForGroupNameFlag(this.userDetails.flags(), name, "e");
                    }
                    if (contributor) continue;
                    contributor = MemberRule.isContributorForGroupNameFlag(this.userDetails.flags(), name, "c");
                }
            }
            if (!(contributor || admin || manager)) {
                this.setGroups = false;
                this.editXLinks = false;
                this.archiveXLinks = false;
                this.deleteXLinks = false;
                this.editAllXLinks = false;
                this.archiveAllXLinks = false;
                this.deleteAllXLinks = false;
                this.approveAllXLinks = false;
            } else if (!admin && !manager) {
                this.editAllXLinks = false;
                this.archiveAllXLinks = false;
                this.deleteAllXLinks = false;
                this.approveAllXLinks = false;
            } else if (!admin && !approver) {
                this.approveAllXLinks = false;
            }
        }
    }

    private void setSelectedGroupPermissions(boolean admin, Role role, Collection<Group> grpc, Collection<GroupURIForGroup> gurifgs, boolean external, Group uriDefaultGroup, boolean archived) throws DatabaseException {
        String reviewerEnable = GlobalSettings.getString((String)"reviewerEnable", (String)"");
        String contributorDisable = GlobalSettings.getString((String)"contributorDisable", (String)"");
        MemberRule.addMemberGroupNames(this.displayGroups, this.userDetails.flags());
        this.addGroups = Groups.getGroupNames(grpc);
        if (!external) {
            boolean bl = this.addXLinks = (this.groupName == null || this.addXLinks) && !this.addGroups.isEmpty() && !archived;
        }
        if (!this.addGroups.isEmpty() && !archived) {
            if (uriDefaultGroup != null) {
                boolean bl = this.addEditXLinks = MemberRule.isContributorForGroupNameFlag(this.userDetails.flags(), uriDefaultGroup.getName(), "c") && (this.groupName == null || this.groupName.equals(uriDefaultGroup.getName()));
                if (!this.addEditXLinks) {
                    this.addEditXLinks = MemberRule.isContributorForEditableGroupURI(this.userDetails.flags(), gurifgs, "c", this.groupName);
                }
                this.editURI = this.addEditXLinks;
                if (this.editURI && contributorDisable.contains(MANAGE_DOCUMENTS)) {
                    this.editURI = MemberRule.isContributorForEditableGroupURI(this.userDetails.flags(), gurifgs, "e", this.groupName);
                }
                this.archiveURI = this.editURI;
                this.addWorkflowXLinks = this.addEditXLinks || (reviewerEnable.contains(SAVE_RELEASE) || reviewerEnable.contains(CREATE_WORKFLOW)) && MemberRule.isReviewerForGroupName(this.userDetails.flags(), uriDefaultGroup.getName());
            } else if (this.groupName != null) {
                if (!this.addGroups.contains(this.groupName)) {
                    this.editURI = false;
                    this.archiveURI = false;
                    this.deleteURI = false;
                    if (!external) {
                        this.addEditXLinks = false;
                    }
                } else {
                    this.addEditXLinks = this.setGroups;
                }
                this.addWorkflowXLinks = this.addEditXLinks || (reviewerEnable.contains(SAVE_RELEASE) || reviewerEnable.contains(CREATE_WORKFLOW)) && MemberRule.isReviewerForGroupName(this.userDetails.flags(), this.groupName);
            } else {
                this.addEditXLinks = this.setGroups;
                this.addWorkflowXLinks = this.setGroups;
                if (reviewerEnable.contains(SAVE_RELEASE) || reviewerEnable.contains(CREATE_WORKFLOW)) {
                    for (Group grp : grpc) {
                        if (!MemberRule.isReviewerForGroupName(this.userDetails.flags(), grp.getName())) continue;
                        this.addWorkflowXLinks = true;
                        break;
                    }
                }
            }
        }
        if (!admin && role == null) {
            this.assignAllXLinks = this.addXLinks;
        }
    }

    private void setViewURIPermissions(Database db, Collection<Group> grpc, boolean external) throws DatabaseException {
        String globalTemplate = GlobalSettings.getGlobalTemplate((String)"");
        if (!this.viewURI) {
            for (Group grp : grpc) {
                if (this.userDetails.getFlags(grp.getName()) != null || grp.hasFlag('p')) {
                    this.viewURI = true;
                } else if (grp.getName().endsWith("-help")) {
                    String project = GroupRule.getParentProjectName(grp.getName());
                    boolean bl = this.viewURI = this.memberid != null && (globalTemplate.equals(project) || this.userDetails.getFlags(project) != null);
                }
                if (!this.viewURI || this.uriId == null) continue;
                this.cacheGroupURIs(db, grp, DatabaseQuery.getURIById((Database)db, (Long)this.uriId));
            }
        }
        if (this.groupName != null) {
            if (external) {
                this.viewURI = this.viewGroup;
                this.editURI = false;
                this.archiveURI = false;
                this.deleteURI = this.editAllURLs && this.deleteURI;
            } else if (Groups.getGroupNames(grpc).contains(this.groupName)) {
                this.viewURI = this.viewGroup;
                if (!this.viewURI && this.groupName.endsWith("-help")) {
                    String project = GroupRule.getParentProjectName(this.groupName);
                    this.viewURI = this.memberid != null && (globalTemplate.equals(project) || this.userDetails.getFlags(project) != null);
                }
            } else {
                this.viewURI = false;
            }
        } else if (this.memberid != null && external) {
            this.viewURI = true;
        }
    }

    private void disableURIPermissions(boolean admin, Collection<Group> grpc, boolean external) {
        if ((this.uriId != null || this.guriId != null || this.uriString != null) && grpc.isEmpty()) {
            this.editURI = false;
            this.archiveURI = false;
            if (!external || this.groupName == null && !admin) {
                this.deleteURI = false;
            }
            if (!external) {
                this.viewURI = false;
            }
        }
    }

    private boolean setArchivePermissions(Collection<Group> grpc) {
        boolean archived = false;
        for (Group grp : grpc) {
            if (grp.getFlags() != null && grp.getFlags().contains("d")) {
                archived = true;
                continue;
            }
            if (GroupRule.isPublicGroup(grp.getName())) continue;
            archived = false;
            break;
        }
        if (archived) {
            this.addXLinks = false;
            this.addEditXLinks = false;
            this.addWorkflowXLinks = false;
            this.editXLinks = false;
            this.archiveXLinks = false;
            this.deleteXLinks = false;
            this.editAllXLinks = false;
            this.approveAllXLinks = false;
            this.assignAllXLinks = false;
            this.archiveAllXLinks = false;
        }
        return archived;
    }

    private void setURLPermissions() {
        if (!this.editAllURLs) {
            for (String flags : this.userDetails.flags().values()) {
                if (flags.indexOf(117) == -1) continue;
                this.editAllURLs = true;
                this.addURLs = true;
                break;
            }
        }
        if (!this.addURLs) {
            for (String flags : this.userDetails.flags().values()) {
                if (flags.indexOf(99) == -1) continue;
                this.addURLs = true;
                break;
            }
        }
    }

    private void setRolePermissions(boolean admin, Role role) {
        String contributorDisable = GlobalSettings.getString((String)"contributorDisable", (String)"");
        String managerDisable = GlobalSettings.getString((String)"managerDisable", (String)"");
        String managerEnable = GlobalSettings.getString((String)"managerEnable", (String)"");
        if (admin) {
            this.setAdminPermissions();
        } else if (role == Role.APPROVER || role == Role.MANAGER) {
            this.editURI = true;
            this.archiveURI = true;
            this.deleteURI = managerEnable.contains(DELETE_DOCUMENTS);
            this.setGroups = true;
            this.editXLinks = !contributorDisable.contains(EDIT_COMMENTS);
            this.archiveXLinks = !contributorDisable.contains(ARCHIVE_COMMENTS);
            this.deleteXLinks = managerEnable.contains(DELETE_COMMENTS);
            this.editAllXLinks = !managerDisable.contains(EDIT_COMMENTS);
            this.archiveAllXLinks = !managerDisable.contains(ARCHIVE_COMMENTS);
            this.deleteAllXLinks = managerEnable.contains(DELETE_COMMENTS);
            this.assignAllXLinks = true;
            if (role == Role.APPROVER) {
                this.approveAllXLinks = true;
            }
        } else if (role == Role.CONTRIBUTOR) {
            this.setGroups = true;
            this.archiveURI = this.editURI = !contributorDisable.contains(MANAGE_DOCUMENTS);
            this.editXLinks = !contributorDisable.contains(EDIT_COMMENTS);
            this.archiveXLinks = !contributorDisable.contains(ARCHIVE_COMMENTS);
            this.assignAllXLinks = true;
        }
    }

    private Role setURIStringPermissions(Role role, Collection<Group> grpc, boolean external) {
        this.viewURI = Groups.getGroupNames(grpc).contains("public");
        boolean uriApprover = false;
        boolean uriManager = false;
        boolean uriContributor = false;
        if (this.memberid != null) {
            for (Group uriGroup : grpc) {
                String name = uriGroup.getName();
                if (!uriApprover) {
                    uriApprover = MemberRule.isContributorForGroupNameFlag(this.userDetails.flags(), name, "a");
                }
                if (!uriManager) {
                    uriManager = MemberRule.isContributorForGroupNameFlag(this.userDetails.flags(), name, "e");
                }
                if (uriContributor) continue;
                uriContributor = MemberRule.isContributorForGroupNameFlag(this.userDetails.flags(), name, "c");
            }
        }
        role = this.restrictRole(role, uriApprover, uriManager, uriContributor);
        if (external) {
            this.editXLinks = true;
            this.archiveXLinks = true;
            this.editAllXLinks = true;
            this.archiveAllXLinks = true;
        }
        return role;
    }

    private Role setURIPermissions(Database db, URI uri, Role role, Collection<Group> grpc, boolean external) throws DatabaseException {
        this.viewURI = Groups.getGroupNames(grpc).contains("public");
        if (this.viewURI) {
            this.cacheGroupURIs(db, GroupRule.getPublicGroup(db), uri);
        }
        if (external) {
            this.editXLinks = true;
            this.archiveXLinks = true;
            this.editAllXLinks = true;
            this.archiveAllXLinks = true;
            if (role == Role.APPROVER) {
                this.addEditXLinks = true;
                this.approveAllXLinks = true;
            } else if (role == Role.CONTRIBUTOR) {
                this.addEditXLinks = true;
            }
        }
        boolean uriApprover = false;
        boolean uriManager = false;
        boolean uriContributor = false;
        if (this.memberid != null) {
            if (this.groupName == null || role == Role.APPROVER) {
                uriApprover = MemberRule.isContributorForURIIdFlag(db, this.userDetails.flags(), uri.getId(), "a");
            }
            if (this.groupName == null || role == Role.MANAGER) {
                uriManager = MemberRule.isContributorForURIIdFlag(db, this.userDetails.flags(), uri.getId(), "e");
            }
            if (this.groupName == null || role == Role.CONTRIBUTOR) {
                uriContributor = MemberRule.isContributorForURIIdFlag(db, this.userDetails.flags(), uri.getId(), "c");
            }
        }
        role = this.restrictRole(role, uriApprover, uriManager, uriContributor);
        return role;
    }

    private Role restrictRole(Role role, boolean uriApprover, boolean uriManager, boolean uriContributor) {
        Role managerRole;
        Role contributorRole = uriContributor ? Role.CONTRIBUTOR : null;
        Role role2 = managerRole = uriManager ? Role.MANAGER : contributorRole;
        if (this.groupName == null || role == Role.APPROVER) {
            role = uriApprover ? Role.APPROVER : managerRole;
        } else if (role == Role.MANAGER) {
            role = managerRole;
        } else if (role == Role.CONTRIBUTOR) {
            role = contributorRole;
        }
        return role;
    }

    private void restrictPermissionsByScope(Database db, boolean admin, Collection<Group> grpc, boolean external) throws PermissionException, DatabaseException {
        boolean editURL;
        Group templateProject;
        if (this.scopes == null || this.scopes.contains(Scope.ALL)) {
            return;
        }
        if (admin && this.scopes.contains(Scope.ADMIN)) {
            return;
        }
        String managerEnable = GlobalSettings.getString((String)"managerEnable", (String)"");
        Group currentGroup = null;
        boolean configureProject = false;
        if (this.groupName != null && (templateProject = GroupRule.getTemplateProject(db, currentGroup = this.getCurrentGroup(db))) != null) {
            String flags = this.userDetails.getFlags(templateProject.getName());
            configureProject = flags != null && !flags.contains("i") ? this.configProject && this.scopes.contains(Scope.PROJECT_MANAGER) : this.configProject && this.scopes.contains(Scope.SERVER_PROJECT_MANAGER);
        }
        boolean contributor = this.scopesContain(Scope.CONTRIBUTOR, Scope.MANAGER, Scope.APPROVER) || admin && this.scopesContain(Scope.SERVER_CONTRIBUTOR, Scope.SERVER_MANAGER, Scope.SERVER_APPROVER);
        boolean addURL = this.addURLs && contributor;
        boolean bl = editURL = this.editAllURLs && contributor;
        if (currentGroup != null && GroupRule.isProject(currentGroup)) {
            String flags = this.userDetails.getFlags(currentGroup.getName());
            boolean serverProject = flags == null || flags.contains("i");
            boolean view = this.viewGroup;
            if (serverProject && !admin) {
                this.resetPermissions();
                this.viewGroup = view;
            } else if (!this.scopesContain(Scope.PROJECT_MANAGER, serverProject)) {
                if (this.scopesContain(Scope.PROJECT_CONTRIBUTOR, serverProject)) {
                    this.editGroup = false;
                    this.archiveGroup = false;
                    this.deleteGroup = false;
                } else {
                    this.resetPermissions();
                    if (flags != null || admin && this.scopes.contains(Scope.PROJECT_CREATOR)) {
                        this.viewGroup = view;
                    }
                }
            }
            this.configProject = configureProject;
            this.addURLs = addURL;
            this.editAllURLs = editURL;
            this.restrictAdminPermissions(admin);
            return;
        }
        boolean serverGroup = true;
        boolean publicUri = false;
        boolean publicComments = false;
        for (Group grp : grpc) {
            String flags = this.userDetails.getFlags(grp.getName());
            if (flags != null && !flags.contains("i")) {
                serverGroup = false;
            }
            if (grp.hasFlag('p') || GroupRule.isPublicGroup(grp.getName())) {
                publicUri = true;
            }
            if (!grp.hasFlag('a')) continue;
            publicComments = true;
        }
        if (serverGroup && !admin) {
            this.restrictToPublicOnly(currentGroup, publicUri, publicComments, external && grpc.isEmpty());
        } else if (!this.scopesContain(Scope.APPROVER, serverGroup)) {
            if (this.scopesContain(Scope.MANAGER, serverGroup)) {
                this.deleteGroup = false;
                this.deleteURI = this.deleteURI && managerEnable.contains(DELETE_DOCUMENTS);
                this.deleteXLinks = this.deleteXLinks && managerEnable.contains(DELETE_COMMENTS);
                this.approveAllXLinks = false;
                this.deleteAllXLinks = this.deleteAllXLinks && managerEnable.contains(DELETE_COMMENTS);
            } else if (this.scopesContain(Scope.CONTRIBUTOR, serverGroup)) {
                this.restrictPermissionsToContributor();
            } else if (this.scopesContain(Scope.REVIEWER, serverGroup)) {
                this.restrictPermissionsToReviewer();
            } else if (this.scopesContain(Scope.GUEST, serverGroup)) {
                this.addXLinks = false;
                this.viewMembers = false;
                this.assignAllXLinks = false;
                this.addWorkflowXLinks = false;
                this.restrictPermissionsToReviewer();
            } else {
                this.restrictToPublicOnly(currentGroup, publicUri, publicComments, external && grpc.isEmpty());
            }
        }
        this.configProject = configureProject;
        this.addURLs = addURL;
        this.editAllURLs = editURL;
        this.restrictAdminPermissions(admin);
    }

    private void restrictAdminPermissions(boolean admin) {
        if (admin) {
            this.adminDatabase = false;
            this.adminSystem = false;
            this.createProject = this.scopes.contains(Scope.PROJECT_CREATOR);
            this.develop = this.scopes.contains(Scope.DEVELOPER);
            this.manageAccount = this.scopes.contains(Scope.ACCOUNT_MANAGER);
            this.manageOAuth = this.scopes.contains(Scope.OAUTH_MANAGER);
            this.manageWebhook = this.scopes.contains(Scope.WEBHOOK_MANAGER);
        }
    }

    private void restrictPermissionsToReviewer() {
        String reviewerEnable = GlobalSettings.getString((String)"reviewerEnable", (String)"");
        this.editURI = false;
        this.archiveURI = false;
        this.addEditXLinks = false;
        this.setGroups = false;
        this.editXLinks = false;
        this.archiveXLinks = false;
        if (!reviewerEnable.contains(SAVE_RELEASE) && !reviewerEnable.contains(CREATE_WORKFLOW)) {
            this.addWorkflowXLinks = false;
        }
        this.restrictPermissionsToContributor();
    }

    private void restrictPermissionsToContributor() {
        this.editGroup = false;
        this.archiveGroup = false;
        this.deleteGroup = false;
        this.deleteURI = false;
        this.deleteXLinks = false;
        this.editAllXLinks = false;
        this.approveAllXLinks = false;
        this.archiveAllXLinks = false;
        this.deleteAllXLinks = false;
    }

    private void restrictToPublicOnly(@Nullable Group currentGroup, boolean publicUri, boolean publicComments, boolean external) {
        this.resetPermissions();
        if (currentGroup != null) {
            this.viewGroup = currentGroup.hasFlag('p');
        }
        this.viewURI = publicUri || external && this.memberid != null;
        this.addXLinks = publicComments;
    }

    private boolean scopesContain(Scope ... scope) {
        for (Scope s : scope) {
            if (!this.scopes.contains(s)) continue;
            return true;
        }
        return false;
    }

    private boolean scopesContain(Scope scope, boolean server) {
        if (server) {
            scope = Scope.fromString((String)("server-" + String.valueOf(scope)));
        }
        return this.scopes.contains(scope);
    }

    private Role setGroupPermissions(Database db, Collection<Group> grpc) throws PermissionException, DatabaseException {
        Role role = null;
        Group grp = this.getCurrentGroup(db);
        this.viewGroup = grp.hasFlag('p');
        if (this.memberid != null) {
            String flags = this.userDetails.getFlags(this.groupName);
            this.viewURI = flags != null;
            boolean bl = this.viewMembers = flags != null && flags.indexOf(103) == -1;
            if (!this.viewGroup) {
                boolean bl2 = this.viewGroup = flags != null;
            }
            if (MemberRule.isContributorForGroupNameFlag(this.userDetails.flags(), this.groupName, "a")) {
                role = Role.APPROVER;
            } else if (MemberRule.isContributorForGroupNameFlag(this.userDetails.flags(), this.groupName, "e")) {
                role = Role.MANAGER;
            } else if (MemberRule.isContributorForGroupNameFlag(this.userDetails.flags(), this.groupName, "c")) {
                role = Role.CONTRIBUTOR;
            }
        }
        grpc.add(grp);
        if (role == Role.APPROVER || role == Role.MANAGER) {
            this.editGroup = true;
            this.archiveGroup = true;
        }
        this.addXLinks = !MemberRule.removeNonCommentGroups(grpc, this.userDetails.flags()).isEmpty();
        Group templateProj = GroupRule.getTemplateProject(db, grp);
        if (templateProj != null && GroupRule.isProject(templateProj) && MemberRule.isContributorForGroupNameFlag(this.userDetails.flags(), templateProj.getName(), "e")) {
            this.configProject = true;
        }
        return role;
    }

    private Group getCurrentGroup(Database db) throws QueryFailedException, PermissionException {
        Group grp = DatabaseQuery.getGroupByName((Database)db, (String)this.groupName);
        if (grp == null) {
            throw new PermissionException("Group not found: " + this.groupName);
        }
        return grp;
    }

    private boolean loadUserDetailsFromOAuth(Database db, @Nullable URI uri) throws QueryFailedException, PermissionException {
        HttpServletRequest request = this.req;
        if (request == null) {
            return false;
        }
        String header = request.getHeader("Authorization");
        if (Strings.isEmpty((String)header)) {
            return false;
        }
        String method = HTTP.getAuthScheme((String)header);
        if (!"Bearer".equals(method)) {
            return false;
        }
        String code = HTTP.getBearerToken((String)header);
        if (Strings.isEmpty((String)code)) {
            return false;
        }
        AccessTokenManager manager = AccessTokenManager.singleton();
        AccessToken token = manager.get(code);
        if (token == null || token.hasExpired()) {
            return false;
        }
        Long memid = token.getMemberId();
        Member mem = DatabaseQuery.getMemberById((Database)db, (Long)memid);
        if (!MemberRule.isMemberActivated(mem) || MemberRule.isMemberDisabled(mem)) {
            return false;
        }
        HttpSession session = request.getSession(false);
        if (session != null && SecurityUtils.getSessionMemberId(session) != null) {
            session.invalidate();
        }
        this.memberid = memid;
        UserDetailsManager userManager = new UserDetailsManager();
        this.userDetails = userManager.get(db, memid, this.groupName != null && this.groupName.startsWith("archive-") || URIRule.isArchivedGroup(uri));
        this.scopes = Scope.fromDelimitedString((String)token.scope());
        request.setAttribute("ps-token", (Object)code);
        request.setAttribute("ps-memberid", (Object)memid);
        request.setAttribute("ps-username", (Object)mem.getUsername());
        return true;
    }

    private boolean loadUserDetailsFromSession(Database db, @Nullable URI uri) throws DatabaseException, PermissionException {
        Member mem;
        HttpServletRequest request = this.req;
        if (request == null) {
            return true;
        }
        HttpSession session = request.getSession(true);
        if (SecurityUtils.getSessionMemberId(session) == null) {
            String[] cred = this.getAutoLoginUsernamePassword();
            if (cred[0] == null && cred[1] == null && this.res != null) {
                SecurityUtils.RememberMe result = SecurityUtils.checkRememberMeCookie(db, this.req, this.res);
                if (result != null) {
                    SecurityLog.setupUser(result.member);
                    if (!CSRF.validateOriginReferer(this.req, db)) {
                        this.status = Status.OTHER;
                        return false;
                    }
                    SecurityUtils.login(db, result.member.getUsername(), this.req);
                    session = request.getSession();
                    result.token.delete(db);
                    Transaction tr = new Transaction(db);
                    if (tr != null) {
                        tr.commitAndStart();
                    }
                }
            } else if (cred.length == 2 && cred[0] != null && cred[1] != null) {
                boolean valid;
                try {
                    valid = SecurityUtils.checkPassword(db, cred, SecurityUtils.getRemoteIP(request));
                }
                catch (LockedAccountException ex) {
                    this.status = Status.OTHER;
                    this.statusMessage = "Account " + ex.getLockedUsername() + " has been locked due to incorrect logins, please try again later.";
                    return false;
                }
                if (valid) {
                    mem = DatabaseQuery.getMemberByUsername((Database)db, (String)cred[0]);
                    if (mem != null) {
                        SecurityLog.setupUser(mem);
                    }
                    if (MemberRule.isMemberActivated(mem) && !MemberRule.isMemberDisabled(mem)) {
                        try {
                            if (WebUtilities.deprecatedError(this.req, this.res, "with login")) {
                                this.status = Status.OTHER;
                                return false;
                            }
                        }
                        catch (IOException e) {
                            throw new PermissionException(e);
                        }
                        if (!CSRF.validateOriginReferer(this.req, db)) {
                            this.status = Status.OTHER;
                            return false;
                        }
                        SecurityUtils.login(db, cred[0], this.req);
                        session = request.getSession();
                    }
                }
            }
        }
        boolean archived = this.groupName != null && this.groupName.startsWith("archive-") || URIRule.isArchivedGroup(uri) || SecurityUtils.getArchivedGroups(session);
        this.memberid = SecurityUtils.getSessionMemberId(session);
        UserDetailsManager userManager = new UserDetailsManager();
        this.userDetails = userManager.get(this.memberid, archived);
        if (this.userDetails == null) {
            mem = DatabaseQuery.getMemberById((Database)db, (Long)this.memberid);
            if (MemberRule.isMemberDisabled(mem)) {
                SecurityUtils.logout(db, this.req, this.res);
                this.memberid = null;
                this.status = Status.OTHER;
                return false;
            }
            this.userDetails = userManager.get(db, this.memberid, archived);
        }
        request.setAttribute("ps-memberid", (Object)this.memberid);
        request.setAttribute("ps-username", session.getAttribute("ps-username"));
        return true;
    }

    private boolean isNotUsersPersonalGroup(Database db, String group) throws QueryFailedException {
        boolean result = false;
        if (GroupRule.isPersonalGroup(group)) {
            result = true;
            try {
                String[] gnames = Strings.split((String)group, (char)'-');
                Long personalid = Long.valueOf(gnames[1]);
                Member mem = null;
                if (this.memberid != null) {
                    mem = DatabaseQuery.getMemberById((Database)db, (Long)this.memberid);
                }
                if (mem != null && mem.getId().equals(personalid)) {
                    result = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    private void setAdminPermissions() {
        String adminEnable = GlobalSettings.getString((String)"adminEnable", (String)"");
        this.adminDatabase = adminEnable.contains("admin-database");
        this.adminSystem = true;
        this.createProject = true;
        this.develop = true;
        this.manageAccount = true;
        this.manageOAuth = true;
        this.manageWebhook = true;
        this.editAllURLs = true;
        this.viewGroup = true;
        this.editGroup = true;
        this.archiveGroup = true;
        this.deleteGroup = true;
        this.configProject = true;
        this.viewMembers = true;
        this.viewURI = true;
        this.editURI = true;
        this.archiveURI = true;
        this.deleteURI = adminEnable.contains(DELETE_DOCUMENTS);
        this.addURLs = true;
        this.addXLinks = true;
        this.addEditXLinks = true;
        this.addWorkflowXLinks = true;
        this.setGroups = true;
        this.editXLinks = true;
        this.archiveXLinks = true;
        this.deleteXLinks = adminEnable.contains(DELETE_COMMENTS);
        this.editAllXLinks = true;
        this.approveAllXLinks = true;
        this.assignAllXLinks = true;
        this.archiveAllXLinks = true;
        this.deleteAllXLinks = adminEnable.contains(DELETE_COMMENTS);
    }

    public void reset() {
        this.status = Status.UNDEFINED;
        this.statusMessage = null;
        this.uriString = null;
        this.uriId = null;
        this.xLinkId = null;
        this.xLinkGroupNames = null;
        this.groupName = null;
        this.externalUserEmail = null;
        this.externalUserFullName = null;
        this.externalUserId = null;
        this.addGroups = new ArrayList<String>();
        this.displayGroups = new ArrayList<String>();
        this.resetPermissions();
    }

    public void resetPermissions() {
        this.adminDatabase = false;
        this.adminSystem = false;
        this.createProject = false;
        this.develop = false;
        this.manageAccount = false;
        this.manageOAuth = false;
        this.manageWebhook = false;
        this.editAllURLs = false;
        this.viewGroup = false;
        this.editGroup = false;
        this.configProject = false;
        this.archiveGroup = false;
        this.deleteGroup = false;
        this.viewMembers = false;
        this.viewURI = false;
        this.editURI = false;
        this.archiveURI = false;
        this.deleteURI = false;
        this.addURLs = false;
        this.addXLinks = false;
        this.addEditXLinks = false;
        this.addWorkflowXLinks = false;
        this.setGroups = false;
        this.editXLinks = false;
        this.archiveXLinks = false;
        this.deleteXLinks = false;
        this.editAllXLinks = false;
        this.approveAllXLinks = false;
        this.archiveAllXLinks = false;
        this.assignAllXLinks = false;
        this.deleteAllXLinks = false;
    }

    public boolean getAuthenticate() {
        return this.authenticate;
    }

    public void setAuthenticate(boolean auth) {
        this.authenticate = auth;
    }

    public @Nullable HttpServletRequest getRequest() {
        return this.req;
    }

    public @Nullable Long getUriId() {
        return this.uriId;
    }

    public @Nullable Long getGroupUriId() {
        return this.guriId;
    }

    public @Nullable String getUriString() {
        return this.uriString;
    }

    public @Nullable Boolean getIsFolder() {
        return this.isFolder;
    }

    public @Nullable Long getXLinkId() {
        return this.xLinkId;
    }

    public @Nullable String getGroupName() {
        return this.groupName;
    }

    public void setUriId(Long id) {
        this.uriId = id;
    }

    public void setGroupUriId(Long grpId) {
        this.guriId = grpId;
    }

    public void setUriString(String string) {
        this.uriString = string;
    }

    public void setIsFolder(Boolean bool) {
        this.isFolder = bool;
    }

    public void setXLinkId(Long id) {
        this.xLinkId = id;
    }

    public void setGroupName(String name) {
        this.groupName = name;
    }

    public void setRequest(HttpServletRequest req) {
        this.req = req;
    }

    public void setResponse(HttpServletResponse res) {
        this.res = res;
    }

    public @Nullable Set<String> getXLinkGroupNames() {
        return this.xLinkGroupNames;
    }

    public void setXLinkGroupNames(Set<String> set) {
        this.xLinkGroupNames = set;
    }

    public static enum Status {
        UNDEFINED,
        SUCCESS,
        ERROR,
        OTHER,
        RESPONSE_RETURNED;

    }
}

