/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.permission;

import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import org.slf4j.LoggerFactory;

public final class ArchiveXLinkCheck
extends PermissionCheck {
    public ArchiveXLinkCheck(Group group, URI u, XLink xl) {
        this.grp = group;
        this.uri = u;
        this.xl = xl;
    }

    public ArchiveXLinkCheck(URI u, XLink xl) {
        this.uri = u;
        this.xl = xl;
    }

    @Override
    public boolean hasAccess(Database db, Permissions perm) {
        if (perm.getArchiveAllXLinks().booleanValue()) {
            return true;
        }
        boolean access = false;
        try {
            Long memberid = perm.getMemberId();
            Member mem = null;
            if (memberid != null && (mem = DatabaseQuery.getMemberById((Database)db, (Long)memberid)) == null) {
                throw new DatabaseException("Member not found with ID: " + memberid);
            }
            access = (perm.getArchiveXLinks() != false || this.xl.getAuthorOnly() != false || "Documentation-Draft".equals(this.xl.getStatus()) && this.xl.getContentRole().startsWith("Documentation")) && (mem != null && this.xl.getMember() == mem || perm.getExternalUserId() != null && perm.getExternalUserId().equals(this.xl.getExternalUserId()));
        }
        catch (DatabaseException ex) {
            LoggerFactory.getLogger(ArchiveXLinkCheck.class).error("Unable to perform check", (Throwable)ex);
        }
        return access;
    }
}

