/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.permission;

import com.pageseeder.base.GroupProperties;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.db.Database;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public final class AddWorkflowCheck
extends PermissionCheck {
    private final List<String> statuses = new ArrayList<String>();

    public AddWorkflowCheck(Group group, URI uri) {
        this.grp = group;
        this.uri = uri;
    }

    public AddWorkflowCheck(Group group, URI uri, List<String> thestatuses) {
        this.grp = group;
        this.uri = uri;
        if (thestatuses != null) {
            this.statuses.addAll(thestatuses);
        }
    }

    @Override
    public boolean hasAccess(Database db, Permissions perm) {
        Properties groupProperties;
        if (!perm.getAddWorkflowXLinks().booleanValue()) {
            return false;
        }
        if (this.statuses.isEmpty()) {
            return true;
        }
        try {
            groupProperties = GroupProperties.get(db, this.grp);
        }
        catch (QueryFailedException | IOException e) {
            return false;
        }
        String propertyName = this.getPropertyName(perm);
        String propertyValue = groupProperties.getProperty(propertyName, "");
        List<String> allowedStatuses = Arrays.asList(propertyValue.split(","));
        for (String s : this.statuses) {
            if (allowedStatuses.contains(s)) continue;
            return false;
        }
        return true;
    }

    private String getPropertyName(Permissions perm) {
        if (Boolean.TRUE.equals(perm.getApproveAllXLinks())) {
            return "documentStatusApprover";
        }
        if (Boolean.TRUE.equals(perm.getEditAllXLinks())) {
            return "documentStatusManager";
        }
        if (Boolean.TRUE.equals(perm.getSetGroups())) {
            return "documentStatusContributor";
        }
        return "documentStatusReviewer";
    }
}

