/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.organization;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public final class SecurityConfig {
    private final List<String> loginGroups;
    private final List<String> loginProjects;
    private final Map<TokenType, Duration> tokenExpiration;
    private final List<String> emailDomains;

    public List<String> getLoginGroups() {
        return Collections.unmodifiableList(this.loginGroups);
    }

    public List<String> getLoginProjects() {
        return Collections.unmodifiableList(this.loginProjects);
    }

    public Map<TokenType, Duration> getTokenExpirations() {
        return Collections.unmodifiableMap(this.tokenExpiration);
    }

    public @Nullable Duration getTokenExpiration(TokenType type) {
        return this.tokenExpiration.get((Object)type);
    }

    public List<String> getEmailDomains() {
        return Collections.unmodifiableList(this.emailDomains);
    }

    private SecurityConfig(List<String> loginGroups, List<String> loginProjects, Map<TokenType, Duration> tokenDurations, List<String> emailDomains) {
        this.loginGroups = loginGroups;
        this.loginProjects = loginProjects;
        this.tokenExpiration = tokenDurations;
        this.emailDomains = emailDomains;
    }

    public static final class Builder {
        private final List<String> loginGroups = new ArrayList<String>();
        private final List<String> loginProjects = new ArrayList<String>();
        private final Map<TokenType, Duration> tokenExpiration = new HashMap<TokenType, Duration>();
        private final List<String> emailDomains = new ArrayList<String>();

        public void addLoginGroup(String groupName) {
            this.loginGroups.add(groupName);
        }

        public void addLoginProject(String projectName) {
            this.loginProjects.add(projectName);
        }

        public void putTokenExpiration(TokenType type, Duration expiration) {
            this.tokenExpiration.put(type, expiration);
        }

        public void addEmailDomain(String domain) {
            this.emailDomains.add(domain.toLowerCase());
        }

        public SecurityConfig build() {
            return new SecurityConfig(this.loginGroups, this.loginProjects, this.tokenExpiration, this.emailDomains);
        }
    }

    public static enum TokenType {
        ACTIVATE_MEMBER,
        CHANGE_EMAIL,
        REMEMBER_ME,
        RESET_PASSWORD,
        UNKNOWN;


        public static TokenType fromString(String value) {
            if ("activate-member".equalsIgnoreCase(value)) {
                return ACTIVATE_MEMBER;
            }
            if ("change-email".equalsIgnoreCase(value)) {
                return CHANGE_EMAIL;
            }
            if ("remember-me".equalsIgnoreCase(value)) {
                return REMEMBER_ME;
            }
            if ("reset-password".equalsIgnoreCase(value)) {
                return RESET_PASSWORD;
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.name().toLowerCase().replace('_', '-');
        }
    }
}

