/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.oauth.model;

import com.pageseeder.base.oauth.core.OAuthErrorType;
import com.pageseeder.base.oauth.core.OAuthException;
import com.pageseeder.base.oauth.model.Token;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.LoggerFactory;

final class MemoryTokenStorage<T extends Token> {
    private final Map<String, T> tokens;
    private final int maxCapacity;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private OffsetDateTime lastPurged = null;

    MemoryTokenStorage(int maxCapacity, long purgeFrequency, TimeUnit purgeUnit) {
        this.tokens = Collections.synchronizedMap(new LinkedHashMap());
        this.maxCapacity = maxCapacity;
        this.scheduler.scheduleAtFixedRate(new Scavenger(this), purgeFrequency * 2L, purgeFrequency, purgeUnit);
    }

    public void store(T token) throws OAuthException {
        if (this.tokens.size() >= this.maxCapacity) {
            throw OAuthException.error(OAuthErrorType.temporarily_unavailable, "Unable to store additional tokens");
        }
        this.tokens.put(token.token(), token);
    }

    public T get(String token) {
        return (T)((Token)this.tokens.get(token));
    }

    public T remove(String token) {
        return (T)((Token)this.tokens.remove(token));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable T remove(String start, String end, String clientId, long memberId) {
        if (start == null || end == null) {
            return null;
        }
        Map<String, T> map = this.tokens;
        synchronized (map) {
            Iterator<Map.Entry<String, T>> it = this.tokens.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, T> entry = it.next();
                Token t = (Token)entry.getValue();
                if (memberId != t.getMemberId() || !clientId.equals(t.getClientId()) || !t.token().startsWith(start) || !t.token().endsWith(end)) continue;
                it.remove();
                return (T)t;
            }
        }
        return null;
    }

    public int size() {
        return this.tokens.size();
    }

    public Collection<T> tokens() {
        return this.tokens.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> tokens(int from, int to) {
        Map<String, T> map = this.tokens;
        synchronized (map) {
            return this.tokens.values().stream().skip(from).limit((long)to - (long)from).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeForClient(String clientId) {
        int[] count = new int[]{0};
        Map<String, T> map = this.tokens;
        synchronized (map) {
            this.tokens.values().removeIf(t -> {
                boolean match = clientId.equals(t.getClientId());
                if (match) {
                    count[0] = count[0] + 1;
                }
                return match;
            });
        }
        return count[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeForMember(long memberId) {
        int[] count = new int[]{0};
        Map<String, T> map = this.tokens;
        synchronized (map) {
            this.tokens.values().removeIf(t -> {
                boolean match;
                boolean bl = match = memberId == t.getMemberId();
                if (match) {
                    count[0] = count[0] + 1;
                }
                return match;
            });
        }
        return count[0];
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int purge() {
        int[] count = new int[]{0};
        OffsetDateTime now = OffsetDateTime.now();
        Map<String, T> map = this.tokens;
        synchronized (map) {
            this.tokens.values().removeIf(t -> {
                boolean match = t.hasExpiredAt(now);
                if (match) {
                    count[0] = count[0] + 1;
                }
                return match;
            });
        }
        this.lastPurged = now;
        return count[0];
    }

    public @Nullable OffsetDateTime getLastPurged() {
        return this.lastPurged;
    }

    public int removeAll() {
        int count = this.tokens.size();
        this.tokens.clear();
        return count;
    }

    public void destroy() {
        this.scheduler.shutdown();
    }

    private class Scavenger
    implements Runnable {
        private final MemoryTokenStorage<T> manager;

        Scavenger(MemoryTokenStorage<T> manager) {
            this.manager = manager;
        }

        @Override
        public void run() {
            try {
                this.manager.purge();
            }
            catch (RuntimeException ex) {
                LoggerFactory.getLogger(this.getClass()).error("Unable to purge expired tokens", (Throwable)ex);
            }
        }
    }
}

