/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.oauth.model;

import com.pageseeder.base.oauth.model.Token;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.db.oauth.Scope;
import java.io.Serializable;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.pageseeder.xmlwriter.XMLWriter;

public final class AuthorizationCode
implements Token,
Serializable {
    private static final long serialVersionUID = 20160405L;
    private static final long TEN_MINUTES_IN_MILLIS = 600000L;
    private static final DateTimeFormatter ISO8601_DATETIME = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss[xxx]");
    private final String _code;
    private final String _clientId;
    private final String _scope;
    private final String _redirectURI;
    private final long _memberId;
    private final OffsetDateTime _issued;

    protected AuthorizationCode(String code, String clientId, String redirectURI, long memberId, String scope) {
        this._code = Objects.requireNonNull(code);
        this._clientId = Objects.requireNonNull(clientId);
        this._redirectURI = Objects.requireNonNull(redirectURI);
        this._memberId = memberId;
        this._issued = OffsetDateTime.now();
        this._scope = scope;
    }

    public String code() {
        return this._code;
    }

    @Override
    public String token() {
        return this._code;
    }

    @Override
    public String getClientId() {
        return this._clientId;
    }

    @Override
    public OffsetDateTime issuedAt() {
        return this._issued;
    }

    @Override
    public long maxAge(TimeUnit unit) {
        return unit.convert(600000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public String scope() {
        return this._scope;
    }

    public Set<Scope> getScopes() {
        return Scope.fromDelimitedString((String)this._scope);
    }

    public String getRedirectURI() {
        return this._redirectURI;
    }

    @Override
    public long getMemberId() {
        return this._memberId;
    }

    public boolean match(String clientId, String redirectURI) {
        return this._clientId.equals(clientId) && this._redirectURI.equals(redirectURI);
    }

    @Override
    public boolean hasExpired() {
        return System.currentTimeMillis() - this._issued.toInstant().toEpochMilli() > 600000L;
    }

    public boolean expiresBefore(long time) {
        return this._issued.plus(600000L, ChronoUnit.MILLIS).toInstant().isBefore(Instant.ofEpochMilli(time));
    }

    @Override
    public boolean hasExpiredAt(OffsetDateTime time) {
        return this._issued.plus(600000L, ChronoUnit.MILLIS).isBefore(OffsetDateTime.now());
    }

    @Override
    public OffsetDateTime expires() {
        return this._issued.plus(600000L, ChronoUnit.MILLIS);
    }

    public String toString() {
        return this._clientId + "/" + this._redirectURI + "/" + this._memberId + "/" + String.valueOf(this._issued);
    }

    @Deprecated
    public void toXML(XMLWriter xml) {
        this.print(new XMLOutputPrinter(xml));
    }

    @Override
    public void print(OutputPrinter out) {
        out.startObject("authorization-code");
        out.field("code", this._code);
        out.field("client-id", this._clientId);
        out.field("member-id", this._memberId);
        out.field("scope", this._scope);
        out.field("redirect-uri", this._redirectURI);
        out.field("issued", this._issued.format(ISO8601_DATETIME));
        out.field("expires", this._issued.plus(600000L, ChronoUnit.MILLIS).format(ISO8601_DATETIME));
        out.endObject();
    }
}

