/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.oauth.jwt;

public class JWToken {
    private final String _token;
    private final transient String[] _segments;

    public JWToken(String token) {
        if (token == null) {
            throw new IllegalArgumentException("Invalid token");
        }
        this._token = token;
        this._segments = token.split("\\.", -1);
        if (this._segments.length != 3) {
            throw new IllegalArgumentException("Invalid token");
        }
    }

    public final String token() {
        return this._token;
    }

    public final String header() {
        return this._segments[0];
    }

    public final String payload() {
        return this._segments[1];
    }

    public final String signature() {
        return this._segments[2];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._token == null ? 0 : this._token.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JWToken other = (JWToken)obj;
        return !(this._token == null ? other._token != null : !this._token.equals(other._token));
    }

    public String toString() {
        return this._token;
    }
}

