/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.oauth.jwt;

import com.pageseeder.base.oauth.jwt.JWTAlgorithm;
import com.pageseeder.base.oauth.jwt.JWTClaim;
import com.pageseeder.base.oauth.jwt.JWTClaimSet;
import com.pageseeder.base.oauth.jwt.JWTException;
import com.pageseeder.base.oauth.jwt.JWTSigner;
import com.pageseeder.common.util.BinaryFormat;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;

public final class JWTVerifier {
    private final byte[] key;
    private final String audience;
    private final String issuer;

    public JWTVerifier(byte[] key, String audience, String issuer) {
        if (key == null || key.length == 0) {
            throw new IllegalArgumentException("key cannot be null or empty");
        }
        this.key = key;
        this.audience = audience;
        this.issuer = issuer;
    }

    public JWTVerifier(byte[] key, String audience) {
        this(key, audience, null);
    }

    public JWTVerifier(byte[] key) {
        this(key, null, null);
    }

    public JWTClaimSet verify(String token) throws JWTException {
        if (token == null) {
            throw new NullPointerException("Token was not specified");
        }
        String[] segments = token.split("\\.", -1);
        if (segments.length != 3) {
            throw new IllegalStateException("Wrong number of segments: " + segments.length);
        }
        JWTAlgorithm algorithm = JWTVerifier.getAlgorithm(segments[0]);
        JWTClaimSet set = JWTVerifier.getPayload(segments[1]);
        this.verifySignature(segments, algorithm);
        if (set.hasExpired()) {
            throw new JWTException("The claim set has expired");
        }
        if (!set.matchValue(JWTClaim.Registered.iss, this.issuer)) {
            throw new JWTException("The claim set does not match the issuer.");
        }
        if (!set.matchValue(JWTClaim.Registered.aud, this.audience)) {
            throw new JWTException("The claim set does not match the audience.");
        }
        return set;
    }

    private void verifySignature(String[] segments, JWTAlgorithm algorithm) throws JWTException {
        String message = segments[0] + "." + segments[1];
        byte[] expected = BinaryFormat.BASE_64_URL.decode(segments[2]);
        byte[] signature = JWTSigner.sign(algorithm, message, this.key);
        if (!MessageDigest.isEqual(signature, expected)) {
            throw new JWTException("Signature verification failed");
        }
    }

    private static JWTClaimSet getPayload(String message) {
        JWTClaimSet set = null;
        try {
            String json = BinaryFormat.BASE_64_URL.decode(message, StandardCharsets.UTF_8);
            set = JWTClaimSet.parseJSON(json);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Illegal JWT payload:", ex);
        }
        return set;
    }

    private static JWTAlgorithm getAlgorithm(String header) {
        JWTAlgorithm algorithm = null;
        try {
            String json = BinaryFormat.BASE_64_URL.decode(header, StandardCharsets.UTF_8);
            try (JsonReader reader = Json.createReader((Reader)new StringReader(json));){
                JsonObject object = reader.readObject();
                String alg = object.getString("alg");
                algorithm = JWTAlgorithm.valueOf(alg);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Illegal JWT header:", ex);
        }
        return algorithm;
    }
}

