/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.oauth.jwt;

import com.pageseeder.base.oauth.jwt.JWTAlgorithm;
import com.pageseeder.base.oauth.jwt.JWTClaimSet;
import com.pageseeder.base.oauth.jwt.JWTException;
import com.pageseeder.common.util.BinaryFormat;
import jakarta.json.Json;
import jakarta.json.stream.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class JWTSigner {
    private final byte[] key;

    public JWTSigner(byte[] key) {
        this.key = key;
    }

    public String sign(JWTClaimSet claims, JWTAlgorithm algorithm) {
        ArrayList<String> segments = new ArrayList<String>();
        try {
            segments.add(this.encodedHeader(algorithm));
            segments.add(this.encodedPayload(claims));
            segments.add(this.encodedSignature(String.join((CharSequence)".", segments), algorithm));
        }
        catch (Exception ex) {
            throw ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException(ex);
        }
        return String.join((CharSequence)".", segments);
    }

    private String encodedHeader(JWTAlgorithm algorithm) {
        if (algorithm == null) {
            algorithm = JWTAlgorithm.HS256;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(32);
        try (JsonGenerator json = Json.createGenerator((OutputStream)out);){
            json.writeStartObject();
            if (algorithm != JWTAlgorithm.none) {
                json.write("typ", "JWT");
            }
            json.write("alg", algorithm.name());
            json.writeEnd();
            json.flush();
        }
        byte[] jose = out.toByteArray();
        return BinaryFormat.BASE_64_URL.encode(jose);
    }

    private String encodedPayload(JWTClaimSet claims) {
        String payload = claims.toJSON();
        return BinaryFormat.BASE_64_URL.encode(payload, StandardCharsets.UTF_8);
    }

    private String encodedSignature(String signingInput, JWTAlgorithm algorithm) throws JWTException {
        byte[] signature = JWTSigner.sign(algorithm, signingInput, this.key);
        return BinaryFormat.BASE_64_URL.encode(signature);
    }

    static byte[] sign(JWTAlgorithm algorithm, String message, byte[] key) throws JWTException {
        switch (algorithm) {
            case HS256: 
            case HS384: 
            case HS512: {
                return JWTSigner.signWithHMAC(algorithm, message, key);
            }
            case none: {
                return new byte[0];
            }
        }
        throw new JWTException("Unsupported signing method");
    }

    private static byte[] signWithHMAC(JWTAlgorithm algorithm, String message, byte[] key) throws JWTException {
        try {
            Mac mac = Mac.getInstance(algorithm.getJCAAlgorithm());
            mac.init(new SecretKeySpec(key, algorithm.getJCAAlgorithm()));
            return mac.doFinal(message.getBytes());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new JWTException("Unable to sign JWT", ex);
        }
    }
}

