/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.oauth.jwt;

public enum JWTAlgorithm {
    HS256("HmacSHA256", true),
    HS384("HmacSHA384", true),
    HS512("HmacSHA512", true),
    RS256("SHA256withRSA", false),
    RS384("SHA384withRSA", false),
    RS512("SHA512withRSA", false),
    ES256("SHA256withECDSA", false),
    ES384("SHA384withECDSA", false),
    ES512("SHA512withECDSA", false),
    PS256("SHA256withRSAandMGF1", false),
    PS384("SHA384withRSAandMGF1", false),
    PS512("SHA512withRSAandMGF1", false),
    none(null, true);

    private final String _algorithm;
    private final boolean _supported;

    private JWTAlgorithm(String algorithm, boolean supported) {
        this._algorithm = algorithm;
        this._supported = supported;
    }

    public String getJCAAlgorithm() {
        return this._algorithm;
    }

    public boolean isSupported() {
        return this._supported;
    }
}

