/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.oauth.core;

import com.pageseeder.base.oauth.core.OAuthErrorType;
import com.pageseeder.base.oauth.core.OAuthException;
import com.pageseeder.base.oauth.core.OAuthParameter;
import com.pageseeder.base.oauth.core.OAuthRequest;
import com.pageseeder.common.oauth.HTTP;
import com.pageseeder.common.util.Strings;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class OAuthRequestValidator {
    private final List<Constraint> _constraints = new ArrayList<Constraint>(4);

    public OAuthRequestValidator() {
    }

    public OAuthRequestValidator(Constraint constraint) {
        this._constraints.add(constraint);
    }

    public OAuthRequestValidator(List<Constraint> constraints) {
        this._constraints.addAll(constraints);
    }

    public static OAuthRequestValidator create() {
        return new OAuthRequestValidator();
    }

    public void validate(OAuthRequest req) throws OAuthException {
        try {
            for (Constraint c : this._constraints) {
                c.validate(req);
            }
        }
        catch (OAuthException ex) {
            String redirectUri = req.getParameter(OAuthParameter.redirect_uri);
            if (!Strings.isEmpty((String)redirectUri)) {
                ex.setRedirectURI(redirectUri);
            }
            throw ex;
        }
    }

    public OAuthRequestValidator requires(OAuthParameter ... required) {
        for (OAuthParameter name : required) {
            this._constraints.add(new RequiredParameter(name));
        }
        return this;
    }

    public OAuthRequestValidator matches(OAuthParameter parameter, String regex) {
        this._constraints.add(new ParameterRegexMatch(parameter, regex));
        return this;
    }

    public OAuthRequestValidator isAuthenticated() {
        this._constraints.add(new Authenticated());
        return this;
    }

    public OAuthRequestValidator acceptsMethod(String ... methods) {
        this._constraints.add(new AcceptedMethods(methods));
        return this;
    }

    public OAuthRequestValidator with(Class<? extends Constraint> kindOfConstraint) {
        ArrayList<Constraint> constraints = new ArrayList<Constraint>(this._constraints);
        try {
            Constraint constraint = kindOfConstraint.newInstance();
            constraints.add(constraint);
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new IllegalArgumentException(ex);
        }
        return new OAuthRequestValidator(constraints);
    }

    public static final class AcceptedMethods
    implements Constraint {
        private final String[] _accepted;

        public AcceptedMethods(String ... method) {
            this._accepted = method;
        }

        @Override
        public void validate(OAuthRequest req) throws OAuthException {
            String method = req.getMethod();
            for (String m : this._accepted) {
                if (!m.equals(method)) continue;
                return;
            }
            throw OAuthException.error(OAuthErrorType.invalid_request).description("Method not correct.");
        }
    }

    public static final class RequiresClientCredentials
    implements Constraint {
        @Override
        public void validate(OAuthRequest req) throws OAuthException {
            EnumSet<OAuthParameter> missingParameters = EnumSet.noneOf(OAuthParameter.class);
            String authorization = req.getAuthorizationHeader();
            HTTP.BasicCredentials credentials = HTTP.getBasicCredentials((String)authorization);
            if (credentials == null || Strings.isEmpty((String)credentials.username()) || Strings.isEmpty((String)credentials.password())) {
                if (Strings.isEmpty((String)req.getParameter(OAuthParameter.client_id))) {
                    missingParameters.add(OAuthParameter.client_id);
                }
                if (Strings.isEmpty((String)req.getParameter(OAuthParameter.client_secret))) {
                    missingParameters.add(OAuthParameter.client_secret);
                }
            }
            if (!missingParameters.isEmpty()) {
                throw OAuthException.handleMissingParameters(missingParameters);
            }
        }
    }

    public static final class ParameterRegexMatch
    implements Constraint {
        private final OAuthParameter _parameter;
        private final Pattern _pattern;

        public ParameterRegexMatch(OAuthParameter parameter, String regex) {
            if (parameter == null || regex == null) {
                throw new NullPointerException();
            }
            if (regex.length() == 0) {
                throw new IllegalArgumentException();
            }
            this._parameter = parameter;
            try {
                this._pattern = Pattern.compile(regex);
            }
            catch (PatternSyntaxException ex) {
                throw new IllegalArgumentException("Invalid pattern", ex);
            }
        }

        @Override
        public void validate(OAuthRequest req) throws OAuthException {
            String value = req.getParameter(this._parameter);
            if (value == null) {
                return;
            }
            if (!this._pattern.matcher(value).matches()) {
                // empty if block
            }
        }
    }

    public static final class RequiredContentType
    implements Constraint {
        private final String _required;

        public RequiredContentType(String required) {
            if (required == null) {
                throw new NullPointerException("required");
            }
            this._required = required;
        }

        @Override
        public void validate(OAuthRequest req) throws OAuthException {
            String contentType = req.getContentType();
            if (!this.hasContentType(contentType)) {
                String message = "Bad request content type. Expecting: " + this._required;
                throw OAuthException.error(OAuthErrorType.invalid_request).description(message);
            }
        }

        private boolean hasContentType(String contentType) {
            if (Strings.isEmpty((String)contentType)) {
                return false;
            }
            StringTokenizer tokenizer = new StringTokenizer(contentType, ";");
            while (tokenizer.hasMoreTokens()) {
                if (!this._required.equals(tokenizer.nextToken())) continue;
                return true;
            }
            return false;
        }
    }

    public static final class Authenticated
    implements Constraint {
        @Override
        public void validate(OAuthRequest req) throws OAuthException {
        }
    }

    public static final class RequiredParameter
    implements Constraint {
        private final OAuthParameter _parameter;

        public RequiredParameter(OAuthParameter parameter) {
            if (parameter == null) {
                throw new NullPointerException();
            }
            this._parameter = parameter;
        }

        @Override
        public void validate(OAuthRequest req) throws OAuthException {
            String value = req.getParameter(this._parameter);
            if (Strings.isEmpty((String)value)) {
                throw OAuthException.error(OAuthErrorType.invalid_request).description("Missing " + this._parameter.name() + " parameter value");
            }
        }
    }

    public static interface Constraint {
        public void validate(OAuthRequest var1) throws OAuthException;
    }
}

