/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.oauth.core;

import com.pageseeder.base.oauth.core.OAuthParameter;
import com.pageseeder.common.oauth.HTTP;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.oauth.Scope;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jdt.annotation.Nullable;

public abstract class OAuthRequest {
    private final HttpServletRequest request;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable HTTP.BasicCredentials credentials;

    protected OAuthRequest(HttpServletRequest request) {
        this.request = request;
        this.credentials = HTTP.getBasicCredentials((String)request.getHeader("Authorization"));
    }

    public String getParameter(OAuthParameter parameter) {
        return this.request.getParameter(parameter.name());
    }

    public String getAuthorizationHeader() {
        return this.request.getHeader(HTTP.Header.Authorization.toString());
    }

    public String getAuthScheme() {
        String header = this.getAuthorizationHeader();
        return HTTP.getAuthScheme((String)header);
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public Set<Scope> getScopes() {
        return Scope.fromDelimitedString((String)this.getParameter(OAuthParameter.scope));
    }

    public String getRedirectURI() {
        return this.getParameter(OAuthParameter.redirect_uri);
    }

    public String getClientId() {
        if (this.credentials != null) {
            return this.credentials.username();
        }
        return this.getParameter(OAuthParameter.client_id);
    }

    public String getClientSecret() {
        if (this.credentials != null) {
            return this.credentials.password();
        }
        return this.getParameter(OAuthParameter.client_secret);
    }

    private static Set<String> decodeScopes(String s) {
        HashSet<String> scopes = new HashSet<String>();
        if (!Strings.isEmpty((String)s)) {
            StringTokenizer tokenizer = new StringTokenizer(s, " ");
            while (tokenizer.hasMoreElements()) {
                scopes.add(tokenizer.nextToken());
            }
        }
        return scopes;
    }
}

