/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mfa.totp;

import com.pageseeder.base.mfa.core.Challenge;
import com.pageseeder.base.mfa.core.ChallengeIssuer;
import com.pageseeder.base.mfa.core.ChallengeManager;
import com.pageseeder.base.mfa.core.ChallengeRequest;
import com.pageseeder.base.mfa.core.ChallengeResult;
import com.pageseeder.base.mfa.core.ChallengeVerifier;
import com.pageseeder.base.mfa.core.MaxCapacityException;
import com.pageseeder.base.mfa.totp.TOTP;
import com.pageseeder.base.mfa.totp.TOTPOptions;
import com.pageseeder.db.model.Authenticator;
import com.pageseeder.db.model.Member;

public final class TOTPVerifier
implements ChallengeIssuer,
ChallengeVerifier {
    @Override
    public ChallengeRequest issueChallenge(Authenticator authenticator, Member member) {
        try {
            ChallengeManager manager = ChallengeManager.singleton();
            if (manager.hasReachedRateLimit(authenticator)) {
                return ChallengeRequest.rateLimitReached();
            }
            int digits = TOTP.getDigits(authenticator);
            Challenge challenge = manager.newChallenge(authenticator, 20, new TOTPOptions(digits));
            return ChallengeRequest.ready(challenge);
        }
        catch (MaxCapacityException ex) {
            return ChallengeRequest.error();
        }
    }

    @Override
    public ChallengeResult verifyChallenge(Authenticator authenticator, Challenge challenge, String code) {
        String algorithm;
        String secret = TOTP.getSecret(authenticator);
        ChallengeResult result = TOTP.checkCode(secret, code, algorithm = TOTP.getAlgorithm(authenticator), 1);
        if (result == ChallengeResult.SUCCESS) {
            ChallengeManager.singleton().invalidate(challenge.getId());
        }
        return result;
    }
}

