/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mfa.sms;

import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.mfa.core.Challenge;
import com.pageseeder.base.mfa.core.ChallengeIssuer;
import com.pageseeder.base.mfa.core.ChallengeManager;
import com.pageseeder.base.mfa.core.ChallengeRequest;
import com.pageseeder.base.mfa.core.ChallengeResult;
import com.pageseeder.base.mfa.core.ChallengeVerifier;
import com.pageseeder.base.mfa.core.MaxCapacityException;
import com.pageseeder.base.mfa.core.VerificationCode;
import com.pageseeder.base.mfa.sms.InvalidPhoneNumber;
import com.pageseeder.base.mfa.sms.PhoneNumber;
import com.pageseeder.base.mfa.sms.SMSProviderException;
import com.pageseeder.db.model.Authenticator;
import com.pageseeder.db.model.Member;
import org.slf4j.LoggerFactory;

public interface SMSProvider
extends ChallengeIssuer,
ChallengeVerifier {
    public String getName();

    public boolean sendCode(PhoneNumber var1, String var2) throws SMSProviderException;

    default public ChallengeRequest sendCode(Authenticator authenticator) {
        try {
            PhoneNumber phone = PhoneNumber.fromAuthenticator(authenticator);
            ChallengeManager manager = ChallengeManager.singleton();
            if (manager.hasReachedRateLimit(authenticator)) {
                return ChallengeRequest.rateLimitReached();
            }
            VerificationCode code = VerificationCode.newCode(6, VerificationCode.CodeType.DIGITS_ONLY);
            boolean sent = this.sendCode(phone, code.code());
            if (sent) {
                Challenge challenge = manager.newChallenge(authenticator, 10, code);
                return ChallengeRequest.smsSent(challenge);
            }
            SecurityLog.warn(authenticator.isVerified() ? SecurityLog.EventType.AUTHENTICATION : SecurityLog.EventType.ACCOUNT_CHANGE, "Unable to send code by SMS to {}", authenticator);
            return ChallengeRequest.error();
        }
        catch (MaxCapacityException | InvalidPhoneNumber | SMSProviderException ex) {
            LoggerFactory.getLogger((String)SMSProvider.class.getName()).error("Unable to send code by SMS to {}", (Object)authenticator, (Object)ex);
            SecurityLog.error(authenticator.isVerified() ? SecurityLog.EventType.AUTHENTICATION : SecurityLog.EventType.ACCOUNT_CHANGE, "Unable to send code by SMS to {} due to {}", authenticator, ex.getMessage());
            return ChallengeRequest.error();
        }
    }

    @Override
    default public ChallengeRequest issueChallenge(Authenticator authenticator, Member member) {
        return this.sendCode(authenticator);
    }

    @Override
    default public ChallengeResult verifyChallenge(Authenticator authenticator, Challenge challenge, String code) {
        if (challenge.matchCode(code)) {
            ChallengeManager.singleton().invalidate(challenge.getId());
            return ChallengeResult.SUCCESS;
        }
        return ChallengeResult.FAILURE;
    }
}

