/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mfa.recovery;

import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.mfa.core.Challenge;
import com.pageseeder.base.mfa.core.ChallengeData;
import com.pageseeder.base.mfa.core.ChallengeIssuer;
import com.pageseeder.base.mfa.core.ChallengeManager;
import com.pageseeder.base.mfa.core.ChallengeRequest;
import com.pageseeder.base.mfa.core.ChallengeResult;
import com.pageseeder.base.mfa.core.ChallengeVerifier;
import com.pageseeder.base.mfa.core.ConfidentialData;
import com.pageseeder.base.mfa.core.MaxCapacityException;
import com.pageseeder.base.mfa.recovery.BackupCodes;
import com.pageseeder.db.Database;
import com.pageseeder.db.model.Authenticator;
import com.pageseeder.db.model.Member;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupOTP
implements ChallengeIssuer,
ChallengeVerifier {
    public static final Logger LOGGER = LoggerFactory.getLogger(BackupOTP.class);
    private static final ChallengeData NONE = () -> true;
    private final Database db;

    public BackupOTP(Database db) {
        this.db = db;
    }

    @Override
    public ChallengeRequest issueChallenge(Authenticator authenticator, Member member) {
        try {
            ChallengeManager manager = ChallengeManager.singleton();
            if (manager.hasReachedRateLimit(authenticator)) {
                return ChallengeRequest.rateLimitReached();
            }
            Challenge challenge = manager.newChallenge(authenticator, 20, NONE);
            return ChallengeRequest.ready(challenge);
        }
        catch (MaxCapacityException ex) {
            return ChallengeRequest.error();
        }
    }

    @Override
    public ChallengeResult verifyChallenge(Authenticator authenticator, Challenge challenge, String code) {
        if (authenticator.isVerified()) {
            String data = ConfidentialData.getData(authenticator);
            if (data == null) {
                return ChallengeResult.FAILURE;
            }
            BackupCodes codes = BackupCodes.parse(data);
            if (codes.hasCode(code)) {
                SecurityLog.info(SecurityLog.EventType.AUTHENTICATION, "Used backup code as multifactor authentication");
                codes.invalidate(code);
                if (codes.isEmpty()) {
                    authenticator.setName("Backup codes - NO CODES LEFT");
                } else {
                    authenticator.setName("Backup codes (" + codes.count() + " left)");
                    ConfidentialData.setData(authenticator, codes.asData());
                }
                ChallengeManager.singleton().invalidate(challenge.getId());
                return ChallengeResult.SUCCESS;
            }
        } else {
            return ChallengeResult.SUCCESS;
        }
        return ChallengeResult.FAILURE;
    }
}

