/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mfa.recovery;

import com.pageseeder.base.mfa.core.ChallengeData;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.common.oauth.Passwords;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class BackupCodes
implements ChallengeData {
    private static final char[] ALPHA_NUMERIC = "123456789ABCDEFGHJKLMNPQRSTUVWXYZ".toCharArray();
    private static final int DEFAULT_CODE_LENGTH = 16;
    private final List<String> codes;

    BackupCodes(List<String> codes) {
        this.codes = Objects.requireNonNull(codes);
    }

    public static BackupCodes newBackupCodes(int count) {
        ArrayList<String> codes = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            codes.add(Passwords.random((int)16, (char[])ALPHA_NUMERIC));
        }
        return new BackupCodes(codes);
    }

    public boolean isEmpty() {
        return this.codes.isEmpty();
    }

    public int count() {
        return this.codes.size();
    }

    public boolean hasCode(String code) {
        return this.codes.contains(code);
    }

    public boolean invalidate(String code) {
        return this.codes.remove(code);
    }

    public static BackupCodes parse(String data) {
        List<String> codes = Arrays.stream(data.split(",")).filter(s -> s.length() > 8).collect(Collectors.toList());
        return new BackupCodes(codes);
    }

    public String asData() {
        return String.join((CharSequence)",", this.codes);
    }

    @Override
    public boolean isSecret() {
        return true;
    }

    @Override
    public void print(OutputPrinter out) {
        out.startObject("backup-codes");
        out.field("count", this.codes.size());
        out.endObject();
    }
}

