/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mail.dkim;

import com.pageseeder.base.mail.dkim.Canonicalization;
import com.pageseeder.base.mail.dkim.DKIM;
import com.pageseeder.base.mail.dkim.DKIMSignerException;
import com.pageseeder.base.mail.dkim.SMTPDKIMMessage;
import com.pageseeder.base.mail.dkim.SigningAlgorithm;
import jakarta.mail.MessagingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.angus.mail.util.CRLFOutputStream;

public class DKIMSigner {
    private static final String DKIMSIGNATUREHEADER = "DKIM-Signature";
    private static final int MAXHEADERLENGTH = 67;
    private static final List<String> MINIMUM_HEADERS_TO_SIGN = Arrays.asList("From", "To", "Subject");
    private final String[] defaultHeadersToSign = new String[]{"Content-Description", "Content-ID", "Content-Type", "Content-Transfer-Encoding", "Cc", "Date", "From", "In-Reply-To", "List-Subscribe", "List-Post", "List-Owner", "List-Id", "List-Archive", "List-Help", "List-Unsubscribe", "List-Unsubscribe-Post", "MIME-Version", "Message-ID", "Resent-Sender", "Resent-Cc", "Resent-Date", "Resent-To", "Reply-To", "References", "Resent-Message-ID", "Resent-From", "Sender", "Subject", "To"};
    private final SigningAlgorithm signingAlgorithm = SigningAlgorithm.SHA256_WITH_RSA;
    private final Signature signatureService;
    private final MessageDigest messageDigest;
    private final String signingDomain;
    private final String selector;
    private final String identity;
    private final boolean lengthParam = false;
    private final boolean zParam = false;
    private final Canonicalization headerCanonicalization = Canonicalization.RELAXED;
    private final Canonicalization bodyCanonicalization = Canonicalization.SIMPLE;
    private final PrivateKey privkey;

    public DKIMSigner(String signingDomain, String selector, PrivateKey privkey) throws Exception {
        this.identity = null;
        if (!DKIM.isValidDomain(signingDomain)) {
            throw new DKIMSignerException(signingDomain + " is an invalid signing domain");
        }
        this.signingDomain = signingDomain;
        this.selector = selector.trim();
        this.privkey = privkey;
        try {
            this.messageDigest = MessageDigest.getInstance(this.signingAlgorithm.getJavaHashNotation());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new DKIMSignerException("The hashing algorithm " + this.signingAlgorithm.getJavaHashNotation() + " is not known by the JVM", nsae);
        }
        try {
            this.signatureService = Signature.getInstance(this.signingAlgorithm.getJavaSecNotation());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new DKIMSignerException("The signing algorithm " + this.signingAlgorithm.getJavaSecNotation() + " is not known by the JVM", nsae);
        }
        try {
            this.signatureService.initSign(this.privkey);
        }
        catch (InvalidKeyException ike) {
            throw new DKIMSignerException("The provided private key is invalid", ike);
        }
    }

    public String getIdentity() {
        return this.identity;
    }

    public Canonicalization getBodyCanonicalization() {
        return this.bodyCanonicalization;
    }

    public Canonicalization getHeaderCanonicalization() {
        return this.headerCanonicalization;
    }

    public String[] getDefaultHeadersToSign() {
        return this.defaultHeadersToSign;
    }

    public boolean getLengthParam() {
        Objects.requireNonNull(this);
        return false;
    }

    public boolean isZParam() {
        Objects.requireNonNull(this);
        return false;
    }

    public SigningAlgorithm getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    private String serializeDKIMSignature(Map<String, String> dkimSignature) {
        Set<Map.Entry<String, String>> entries = dkimSignature.entrySet();
        StringBuffer buf = new StringBuffer();
        int pos = 0;
        for (Map.Entry<String, String> entry : entries) {
            StringBuffer fbuf = new StringBuffer();
            fbuf.append(entry.getKey()).append("=").append(entry.getValue()).append(";");
            if (pos + fbuf.length() + 1 > 67) {
                pos = fbuf.length();
                buf.append("\r\n\t").append(fbuf);
                continue;
            }
            buf.append(" ").append(fbuf);
            pos += fbuf.length() + 1;
        }
        buf.append("\r\n\tb=");
        return buf.toString().trim();
    }

    private String foldSignedSignature(String s, int offset) {
        int i = 0;
        StringBuffer buf = new StringBuffer();
        while (true) {
            if (offset > 0 && s.substring(i).length() > 67 - offset) {
                buf.append(s.substring(i, i + 67 - offset));
                i += 67 - offset;
                offset = 0;
                continue;
            }
            if (s.substring(i).length() <= 67) break;
            buf.append("\r\n\t").append(s.substring(i, i + 67));
            i += 67;
        }
        buf.append("\r\n\t").append(s.substring(i));
        return buf.toString();
    }

    public String sign(SMTPDKIMMessage message) throws DKIMSignerException, MessagingException {
        byte[] signedSignature;
        LinkedHashMap<String, String> dkimSignature = new LinkedHashMap<String, String>();
        dkimSignature.put("v", "1");
        dkimSignature.put("a", this.signingAlgorithm.getRfc4871Notation());
        dkimSignature.put("q", "dns/txt");
        dkimSignature.put("c", this.getHeaderCanonicalization().getType() + "/" + this.getBodyCanonicalization().getType());
        dkimSignature.put("t", "" + new Date().getTime() / 1000L);
        dkimSignature.put("s", this.selector);
        dkimSignature.put("d", this.signingDomain);
        if (this.identity != null) {
            dkimSignature.put("i", DKIM.QuotedPrintable(this.identity));
        }
        ArrayList<String> assureHeaders = new ArrayList<String>(MINIMUM_HEADERS_TO_SIGN);
        StringBuffer headerList = new StringBuffer();
        StringBuffer headerContent = new StringBuffer();
        StringBuffer zParamString = new StringBuffer();
        Enumeration headerLines = message.getMatchingHeaderLines(this.defaultHeadersToSign);
        while (headerLines.hasMoreElements()) {
            String header = (String)headerLines.nextElement();
            String[] headerParts = DKIM.splitHeader(header);
            headerList.append(headerParts[0]).append(":");
            headerContent.append(this.headerCanonicalization.canonicalizeHeader(headerParts[0], headerParts[1])).append("\r\n");
            assureHeaders.remove(headerParts[0]);
            Objects.requireNonNull(this);
        }
        if (!assureHeaders.isEmpty()) {
            throw new DKIMSignerException("Could not find the header fields " + String.join((CharSequence)", ", assureHeaders) + " for signing");
        }
        dkimSignature.put("h", headerList.substring(0, headerList.length() - 1));
        Objects.requireNonNull(this);
        String body = message.getEncodedBody();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CRLFOutputStream crlfos = new CRLFOutputStream((OutputStream)baos);
        try {
            crlfos.write(body.getBytes());
        }
        catch (IOException e) {
            throw new DKIMSignerException("The body conversion to MIME canonical CRLF line terminator failed", e);
        }
        body = baos.toString();
        body = this.bodyCanonicalization.canonicalizeBody(body);
        Objects.requireNonNull(this);
        dkimSignature.put("bh", DKIM.base64Encode(this.messageDigest.digest(body.getBytes())));
        String serializedSignature = this.serializeDKIMSignature(dkimSignature);
        try {
            this.signatureService.update(headerContent.append(this.headerCanonicalization.canonicalizeHeader(DKIMSIGNATUREHEADER, " " + serializedSignature)).toString().getBytes());
            signedSignature = this.signatureService.sign();
        }
        catch (SignatureException se) {
            throw new DKIMSignerException("The signing operation by Java security failed", se);
        }
        return "DKIM-Signature: " + serializedSignature + this.foldSignedSignature(DKIM.base64Encode(signedSignature), 3);
    }
}

