/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.mail;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.mail.MessageReceived;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.security.MalwareScanner;
import com.pageseeder.base.security.ScanResult;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.properties.SettingsFile;
import com.pageseeder.common.util.Strings;
import com.pageseeder.common.util.ZipChecker;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimePart;
import jakarta.mail.internet.MimeUtility;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageHandler.class);
    private static final String HTML_MIME = "text/html";
    private static final int BUFFER_SIZE = 4096;
    private static final int MAX_ATTACHMENT_INDEX = 1000000000;
    private static final AtomicInteger malewareThreads = new AtomicInteger(0);
    private int maxMalwareThreads = 0;
    private final String attachmentDir;
    private final boolean preserve;
    private final boolean ignoreAttachments;
    private final Long ignoreAttachmentSize;
    private final Long maxAttachmentSize;
    private final MessageReceived received;
    private final @Nullable MalwareScanner malwareClient;
    private Database database = null;
    private String scheme = null;
    private String host = null;
    private int port;
    private boolean insideInnerMessage = false;

    public MessageHandler(String attachmentdir, boolean ispreserve, boolean isreply, boolean ignoreatt, Long ignoreASize, Long maxSize) {
        this.attachmentDir = attachmentdir;
        this.preserve = ispreserve;
        this.ignoreAttachments = ignoreatt;
        this.ignoreAttachmentSize = (long)Math.ceil((double)ignoreASize.longValue() / 3.0) * 4L;
        this.maxAttachmentSize = maxSize;
        this.received = new MessageReceived();
        this.received.setReply(isreply);
        this.malwareClient = SecurityUtils.getMalwareClient();
        try {
            this.maxMalwareThreads = Integer.parseInt(GlobalSettings.getString((String)"malwareMaxEmailThreads", (String)"0"));
        }
        catch (NumberFormatException ex) {
            LOGGER.error("malwareMaxEmailThreads global property is invalid");
        }
    }

    public void setURIDetails(String ascheme, String ahost, int aport, Database db) {
        this.scheme = ascheme;
        this.port = aport;
        this.host = ahost;
        this.database = db;
    }

    public void setFooterDetails(boolean strip, String start) {
        this.received.setStripFooter(strip);
        this.received.setFooterStart(start);
    }

    public MessageReceived handleMessage(MimeMessage message, String headers) throws IOException, MessagingException {
        try {
            if (message.isMimeType("text/plain")) {
                String content = this.getTextContent((MimePart)message);
                if (this.preserve) {
                    MessageReceived msg = new MessageReceived(null, message.getSubject());
                    msg.setTextMailPart(content);
                    msg.addTextContent(content);
                    return msg;
                }
                if (this.received.isReply()) {
                    content = MessageHandler.stripMessageFooter(content, this.received.getFooterStart());
                }
                this.received.setTextMailPart(headers + content);
                this.received.addTextContent(headers + content);
            } else if (message.isMimeType(HTML_MIME)) {
                this.handleAttachment((MimePart)message, true, false);
            } else {
                Object msg_cont = message.getContent();
                if (msg_cont instanceof MimeMultipart) {
                    MimeMultipart multi_cont = (MimeMultipart)msg_cont;
                    this.handleMultipart(multi_cont, headers);
                    if (this.preserve) {
                        MessageReceived msg = new MessageReceived(multi_cont, message.getSubject());
                        msg.setXHTMLMailPart(this.received.getXHTMLMailPart());
                        Iterator<String> txtContents = this.received.getTextContents();
                        while (txtContents.hasNext()) {
                            msg.addTextContent(txtContents.next());
                        }
                        Iterator<String> attachmentURLs = this.received.getAttachmentURIs();
                        while (!this.ignoreAttachments && attachmentURLs.hasNext()) {
                            String url = attachmentURLs.next();
                            msg.addAttachmentURI(url, this.received.getAttachmentUserTitle(url));
                        }
                        return msg;
                    }
                } else if (!this.ignoreAttachments) {
                    if (msg_cont instanceof InputStream) {
                        this.handleAttachment((InputStream)msg_cont, message.getContentType(), message.getSize(), message.getFileName(), false, false);
                        this.received.setTextMailPart(" ");
                    } else {
                        throw new IllegalArgumentException("Unknown message type, message received has type " + message.getContentType());
                    }
                }
            }
            if (!this.preserve) {
                this.received.complete();
            }
        }
        catch (MessagingException ex) {
            Iterator<String> attachments = this.received.getAttachmentURIs();
            while (attachments.hasNext()) {
                String path = attachments.next();
                File attachment = new File(URIRule.getRealPath(Settings.getContextPath(), path));
                if (!attachment.exists() || attachment.delete()) continue;
                LOGGER.warn("Failed to delete invalid attachment {}", (Object)path);
            }
            throw ex;
        }
        return this.received;
    }

    private String getTextContent(MimePart part) throws IOException, MessagingException {
        String content;
        try {
            content = (String)part.getContent();
        }
        catch (UnsupportedEncodingException ex) {
            InputStream is = part.getInputStream();
            byte[] bytes = IOUtils.toByteArray((InputStream)is);
            String type = part.getContentType();
            if (type != null && type.contains("cp-850")) {
                content = new String(bytes, Charset.forName("Cp850"));
            }
            throw new IOException("Unable to handle email with content type: " + type);
        }
        return content;
    }

    private void handleMultipart(MimeMultipart multi, String headers) throws MessagingException, IOException {
        if (!"".equals(headers)) {
            this.received.addTextContent(headers);
        }
        boolean isMixed = multi.getContentType().startsWith("multipart/mixed");
        boolean isRelated = multi.getContentType().startsWith("multipart/related");
        boolean isAlternative = multi.getContentType().startsWith("multipart/alternative");
        boolean isInAlternative = multi.getParent().getContentType().startsWith("multipart/alternative");
        if (isRelated) {
            this.handleRelated(multi, !isInAlternative);
        } else if (isAlternative) {
            this.handleAlternative(multi);
        } else if (isMixed) {
            this.handleMixed(multi);
        }
    }

    private void handleAlternative(MimeMultipart multi) throws MessagingException, IOException {
        for (int i = 0; i < multi.getCount(); ++i) {
            String content;
            MimeBodyPart bp = (MimeBodyPart)multi.getBodyPart(i);
            if (bp.isMimeType("text/plain")) {
                content = this.getTextContent((MimePart)bp);
                if (this.received.isReply()) {
                    content = MessageHandler.stripMessageFooter(content, this.received.getFooterStart());
                }
                this.received.addTextContent(content);
                if (this.insideInnerMessage) continue;
                this.received.setTextMailPart(content);
                continue;
            }
            if (bp.isMimeType(HTML_MIME) && !this.insideInnerMessage) {
                content = this.getTextContent((MimePart)bp);
                if (this.received.shouldStripFooter()) {
                    content = MessageHandler.stripMessageFooterHTML(content, this.received.getFooterStart());
                }
                this.received.setXHTMLMailPart(Emails.htmlToXHTML(content));
                continue;
            }
            if (!bp.getContentType().startsWith("multipart/related")) continue;
            this.handleRelated((MimeMultipart)bp.getContent(), false);
        }
    }

    private void handleRelated(MimeMultipart multi, boolean htmlAsAttachment) throws MessagingException, IOException {
        for (int i = 0; i < multi.getCount(); ++i) {
            MimeBodyPart bp = (MimeBodyPart)multi.getBodyPart(i);
            if (bp.isMimeType(HTML_MIME)) {
                if (this.insideInnerMessage && htmlAsAttachment) {
                    this.handleAttachment((MimePart)bp, false, false);
                    continue;
                }
                if (this.insideInnerMessage) continue;
                String content = this.getTextContent((MimePart)bp);
                if (this.received.shouldStripFooter()) {
                    content = MessageHandler.stripMessageFooterHTML(content, this.received.getFooterStart());
                }
                this.received.setXHTMLMailPart(Emails.htmlToXHTML(content));
                continue;
            }
            if (!this.insideInnerMessage) {
                this.received.addRelatedPart((BodyPart)bp);
            }
            try {
                if (bp.getContent() instanceof MimeMultipart) {
                    this.handleMultipart((MimeMultipart)bp.getContent(), "");
                    continue;
                }
                this.handleAttachment((MimePart)bp, false, true);
                continue;
            }
            catch (UnsupportedEncodingException ex) {
                LOGGER.warn("Ignoring email part with content type: " + bp.getContentType());
            }
        }
    }

    private void handleMixed(MimeMultipart multi) throws IOException, MessagingException {
        boolean isInAlternative = multi.getParent().getContentType().startsWith("multipart/alternative");
        for (int i = 0; i < multi.getCount(); ++i) {
            String content;
            MimeBodyPart bp = (MimeBodyPart)multi.getBodyPart(i);
            if (bp.isMimeType("text/plain") && (bp.getFileName() == null || this.attachmentDir == null)) {
                content = this.getTextContent((MimePart)bp);
                if (this.received.isReply()) {
                    content = MessageHandler.stripMessageFooter(content, this.received.getFooterStart());
                }
                this.received.addTextContent(content);
                if (this.insideInnerMessage) continue;
                this.received.setTextMailPart(content);
                continue;
            }
            if (bp.isMimeType(HTML_MIME) && !this.insideInnerMessage) {
                if (isInAlternative) {
                    content = this.getTextContent((MimePart)bp);
                    if (this.received.shouldStripFooter()) {
                        content = MessageHandler.stripMessageFooterHTML(content, this.received.getFooterStart());
                    }
                    this.received.setXHTMLMailPart(Emails.htmlToXHTML(content));
                    continue;
                }
                this.handleAttachment((MimePart)bp, false, false);
                continue;
            }
            Object bp_cont = bp.getContent();
            if (bp_cont instanceof MimeMultipart) {
                this.handleMultipart((MimeMultipart)bp_cont, "");
                continue;
            }
            if (bp_cont instanceof MimeMessage) {
                MimeMessage msg = (MimeMessage)bp_cont;
                Enumeration heade = msg.getMatchingHeaderLines(new String[]{"Subject", "Date", "From", "To", "CC"});
                StringBuilder heads = new StringBuilder();
                if (heade.hasMoreElements()) {
                    heads.append("-----------------------------------------------------------------------\n");
                    while (heade.hasMoreElements()) {
                        String line = (String)heade.nextElement();
                        line = line.replace('<', ' ');
                        line = line.replace('>', ' ');
                        heads.append(line).append("\n");
                    }
                    heads.append("\n");
                }
                this.handleInnerMessage(msg, heads.toString());
                if (this.insideInnerMessage) continue;
                this.received.addMixedPart((BodyPart)bp);
                continue;
            }
            this.handleAttachment((MimePart)bp, false, false);
        }
    }

    private void handleInnerMessage(MimeMessage message, String headers) throws IOException, MessagingException {
        boolean before = this.insideInnerMessage;
        this.insideInnerMessage = true;
        if (message.isMimeType("text/plain")) {
            String content = this.getTextContent((MimePart)message);
            if (this.received.isReply()) {
                content = MessageHandler.stripMessageFooter(content, this.received.getFooterStart());
            }
            this.received.addTextContent(headers + content);
        } else {
            Object msg_cont = message.getContent();
            if (msg_cont instanceof MimeMultipart) {
                MimeMultipart multi_cont = (MimeMultipart)msg_cont;
                this.handleMultipart(multi_cont, headers);
            } else if (msg_cont instanceof MimeMessage) {
                MimeMessage msg2 = (MimeMessage)msg_cont;
                Enumeration heade = msg2.getMatchingHeaderLines(new String[]{"Subject", "Date", "From", "To", "CC"});
                StringBuilder heads = new StringBuilder();
                if (heade.hasMoreElements()) {
                    heads.append("-----------------------------------------------------------------------\n");
                    while (heade.hasMoreElements()) {
                        String line = (String)heade.nextElement();
                        line = line.replace('<', ' ');
                        line = line.replace('>', ' ');
                        heads.append(line).append("\n");
                    }
                    heads.append("\n");
                }
                this.handleInnerMessage(msg2, heads.toString());
            } else {
                this.handleAttachment((MimePart)message, false, false);
            }
        }
        this.insideInnerMessage = before;
    }

    private void handleAttachment(MimePart bp, boolean mainMessage, boolean related) throws MessagingException {
        try {
            this.handleAttachment(bp.getInputStream(), bp.getContentType(), bp.getSize(), bp.getFileName(), mainMessage, related);
        }
        catch (IOException ex) {
            throw new MessagingException("Could not load attachment:" + ex.getMessage());
        }
    }

    private void handleAttachment(InputStream in, String content_type, int size, String orig_filename, boolean mainMessage, boolean related) throws MessagingException {
        if (this.ignoreAttachments && !mainMessage || this.attachmentDir == null) {
            return;
        }
        if (orig_filename != null && ((String)orig_filename).toLowerCase().endsWith(".vcf")) {
            return;
        }
        if (related && this.ignoreAttachmentSize != null && this.ignoreAttachmentSize > (long)size) {
            LOGGER.debug("Ignoring related attachment {} because base64 size {} is smaller than limit {}", new Object[]{orig_filename, size, this.ignoreAttachmentSize});
            return;
        }
        if ((long)size > this.maxAttachmentSize) {
            LOGGER.warn("Ignoring attachment {} because size {} is bigger than limit {}", new Object[]{orig_filename, size, this.maxAttachmentSize});
            return;
        }
        try {
            StringBuilder userTitle = null;
            String loaded_encoding = null;
            byte[] loaded_data = null;
            if (orig_filename == null) {
                orig_filename = "attachment-" + System.nanoTime();
                if (content_type != null) {
                    int i = (content_type = content_type.toLowerCase()).indexOf(";");
                    if (i != -1) {
                        content_type = content_type.substring(0, i).trim();
                    }
                    if (content_type.startsWith(HTML_MIME)) {
                        i = content_type.indexOf("charset=");
                        loaded_encoding = i != -1 ? content_type.substring(i + "charset=".length()) : "UTF-8";
                        loaded_data = MessageHandler.readBodyPartContent(in);
                    }
                }
            } else {
                try {
                    orig_filename = MimeUtility.decodeText((String)orig_filename);
                }
                catch (UnsupportedEncodingException ex) {
                    LOGGER.warn("Unable to decode attachment filename {}", orig_filename);
                    orig_filename = "attachment";
                }
                String newfn = RuleUtils.replaceNonFilenameChars((String)orig_filename);
                newfn = MessageHandler.findCorrectFileName(Settings.getContextPath() + "WEB-INF" + File.separator + "temp", newfn);
                if (!((String)orig_filename).equals(newfn)) {
                    userTitle = new StringBuilder((String)orig_filename);
                }
                orig_filename = newfn;
            }
            if (!mainMessage) {
                String extension;
                if (content_type != null && ((String)orig_filename).indexOf(46) == -1) {
                    Enumeration me = Settings.keys((SettingsFile)SettingsFile.MIME);
                    String extension2 = null;
                    if (me != null) {
                        while (me.hasMoreElements()) {
                            String ext = (String)me.nextElement();
                            if (!content_type.equalsIgnoreCase(Settings.get((SettingsFile)SettingsFile.MIME, (String)ext))) continue;
                            extension2 = ext;
                            break;
                        }
                    }
                    if (extension2 != null) {
                        orig_filename = (String)orig_filename + "." + extension2;
                    }
                }
                if ((extension = URIRule.getExtension((String)orig_filename).toLowerCase()).equals("psml")) {
                    throw new FoundationException("PSML files can't be attached");
                }
                if (RuleUtils.forbiddenAttachmentExtensions().contains(extension)) {
                    throw new FoundationException("Files with extension ." + extension + " can't be attached as they may be harmful");
                }
                String base_path = Settings.getDocumentPath() + File.separator;
                File dir = new File(base_path + this.attachmentDir);
                if (!dir.exists() && !dir.mkdirs()) {
                    LOGGER.warn("Directory {}{} could not be created.", (Object)base_path, (Object)this.attachmentDir);
                    return;
                }
                File f = null;
                String uriPath = null;
                String siteprefix = GlobalSettings.getSitePrefix();
                Object filename = orig_filename;
                String[] orig = URIRule.getFilename((String)orig_filename);
                for (int j = 1; j < 1000000000; ++j) {
                    f = new File(base_path + this.attachmentDir + (String)filename);
                    if (!f.exists()) {
                        uriPath = RuleUtils.urlEncodeFilepath(siteprefix + "/" + this.attachmentDir.replace(File.separatorChar, '/') + (String)filename);
                        try {
                            if (DatabaseQuery.getURIBySchemeHostPortPath((Database)this.database, (String)this.scheme, (String)this.host, (Integer)this.port, (String)uriPath) == null) {
                                break;
                            }
                        }
                        catch (QueryFailedException e) {
                            LOGGER.error("Failed to save an email attachment: error when querying DB for existing URI with path {}", (Object)uriPath, (Object)e);
                            return;
                        }
                    }
                    filename = orig[0] + "-" + j + orig[1];
                    if (userTitle == null) continue;
                    userTitle.append("-").append(j);
                }
                try (FileOutputStream outs = new FileOutputStream(f);){
                    if (loaded_data != null) {
                        ((OutputStream)outs).write(loaded_data);
                    } else {
                        MessageHandler.readBodyPartContent(in, outs);
                    }
                }
                if ("zip".equalsIgnoreCase(extension) && !MessageHandler.checkZip(f)) {
                    if (!f.delete()) {
                        LOGGER.warn("Failed to delete malicious ZIP file {}", (Object)f.getAbsolutePath());
                        f.deleteOnExit();
                    }
                    uriPath = null;
                }
                if (this.malwareClient != null && this.maxMalwareThreads > 0) {
                    String result = this.scan(f);
                    if (result != null) {
                        if (!f.delete()) {
                            LOGGER.error("Failed to delete attachment containing malware {}", (Object)f.getAbsolutePath());
                            f.deleteOnExit();
                        }
                        for (File a : this.received.getScannedFiles()) {
                            if (a.delete()) continue;
                            LOGGER.warn("Failed to delete attachment from rejected email {}", (Object)f.getAbsolutePath());
                            a.deleteOnExit();
                        }
                        throw new IllegalArgumentException(result);
                    }
                    this.received.addScannedFile(f);
                }
                if (uriPath != null) {
                    this.received.addAttachmentURI(uriPath, userTitle == null ? null : userTitle.toString());
                }
            }
            if (loaded_data != null) {
                String html = new String(loaded_data, loaded_encoding);
                if (this.received.shouldStripFooter()) {
                    html = MessageHandler.stripMessageFooterHTML(html, this.received.getFooterStart());
                }
                String xhtml = Emails.htmlToXHTML(html);
                String text = Emails.xhtmlToText(xhtml);
                this.received.addTextContent(text);
                if (!this.insideInnerMessage) {
                    this.received.setTextMailPart(text);
                    this.received.setXHTMLMailPart(xhtml);
                }
            }
            this.received.setHasAttachments();
        }
        catch (FoundationException ex) {
            throw new MessagingException(ex.getMessage());
        }
        catch (MessagingException | IOException ex) {
            LOGGER.warn("Failed to save an email attachment", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable String scan(File file) {
        if (malewareThreads.incrementAndGet() > this.maxMalwareThreads) {
            malewareThreads.decrementAndGet();
            LOGGER.error("Too many malware scanning email threads");
            return "Too many malware scanning threads, try again later";
        }
        try {
            ScanResult result;
            FileInputStream is;
            block16: {
                block15: {
                    String string;
                    is = new FileInputStream(file);
                    try {
                        result = this.malwareClient.scan(is);
                        if (!ScanResult.Status.OK.equals((Object)result.getStatus())) break block15;
                        string = null;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (Exception ex) {
                            LOGGER.error("Error scanning emailed file {}", (Object)file.getName(), (Object)ex);
                            String string2 = "Malware scanning failed";
                            return string2;
                        }
                    }
                    ((InputStream)is).close();
                    return string;
                }
                if (!ScanResult.Status.VIRUS_FOUND.equals((Object)result.getStatus())) break block16;
                String string = "Malware " + result.getSignature() + " found in file " + file.getName();
                ((InputStream)is).close();
                return string;
            }
            LOGGER.error("Error scanning emailed file {}: {}", (Object)file.getName(), (Object)result.getOutput());
            String string = "Error scanning file " + file.getName();
            ((InputStream)is).close();
            return string;
        }
        finally {
            malewareThreads.decrementAndGet();
        }
    }

    public static boolean checkZip(File zipFile) {
        ZipChecker checker = new ZipChecker(zipFile);
        checker.check();
        if (checker.hasError()) {
            LOGGER.warn("Ignoring malicious/invalid ZIP file: {}", (Object)checker.getError());
            return false;
        }
        return true;
    }

    public static byte[] readBodyPartContent(InputStream ins) throws IOException, MessagingException {
        try (ByteArrayOutputStream outs = new ByteArrayOutputStream();){
            MessageHandler.readBodyPartContent(ins, outs);
            byte[] byArray = outs.toByteArray();
            return byArray;
        }
    }

    public static void readBodyPartContent(InputStream ins, OutputStream outs) throws IOException {
        if (ins != null) {
            try (InputStream inputStream = ins;){
                byte[] buff = new byte[4096];
                boolean reading_file = true;
                while (reading_file) {
                    int j = ins.read(buff, 0, 4096);
                    if (j > 0) {
                        outs.write(buff, 0, j);
                    }
                    if (j == 4096) continue;
                    reading_file = false;
                }
            }
        }
    }

    private static String findCorrectFileName(String tempDir, String name) {
        if (!new File(tempDir).mkdirs()) {
            return name;
        }
        File f = new File(tempDir, name);
        Object filename = name;
        while (true) {
            try {
                if (f.createNewFile()) {
                    break;
                }
            }
            catch (IOException ioe) {
                LOGGER.warn("IO Error when creating new attachment file", (Throwable)ioe);
            }
            for (int i = ((String)filename).length() - 1; i >= 0; --i) {
                if (i == 0) {
                    filename = "_" + ((String)filename).substring(1);
                }
                File temp = new File(tempDir, ((String)filename).substring(0, i));
                try {
                    if (!temp.createNewFile()) continue;
                    if (!temp.delete()) {
                        temp.deleteOnExit();
                    }
                    filename = ((String)filename).substring(0, i) + "_" + ((String)filename).substring(i + 1);
                    break;
                }
                catch (IOException ioe) {
                    LOGGER.warn("IO Error when creating new attachment file", (Throwable)ioe);
                }
            }
            f = new File(name);
        }
        if (!f.delete()) {
            f.deleteOnExit();
        }
        return f.getName();
    }

    private static String stripMessageFooterHTML(String content, String startTextToFind) {
        if (content == null) {
            return content;
        }
        String oneline = content.replaceAll("\\s+", " ");
        int indexstart = MessageHandler.indexOfText(oneline, startTextToFind);
        if (indexstart == -1) {
            return content;
        }
        Object newContent = oneline.substring(0, indexstart);
        if (!((String)(newContent = (String)newContent + MessageHandler.closingTags((String)newContent) + "<p>Go to the website to view the rest of this discussion.</p>")).contains("</body>")) {
            newContent = (String)newContent + "</body>";
        }
        if (!((String)newContent).contains("</html>")) {
            newContent = (String)newContent + "</html>";
        }
        return newContent;
    }

    private static String closingTags(String html) {
        int lastStart = html.lastIndexOf(60);
        if (lastStart == -1) {
            return "";
        }
        while (html.charAt(lastStart + 1) == '/') {
            if ((lastStart = html.lastIndexOf(60, lastStart - 1)) != -1) continue;
            return "";
        }
        String tagName = html.substring(lastStart + 1, html.indexOf(62, lastStart)).replaceAll("\\s(.*)$", "");
        if ("br".equals(tagName)) {
            return MessageHandler.closingTags(html.substring(0, lastStart));
        }
        if ("body".equals(tagName)) {
            return "";
        }
        if (html.indexOf("</" + tagName + ">", lastStart) != -1) {
            return "";
        }
        return "</" + tagName + ">" + MessageHandler.closingTags(html.substring(0, lastStart));
    }

    private static int indexOfText(String original, String tofind) {
        if (tofind == null || original == null) {
            return -1;
        }
        String[] textToFind = Strings.split((String)tofind, (char)',');
        int index = -1;
        for (String element : textToFind) {
            int thisindex = original.lastIndexOf(element);
            if (thisindex == -1 || thisindex >= index && index != -1) continue;
            index = thisindex;
        }
        return index;
    }

    private static String stripMessageFooter(String content, String startTextToFind) {
        int index;
        int n = index = content == null ? -1 : MessageHandler.indexOfText(content, startTextToFind);
        if (index == -1) {
            return content;
        }
        Object newContent = content.substring(0, index);
        newContent = (String)newContent + "> Go to the website to view the rest of this discussion.";
        return newContent;
    }
}

