/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.logback;

import ch.qos.logback.classic.spi.ClassPackagingData;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.LayoutBase;
import com.pageseeder.base.logback.XLoggable;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.common.xml.XMLUtils;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.slf4j.Marker;

public final class XLogLayout
extends LayoutBase<ILoggingEvent> {
    private boolean location = false;
    private boolean properties = false;

    public void setLocationInfo(boolean flag) {
        this.location = flag;
    }

    public boolean getLocationInfo() {
        return this.location;
    }

    public void setProperties(boolean flag) {
        this.properties = flag;
    }

    public boolean getProperties() {
        return this.properties;
    }

    public String doLayout(ILoggingEvent event) {
        Map propertyMap;
        StackTraceElement[] callerDataArray;
        XMLStringWriter xml = new XMLStringWriter(XML.NamespaceAware.No);
        Marker m = event.getMarker();
        if (m != null && m.contains("comment")) {
            return "<!-- " + event.getFormattedMessage() + " -->\n";
        }
        if (m != null && m.contains("silent")) {
            return "";
        }
        xml.openElement("event");
        xml.attribute("logger", event.getLoggerName());
        xml.attribute("timestamp", String.valueOf(event.getTimeStamp()));
        xml.attribute("datetime", ISO8601.format((long)event.getTimeStamp(), (ISO8601)ISO8601.DATETIME));
        xml.attribute("level", event.getLevel().toString());
        xml.attribute("thread", event.getThreadName());
        if (m != null) {
            xml.attribute("marker", m.getName());
        }
        Object[] o = event.getArgumentArray();
        try {
            if (o != null && o.length == 1 && o[0] instanceof XLoggable) {
                XLoggable xlog = (XLoggable)o[0];
                xml.attribute("ticket", xlog.getTicket());
                if (xlog.getType() == XLoggable.TYPE.START) {
                    xml.attribute("type", "start");
                } else if (xlog.getType() == XLoggable.TYPE.END) {
                    xml.attribute("type", "complete");
                }
                if (xlog.getGroupID() != null) {
                    xml.attribute("groupid", xlog.getGroupID().toString());
                }
                if (xlog.getGroup() != null) {
                    xml.attribute("group", xlog.getGroup());
                }
                if (xlog.getUser() != null) {
                    xml.attribute("username", xlog.getUser());
                }
                if (xlog.getTitle() != null) {
                    xml.attribute("title", xlog.getTitle());
                }
                StringBuilder x = new StringBuilder();
                xlog.toXMLLog(x);
                String message = x.toString();
                if (XLogLayout.isXML(message)) {
                    xml.writeXML(message);
                } else {
                    xml.writeText(x.toString());
                }
            } else {
                String message = event.getFormattedMessage();
                if (XLogLayout.isXML(message)) {
                    xml.writeXML(message);
                } else {
                    xml.openElement("message");
                    xml.writeCDATA(event.getFormattedMessage());
                    xml.closeElement();
                }
            }
        }
        catch (Exception ex) {
            xml.attribute("error", "Unable to write message: " + ex.getMessage());
        }
        IThrowableProxy tp = event.getThrowableProxy();
        if (tp != null) {
            XLogLayout.toXML(xml, tp, true);
        }
        if (this.location && (callerDataArray = event.getCallerData()) != null && callerDataArray.length > 0) {
            StackTraceElement immediateCallerData = callerDataArray[0];
            xml.openElement("locationInfo");
            xml.attribute("class", immediateCallerData.getClassName());
            xml.attribute("method", immediateCallerData.getMethodName());
            xml.attribute("file", immediateCallerData.getFileName());
            xml.attribute("line", immediateCallerData.getLineNumber());
            xml.closeElement();
        }
        if (this.getProperties() && (propertyMap = event.getMDCPropertyMap()) != null && !propertyMap.isEmpty()) {
            xml.openElement("properties");
            for (Map.Entry property : propertyMap.entrySet()) {
                xml.openElement("data");
                xml.attribute("name", (String)property.getKey());
                xml.attribute("value", (String)property.getValue());
                xml.closeElement();
            }
            xml.closeElement();
        }
        xml.closeElement();
        return xml.toString();
    }

    public static String adjustLevel(String level, @Nullable String message) {
        if (message == null) {
            return level;
        }
        if (message.equals(">> EC.close L1Cache op IS NULL!") || message.equals(">> EC.preCommit L1Cache op IS NULL!") || message.startsWith("startTLS() failed:") || message.endsWith("Initializing PageSeeder")) {
            return "INFO";
        }
        return level;
    }

    public static boolean ignoreEvent(@Nullable String message) {
        if (message == null) {
            return false;
        }
        return message.startsWith("Default type for java type of java.math.BigInteger was previously jdbc-type=NUMERIC");
    }

    private static void toXML(XMLStringWriter xml, IThrowableProxy proxy, boolean isOriginal) {
        StackTraceElementProxy[] steps = proxy.getStackTraceElementProxyArray();
        xml.openElement(isOriginal ? "throwable" : "cause");
        xml.attribute("message", proxy.getMessage());
        for (StackTraceElementProxy step : steps) {
            xml.openElement("step");
            ClassPackagingData packaging = step.getClassPackagingData();
            if (packaging != null) {
                String version;
                String location = packaging.getCodeLocation();
                if (location != null) {
                    xml.attribute("location", location);
                }
                if ((version = packaging.getVersion()) != null) {
                    xml.attribute("version", version);
                }
            }
            String s = step.toString();
            xml.writeText(XMLUtils.escapeText((String)s));
            if (s.contains("javax.servlet")) {
                xml.writeText("...");
                xml.closeElement();
                break;
            }
            xml.closeElement();
        }
        IThrowableProxy cause = proxy.getCause();
        if (!isOriginal && cause != null) {
            XLogLayout.toXML(xml, cause, false);
        }
        xml.closeElement();
    }

    public String getContentType() {
        return "application/xml";
    }

    private static boolean isXML(String message) {
        for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            if (c == '<') {
                return true;
            }
            if (c == ' ' || c == '\n' || c == '\t') continue;
            return false;
        }
        return false;
    }
}

