/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.logback;

import com.pageseeder.base.logback.DailyLogFileFilter;
import com.pageseeder.base.logback.config.Location;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.db.model.Member;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class SecurityLog {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"PAGESEEDER.Security");

    private SecurityLog() {
    }

    public static File getFolder() {
        File logs = Location.getFolder();
        return new File(logs, "security");
    }

    public static List<File> getFiles(Date date) {
        DailyLogFileFilter filter = new DailyLogFileFilter(date, ".log");
        File[] logFiles = SecurityLog.getFolder().listFiles(filter);
        if (logFiles == null) {
            throw new IllegalArgumentException("Unable to list files in security log directory!");
        }
        List<File> files = Arrays.asList(logFiles);
        Collections.sort(files);
        return files;
    }

    public static void setup(HttpServletRequest req) {
        MDC.put((String)"path", (String)req.getRequestURI());
        MDC.put((String)"method", (String)req.getMethod());
        MDC.put((String)"ip", (String)SecurityUtils.getRemoteIP(req));
        MDC.put((String)"useragent", (String)SecurityUtils.getUserAgent(req));
        HttpSession session = req.getSession(false);
        if (session != null) {
            Object memberId = session.getAttribute("ps-memberid");
            Object username = session.getAttribute("ps-username");
            if (memberId != null && username != null) {
                SecurityLog.setUserMDC(memberId.toString(), username.toString());
            } else {
                SecurityLog.resetUserMDC();
            }
        } else {
            SecurityLog.resetUserMDC();
        }
    }

    public static void setupUser(Member member) {
        SecurityLog.setUserMDC(member.getId().toString(), member.getUsername());
    }

    private static void setUserMDC(String memberId, String username) {
        MDC.put((String)"memberid", (String)memberId);
        MDC.put((String)"username", (String)username);
    }

    private static void resetUserMDC() {
        MDC.remove((String)"memberid");
        MDC.remove((String)"username");
    }

    public static void error(EventType type, String message) {
        LOGGER.error(SecurityLog.toMarker(type), message);
    }

    public static void error(EventType type, String message, Object ... args) {
        LOGGER.error(SecurityLog.toMarker(type), message, args);
    }

    public static void warn(EventType type, String message) {
        LOGGER.warn(SecurityLog.toMarker(type), message);
    }

    public static void warn(EventType type, String message, Object ... args) {
        LOGGER.warn(SecurityLog.toMarker(type), message, args);
    }

    public static void info(EventType type, String message) {
        LOGGER.info(SecurityLog.toMarker(type), message);
    }

    public static void info(EventType type, String message, Object ... args) {
        LOGGER.info(SecurityLog.toMarker(type), message, args);
    }

    public static void debug(EventType type, String message) {
        LOGGER.debug(SecurityLog.toMarker(type), message);
    }

    public static void debug(EventType type, String message, Object ... args) {
        LOGGER.debug(SecurityLog.toMarker(type), message, args);
    }

    private static Marker toMarker(EventType type) {
        return type.marker();
    }

    public static enum EventType {
        AUTHENTICATION,
        ACCOUNT_CHANGE,
        CSRF,
        DELETION,
        EMAIL_CHANGE,
        FORBIDDEN_ACCESS,
        USERNAME_CHANGE,
        PASSWORD_CHANGE,
        CONFIGURATION_CHANGE,
        OTHER;

        private final String id = this.name().toLowerCase().replace('_', '-');
        private final Marker marker = MarkerFactory.getMarker((String)this.id);

        public String id() {
            return this.id;
        }

        public Marker marker() {
            return this.marker;
        }

        public static EventType fromId(String id) {
            for (EventType type : EventType.values()) {
                if (!type.id.equals(id)) continue;
                return type;
            }
            return OTHER;
        }
    }
}

