/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.logback;

import ch.qos.logback.classic.spi.ClassPackagingData;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import com.pageseeder.base.logback.RecentLogFilter;
import com.pageseeder.base.logback.XLogLayout;
import com.pageseeder.common.util.ISO8601;
import java.io.IOException;
import java.util.List;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Marker;

public final class RecentLogs
implements XMLWritable {
    private final List<ILoggingEvent> events;

    private RecentLogs(List<ILoggingEvent> events) {
        this.events = events;
    }

    public static RecentLogs newInstance() {
        return new RecentLogs(RecentLogFilter.getCopyOfEvents());
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("events");
        xml.attribute("datetime", ISO8601.now());
        for (ILoggingEvent event : this.events) {
            RecentLogs.toXML(xml, event);
        }
        xml.closeElement();
    }

    private static void toXML(XMLWriter xml, ILoggingEvent event) throws IOException {
        IThrowableProxy proxy;
        StackTraceElement[] caller;
        String message = event.getFormattedMessage();
        if (XLogLayout.ignoreEvent(message)) {
            return;
        }
        String extra = null;
        if (message.contains("\n")) {
            extra = message.substring(message.indexOf("\n") + 1);
            message = message.substring(0, message.indexOf("\n"));
        }
        xml.openElement("event");
        xml.attribute("level", XLogLayout.adjustLevel(event.getLevel().toString(), message));
        xml.attribute("logger", event.getLoggerName());
        xml.attribute("timestamp", Long.toString(event.getTimeStamp()));
        xml.attribute("datetime", ISO8601.DATETIME.format(event.getTimeStamp()));
        xml.attribute("message", message);
        Marker marker = event.getMarker();
        if (marker != null) {
            xml.attribute("marker", marker.getName());
        }
        if (extra != null) {
            xml.element("extra", extra);
        }
        if ((caller = event.getCallerData()) != null && caller.length > 0) {
            RecentLogs.toXML(xml, caller[0]);
        }
        if ((proxy = event.getThrowableProxy()) != null) {
            RecentLogs.toXML(xml, proxy, true);
        }
        xml.closeElement();
    }

    private static void toXML(XMLWriter xml, IThrowableProxy proxy, boolean isOriginal) throws IOException {
        StackTraceElementProxy[] steps = proxy.getStackTraceElementProxyArray();
        xml.openElement(isOriginal ? "throwable" : "cause", true);
        if (proxy.getMessage() != null || proxy.getClassName() != null) {
            xml.openElement("step", false);
            xml.writeText(proxy.getClassName() + ": " + proxy.getMessage() + "\n");
            xml.closeElement();
        }
        for (StackTraceElementProxy step : steps) {
            xml.openElement("step", false);
            ClassPackagingData packaging = step.getClassPackagingData();
            if (packaging != null) {
                String version;
                String location = packaging.getCodeLocation();
                if (location != null) {
                    xml.attribute("location", location);
                }
                if ((version = packaging.getVersion()) != null) {
                    xml.attribute("version", version);
                }
            }
            String s = step.toString();
            xml.writeText(s);
            if (s.contains("javax.servlet")) {
                xml.writeXML("...");
                xml.closeElement();
                break;
            }
            xml.closeElement();
        }
        IThrowableProxy cause = proxy.getCause();
        if (!isOriginal && cause != null) {
            RecentLogs.toXML(xml, cause, false);
        }
        xml.closeElement();
    }

    private static void toXML(XMLWriter xml, StackTraceElement caller) throws IOException {
        xml.openElement("caller");
        xml.attribute("class", caller.getClassName());
        xml.attribute("method", caller.getMethodName());
        xml.attribute("file", caller.getFileName());
        xml.attribute("line", caller.getLineNumber());
        xml.closeElement();
    }
}

