/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.logback;

import com.pageseeder.base.logback.DailySummary;
import com.pageseeder.base.logback.XLogException;
import com.pageseeder.base.logback.XLoggerAdaptor;
import com.pageseeder.base.util.WrappingReader;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.common.util.ISO8601;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class OverallSummaryBuilder
implements XMLWritable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OverallSummaryBuilder.class);
    private static final Comparator<File> FILE_AGE = (a, b) -> {
        long diff = a.lastModified() - b.lastModified();
        return diff > 0L ? 1 : (diff < 0L ? -1 : 0);
    };
    private static final FilenameFilter SUMMARY_FILTER = (dir, name) -> name.startsWith("summary") && name.endsWith(".xml");
    private final File directory;
    private final String logFileName;
    private @Nullable Long group = null;
    private @Nullable DailySummary todaySummary = null;

    public OverallSummaryBuilder(XLoggerAdaptor xlogger) {
        this.directory = xlogger.getDirectory();
        this.logFileName = xlogger.getLogFileName();
    }

    public void setGroup(Long group) {
        this.group = group;
    }

    public @Nullable Long getGroup() {
        return this.group;
    }

    public void build() throws XLogException {
        XLoggerAdaptor.ensureRollover();
        List<String> dates = this.getLogFileDates(this.directory);
        for (String date : dates) {
            File f = DailySummary.getSummaryFile(this.directory, date);
            if (f.exists()) continue;
            LOGGER.info("Generating daily summary for {} in {}", (Object)date, (Object)this.directory.getName());
            DailySummary daily = new DailySummary(this.directory);
            daily.setGroupBy(DailySummary.GroupBy.HOUR);
            try {
                daily.setDate(ISO8601.parseAuto((String)date));
                daily.build();
                daily.save();
            }
            catch (ParseException ex) {
                throw new XLogException(ex);
            }
            catch (IOException ex) {
                throw new XLogException("Unable to save the summary for " + date, ex);
            }
        }
        DailySummary todays = new DailySummary(this.directory);
        todays.setGroup(this.group);
        todays.build();
        this.todaySummary = todays;
    }

    private List<String> getLogFileDates(File directory) {
        ArrayList<String> dates = new ArrayList<String>();
        String today = ISO8601.today();
        String[] logFiles = directory.list();
        if (logFiles == null) {
            throw new IllegalStateException("Unable to list files in log directory!");
        }
        for (String name : logFiles) {
            String date;
            int dashIndex = name.indexOf(45);
            if (!name.endsWith(".xlog") || dashIndex <= 0 || dates.contains(date = name.substring(dashIndex + 1, name.indexOf(46))) || today.equals(date)) continue;
            dates.add(date);
        }
        return dates;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("root", true);
        File[] summaries = this.directory.listFiles(SUMMARY_FILTER);
        if (summaries == null) {
            throw new IllegalStateException("Unable to list file in log directory!");
        }
        Arrays.sort(summaries, FILE_AGE);
        GroupFilter collector = new GroupFilter(xml, this.group);
        try {
            if (this.todaySummary != null && !this.todaySummary.isEmpty()) {
                this.todaySummary.toXML(xml);
            }
            SAXParserFactory factory = XMLHelpers.safeSAXParserFactory();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            SAXParser parser = factory.newSAXParser();
            for (File summary : summaries) {
                int dash = summary.getName().indexOf(45);
                String date = summary.getName().substring(dash + 1, summary.getName().indexOf(46));
                String logName = this.logFileName.replace(".", "-" + date + ".0.");
                File logFile = new File(this.directory, logName);
                if (logFile.exists()) {
                    OverallSummaryBuilder.parse(summary, parser, collector);
                    continue;
                }
                LOGGER.debug("Deleting summary log file {} as log file {} does not exist", (Object)summary.getName(), (Object)logFile.getName());
                this.deleteOldSummary(summary);
            }
        }
        catch (ParserConfigurationException | SAXException ex) {
            LOGGER.error("Unable to generate log summary", (Throwable)ex);
        }
        xml.closeElement();
    }

    private void deleteOldSummary(File summary) {
        try {
            Files.delete(summary.toPath());
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to delete summary log file {}", (Object)summary.getName(), (Object)ex);
        }
    }

    private static void parse(File xlog, SAXParser parser, DefaultHandler handler) throws IOException {
        try (FileInputStream in = new FileInputStream(xlog);){
            WrappingReader reader = new WrappingReader(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8), "<events>", "</events>");
            InputSource source = new InputSource(reader);
            parser.parse(source, handler);
        }
        catch (SAXException ex) {
            LOGGER.error("unable to generate log summary", (Throwable)ex);
        }
    }

    private static class GroupFilter
    extends DefaultHandler {
        private final @Nullable String groupId;
        private final XMLWriter xml;
        private @Nullable String date;
        private final Deque<String> elements = new ArrayDeque<String>();
        private boolean include;
        private boolean inSummary;

        public GroupFilter(XMLWriter xml, @Nullable Long group) {
            this.xml = xml;
            this.groupId = group != null ? group.toString() : null;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            try {
                if ("summary".equals(qName)) {
                    this.date = attributes.getValue("date");
                } else if ("group".equals(qName) && (this.groupId == null || this.groupId.equals(attributes.getValue("id")))) {
                    this.include = true;
                    if (!this.inSummary) {
                        this.xml.openElement("summary", true);
                        this.xml.attribute("date", this.date);
                        this.inSummary = true;
                    }
                }
                if (this.include) {
                    this.xml.openElement(qName, true);
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        String name = attributes.getQName(i);
                        String value = attributes.getValue(i);
                        this.xml.attribute(name, value);
                    }
                }
            }
            catch (IOException ex) {
                throw new SAXException("Error while filtering log content", ex);
            }
            this.elements.push(qName);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.elements.remove();
            try {
                if (this.include) {
                    this.xml.closeElement();
                }
                if ("group".equals(qName)) {
                    this.include = false;
                } else if (this.inSummary && "summary".equals(qName)) {
                    this.xml.closeElement();
                    this.inSummary = false;
                }
            }
            catch (IOException ex) {
                throw new SAXException("Error while filtering log content", ex);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String element = this.elements.peek();
            if (this.include && !"group".equals(element)) {
                try {
                    this.xml.writeText(ch, start, length);
                }
                catch (IOException ex) {
                    throw new SAXException("Error while filtering log content", ex);
                }
            }
        }
    }
}

