/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.logback;

import com.pageseeder.base.logback.DailyLogFileFilter;
import com.pageseeder.base.logback.XLogs;
import com.pageseeder.base.mail.MailLogger;
import com.pageseeder.base.util.XMLHelpers;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.pageseeder.xmlwriter.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MailLogHandler
extends DefaultHandler {
    private final XMLWriter xml;
    private final long start;
    private final long end;
    private long currentPosition = 1L;
    private boolean hasMore = false;
    private boolean started = false;
    private static final Comparator<File> FILE_AGE = (a, b) -> {
        long diff = a.lastModified() - b.lastModified();
        return diff > 0L ? 1 : (diff < 0L ? -1 : 0);
    };

    public MailLogHandler(XMLWriter xml, long page, long pagesize) {
        this.xml = xml;
        this.start = (page - 1L) * pagesize;
        this.end = this.start + pagesize;
    }

    public static void parseDayLogs(Date date, XMLWriter xml, long page, long pagesize) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = XMLHelpers.safeSAXParserFactory();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        File[] xlogs = MailLogger.getInstance().getDirectory().listFiles(new DailyLogFileFilter(date, ".xlog"));
        if (xlogs == null) {
            throw new IllegalStateException("Unable to list file in log directory!");
        }
        Arrays.sort(xlogs, FILE_AGE);
        if (xlogs.length == 0) {
            return;
        }
        MailLogHandler handler = new MailLogHandler(xml, page, pagesize);
        xml.openElement("events");
        for (File xlog : xlogs) {
            XLogs.parse(xlog, parser, handler);
        }
        if (handler.hasMore) {
            xml.element("more", "true");
        }
        xml.closeElement();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("event".equals(qName)) {
            this.started = true;
        }
        try {
            if (this.validPosition()) {
                this.xml.openElement(qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String name = attributes.getQName(i);
                    String value = attributes.getValue(i);
                    this.xml.attribute(name, value);
                }
            } else if (this.currentPosition > this.end) {
                this.hasMore = true;
            }
        }
        catch (IOException ex) {
            throw new SAXException("Error while filtering log content", ex);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("events".equals(qName)) {
            this.started = false;
        }
        if (this.validPosition()) {
            try {
                this.xml.closeElement();
            }
            catch (IOException ex) {
                throw new SAXException("Error while filtering log content", ex);
            }
        }
        if ("event".equals(qName)) {
            ++this.currentPosition;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.validPosition()) {
            try {
                this.xml.writeText(ch, start, length);
            }
            catch (IOException ex) {
                throw new SAXException("Error while filtering log content", ex);
            }
        }
    }

    private boolean validPosition() {
        return this.started && this.currentPosition > this.start && (this.end < 0L || this.currentPosition <= this.end);
    }
}

